/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.memoryobjects;

import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlNavigation;
import emi.serializer.utils.UmlSerializerExtensions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class Operations {
    private final Map<Class, List<Operation>> mappingOperations;

    public Operations(ResourceManager rm) {
        HashMap<Class, List<Operation>> _hashMap = new HashMap<Class, List<Operation>>();
        this.mappingOperations = _hashMap;
        List<Class> _classes = UmlNavigation.getClasses(rm);
        Consumer<Class> _function = it -> {
            List<Operation> operations = Operations.getOperations(it);
            this.mappingOperations.put((Class)it, operations);
        };
        _classes.forEach(_function);
    }

    private String operationTypeToC(Operation e, Class c) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"UML_Operation * ");
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)";");
        return _builder.toString();
    }

    private String operationToC(Operation e, Class c) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)".");
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" = &");
        String _variableName = UmlSerializerExtensions.variableName((EObject)e);
        _builder.append((Object)_variableName, "");
        return _builder.toString();
    }

    public static List<Operation> getOperations(Class e) {
        ArrayList<Operation> _xblockexpression = null;
        ArrayList<Operation> operations = new ArrayList<Operation>();
        List<Class> _inheritanceTree = UmlNavigation.getInheritanceTree((Classifier)e);
        Consumer<Class> _function = it -> Operations.getOwnedOperationsHelper(it, operations);
        _inheritanceTree.forEach(_function);
        _xblockexpression = operations;
        return _xblockexpression;
    }

    private static List<Operation> getOwnedOperationsHelper(Class e, List<Operation> operations) {
        List<Operation> _xblockexpression = null;
        EList _ownedOperations = e.getOwnedOperations();
        Consumer<Operation> _function = it -> {
            boolean _not;
            EList _methods = it.getMethods();
            boolean _isEmpty = _methods.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                boolean operationExist = false;
                int operationIndex = 0;
                for (int i = 0; i < ((Object[])Conversions.unwrapArray((Object)operations, Object.class)).length; ++i) {
                    String _name_1;
                    Operation _get = (Operation)operations.get(i);
                    String _name = _get.getName();
                    boolean _equals = _name.equals(_name_1 = it.getName());
                    if (!_equals) continue;
                    operationExist = true;
                    operationIndex = i;
                }
                if (operationExist) {
                    operations.set(operationIndex, (Operation)it);
                } else {
                    operations.add((Operation)it);
                }
            }
        };
        _ownedOperations.forEach(_function);
        _xblockexpression = operations;
        return _xblockexpression;
    }

    private String classOperationTypedefToC(Class e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"typedef struct ");
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_operations ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"_operations;");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String classOperationTypeToC(Class e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"struct ");
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_operations {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        List<Operation> _get = this.mappingOperations.get(e);
        Functions.Function1 _function = it -> this.operationTypeToC((Operation)it, e);
        List _map = ListExtensions.map(_get, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"\n");
        _builder.append((Object)_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"};");
        _builder.newLine();
        return _builder.toString();
    }

    private String classOperationToC(Class e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Operations type for the ");
        String _name = e.getName();
        _builder.append((Object)_name, " ");
        _builder.append((Object)" class.");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"_operations ");
        String _name_2 = e.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)"_operations_vtable = {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        List<Operation> _get = this.mappingOperations.get(e);
        Functions.Function1 _function = it -> this.operationToC((Operation)it, e);
        List _map = ListExtensions.map(_get, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)",\n");
        _builder.append((Object)_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"};");
        _builder.newLine();
        return _builder.toString();
    }

    public String serializeHeadersTypedef() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Typedef for operations type.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Set<Map.Entry<Class, List<Operation>>> _entrySet = this.mappingOperations.entrySet();
        Functions.Function1 _function = it -> {
            Class _key = (Class)it.getKey();
            return this.classOperationTypedefToC(_key);
        };
        Iterable _map = IterableExtensions.map(_entrySet, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"\n");
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Structures initializer for operations.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Set<Map.Entry<Class, List<Operation>>> _entrySet = this.mappingOperations.entrySet();
        Functions.Function1 _function = it -> {
            Class _key = (Class)it.getKey();
            return this.classOperationTypeToC(_key);
        };
        Iterable _map = IterableExtensions.map(_entrySet, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"\n");
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Structures types for operations.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Set<Map.Entry<Class, List<Operation>>> _entrySet = this.mappingOperations.entrySet();
        Functions.Function1 _function = it -> {
            Class _key = (Class)it.getKey();
            List<Operation> _get = this.mappingOperations.get(_key);
            int _length = ((Object[])Conversions.unwrapArray(_get, Object.class)).length;
            return _length != 0;
        };
        Iterable _filter = IterableExtensions.filter(_entrySet, (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> {
            Class _key = (Class)it.getKey();
            return this.classOperationToC(_key);
        };
        Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"\n");
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }
}

