/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.memoryobjects;

import emi.serializer.memoryobjects.PropertiesRO;
import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlNavigation;
import emi.serializer.utils.UmlSerializerExtensions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class ClassInfo {
    private final List<Class> classes;
    private final PropertiesRO propertiesRO;

    public ClassInfo(ResourceManager rm) {
        PropertiesRO _propertiesRO;
        List<Class> _classes = UmlNavigation.getClasses(rm);
        this.classes = _classes;
        this.propertiesRO = _propertiesRO = new PropertiesRO(rm);
    }

    private List<Pair<Property, Boolean>> getProperties(Class c) {
        ArrayList<Pair<Property, Boolean>> _xblockexpression = null;
        ArrayList<Pair<Property, Boolean>> props = new ArrayList<Pair<Property, Boolean>>();
        HashSet<Property> _readOnlyAttributes = this.propertiesRO.getReadOnlyAttributes(c);
        Consumer<Property> _function = it -> {
            Pair _pair = new Pair(it, (Object)false);
            props.add(_pair);
        };
        _readOnlyAttributes.forEach(_function);
        List<Property> _readWriteAttributes = ClassInfo.getReadWriteAttributes(c);
        Consumer<Property> _function_1 = it -> {
            Pair _pair = new Pair(it, (Object)true);
            props.add(_pair);
        };
        _readWriteAttributes.forEach(_function_1);
        _xblockexpression = props;
        return _xblockexpression;
    }

    public static List<Property> getReadWriteAttributes(Class c) {
        EList _ownedAttributes = c.getOwnedAttributes();
        Functions.Function1 _function = it -> {
            Type _type = it.getType();
            return !(_type instanceof Class);
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_ownedAttributes, (Functions.Function1)_function);
        return IterableExtensions.toList((Iterable)_filter);
    }

    private CharSequence serializeMutabilityTypedefToC(Class c) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"typedef struct ");
        String _name = c.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_mutability ");
        String _name_1 = c.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"_mutability;");
        return _builder;
    }

    private CharSequence serializeMutabilityStructToC(Class c) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"struct ");
        String _name = c.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_mutability {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        List<Class> _inheritanceTree = UmlNavigation.getInheritanceTree((Classifier)c);
        Functions.Function1 _function = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"ABSTRACT_MUTABILITY_");
            String _name_1 = it.getName();
            _builder_1.append((Object)_name_1, "");
            return _builder_1.toString();
        };
        List _map = ListExtensions.map(_inheritanceTree, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"\n");
        _builder.append((Object)_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"};");
        _builder.newLine();
        return _builder;
    }

    private CharSequence serializeMutabilityMacro(Class c) {
        StringConcatenation _xblockexpression = null;
        ArrayList<Property> props = new ArrayList<Property>();
        HashSet<Property> _readOnlyAttributes = this.propertiesRO.getReadOnlyAttributes(c);
        props.addAll(_readOnlyAttributes);
        List<Property> _readWriteAttributes = ClassInfo.getReadWriteAttributes(c);
        props.addAll(_readWriteAttributes);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"#define ABSTRACT_MUTABILITY_");
        String _name = c.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"  ");
        Functions.Function1 _function = it -> this.serializeMutabilityFieldToC((Property)it);
        List _map = ListExtensions.map(props, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"\t\\\n\t");
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence serializeMutabilityFieldToC(Property e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"bool ");
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_isMutable\t\t:1;");
        return _builder;
    }

    private CharSequence serializeTypedefPropertiesTypesToC(Class c) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"typedef struct ");
        String _name = c.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_PropertiesTypes ");
        String _name_1 = c.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"_PropertiesTypes;");
        return _builder;
    }

    private CharSequence serializePropertiesTypesStructToC(Class c) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"struct ");
        String _name = c.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_PropertiesTypes {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        List<Class> _inheritanceTree = UmlNavigation.getInheritanceTree((Classifier)c);
        Functions.Function1 _function = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"ABSTRACT_PROPERTIES_TYPE_");
            String _name_1 = it.getName();
            _builder_1.append((Object)_name_1, "");
            return _builder_1.toString();
        };
        List _map = ListExtensions.map(_inheritanceTree, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"\n");
        _builder.append((Object)_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"};");
        _builder.newLine();
        return _builder;
    }

    private CharSequence serializePropertiesTypesMacro(Class c) {
        StringConcatenation _xblockexpression = null;
        List<Pair<Property, Boolean>> props = this.getProperties(c);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"#define ABSTRACT_PROPERTIES_TYPE_");
        String _name = c.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"  ");
        Functions.Function1 _function = it -> {
            Property _key = (Property)it.getKey();
            Boolean _value = (Boolean)it.getValue();
            return this.serializePropertiesTypesFieldToC(_key, _value, c);
        };
        List _map = ListExtensions.map(props, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"\t\\\n\t");
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence serializePropertiesTypesFieldToC(Property e, boolean isMutable, Class c) {
        StringConcatenation _xifexpression = null;
        if (isMutable) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = c.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)"_od * ");
            String _name_1 = e.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)"_type;");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _name_2 = c.getName();
            _builder_1.append((Object)_name_2, "");
            _builder_1.append((Object)"_properties_ro * ");
            String _name_3 = e.getName();
            _builder_1.append((Object)_name_3, "");
            _builder_1.append((Object)"_type;");
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    private CharSequence serializeTypedefToC(Class c) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"typedef struct ");
        String _name = c.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_classInfo ");
        String _name_1 = c.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"_classInfo;");
        return _builder;
    }

    private CharSequence serializeStructToC(Class c) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"struct ");
        String _name = c.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_classInfo {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"union {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"UML_Class * type;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"const ");
        String _name_1 = c.getName();
        _builder.append((Object)_name_1, "\t\t");
        _builder.append((Object)"_PropertiesTypes * properties_types; // Should not be dereferenced");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _name_2 = c.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append((Object)"_mutability mutability;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"};");
        _builder.newLine();
        return _builder;
    }

    private CharSequence serializeStructInitializerToC(Classifier e) {
        StringConcatenation _xblockexpression = null;
        ArrayList props = new ArrayList();
        List<Class> _inheritanceTree = UmlNavigation.getInheritanceTree(e);
        Consumer<Class> _function = it -> {
            HashSet<Property> _readOnlyAttributes = this.propertiesRO.getReadOnlyAttributes((Class)it);
            Consumer<Property> _function_1 = it_1 -> {
                Pair _pair = new Pair(it_1, (Object)false);
                props.add(_pair);
            };
            _readOnlyAttributes.forEach(_function_1);
            List<Property> _readWriteAttributes = ClassInfo.getReadWriteAttributes(it);
            Consumer<Property> _function_2 = it_1 -> {
                Pair _pair = new Pair(it_1, (Object)true);
                props.add(_pair);
            };
            _readWriteAttributes.forEach(_function_2);
        };
        _inheritanceTree.forEach(_function);
        StringConcatenation _builder = new StringConcatenation();
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_classInfo ");
        String _actualName = UmlSerializerExtensions.actualName((EObject)e);
        _builder.append((Object)_actualName, "");
        _builder.append((Object)"_classInfo = {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)".type = &");
        String _variableName = UmlSerializerExtensions.variableName((EObject)e);
        _builder.append((Object)_variableName, "\t");
        _builder.append((Object)",");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)".mutability = {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        Functions.Function1 _function_1 = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            Property _key = (Property)it.getKey();
            Boolean _value = (Boolean)it.getValue();
            CharSequence _serializeMutabilityFieldInitializerToC = this.serializeMutabilityFieldInitializerToC(_key, _value);
            _builder_1.append((Object)_serializeMutabilityFieldInitializerToC, "");
            return _builder_1.toString();
        };
        List _map = ListExtensions.map(props, (Functions.Function1)_function_1);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)",\n");
        _builder.append((Object)_join, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence serializeMutabilityFieldInitializerToC(Property e, boolean isMutable) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)".");
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_isMutable = ");
        _builder.append((Object)isMutable, "");
        return _builder;
    }

    public String serializeHeadersTypedef() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Typedef for mutability of properties.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.serializeMutabilityTypedefToC((Class)it);
        List _map = ListExtensions.map(this.classes, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"\n");
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Typedef for properties types.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> this.serializeTypedefPropertiesTypesToC((Class)it);
        List _map_1 = ListExtensions.map(this.classes, (Functions.Function1)_function_1);
        String _join_1 = IterableExtensions.join((Iterable)_map_1, (CharSequence)"\n");
        _builder.append((Object)_join_1, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Typedef for class information.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Functions.Function1 _function_2 = it -> this.serializeTypedefToC((Class)it);
        List _map_2 = ListExtensions.map(this.classes, (Functions.Function1)_function_2);
        String _join_2 = IterableExtensions.join((Iterable)_map_2, (CharSequence)"\n");
        _builder.append((Object)_join_2, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Macros for the mutability field of mutability structure.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.serializeMutabilityMacro((Class)it);
        List _map = ListExtensions.map(this.classes, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"\n");
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Mutability structures.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> this.serializeMutabilityStructToC((Class)it);
        List _map_1 = ListExtensions.map(this.classes, (Functions.Function1)_function_1);
        String _join_1 = IterableExtensions.join((Iterable)_map_1, (CharSequence)"\n");
        _builder.append((Object)_join_1, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Macros for the properties_types field of properties type structure.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Functions.Function1 _function_2 = it -> this.serializePropertiesTypesMacro((Class)it);
        List _map_2 = ListExtensions.map(this.classes, (Functions.Function1)_function_2);
        String _join_2 = IterableExtensions.join((Iterable)_map_2, (CharSequence)"\n");
        _builder.append((Object)_join_2, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Properties type structures.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Functions.Function1 _function_3 = it -> this.serializePropertiesTypesStructToC((Class)it);
        List _map_3 = ListExtensions.map(this.classes, (Functions.Function1)_function_3);
        String _join_3 = IterableExtensions.join((Iterable)_map_3, (CharSequence)"\n");
        _builder.append((Object)_join_3, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Class information structures.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Functions.Function1 _function_4 = it -> this.serializeStructToC((Class)it);
        List _map_4 = ListExtensions.map(this.classes, (Functions.Function1)_function_4);
        String _join_4 = IterableExtensions.join((Iterable)_map_4, (CharSequence)"\n");
        _builder.append((Object)_join_4, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Class information initializers.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.serializeStructInitializerToC((Classifier)it);
        List _map = ListExtensions.map(this.classes, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"\n");
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }
}

