/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.actionlanguage.C;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import emi.serializer.memoryobjects.OperationParameters;
import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlSerializerExtensions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ActionLanguageC {
    public static final String C_LANGUAGE_NAME = "C";
    private final List<OpaqueExpression> opaqueExpressions;
    private final List<OpaqueBehavior> opaqueBehaviors;
    private final List<Operation> operations;

    public ActionLanguageC(ResourceManager rm) {
        List _map;
        Function<Resource, List> _function = it -> {
            TreeIterator _allContents = it.getAllContents();
            UnmodifiableIterator _filter = Iterators.filter((Iterator)_allContents, Transition.class);
            return IteratorExtensions.toList((Iterator)_filter);
        };
        List transitions = rm.getList(_function);
        Function<Resource, List> _function_1 = it -> {
            TreeIterator _allContents = it.getAllContents();
            UnmodifiableIterator _filter = Iterators.filter((Iterator)_allContents, State.class);
            return IteratorExtensions.toList((Iterator)_filter);
        };
        List states = rm.getList(_function_1);
        Functions.Function1 _function_2 = it -> {
            Constraint _guard = it.getGuard();
            return _guard != null;
        };
        Iterable _filter = IterableExtensions.filter(transitions, (Functions.Function1)_function_2);
        List _list = IterableExtensions.toList((Iterable)_filter);
        Functions.Function1 _function_3 = it -> {
            Constraint _guard = it.getGuard();
            ValueSpecification _specification = _guard.getSpecification();
            return _specification != null;
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_list, (Functions.Function1)_function_3);
        List _list_1 = IterableExtensions.toList((Iterable)_filter_1);
        Functions.Function1 _function_4 = it -> {
            Constraint _guard = it.getGuard();
            ValueSpecification _specification = _guard.getSpecification();
            return (OpaqueExpression)_specification;
        };
        this.opaqueExpressions = _map = ListExtensions.map((List)_list_1, (Functions.Function1)_function_4);
        ArrayList<OpaqueBehavior> _arrayList = new ArrayList<OpaqueBehavior>();
        this.opaqueBehaviors = _arrayList;
        Functions.Function1 _function_5 = it -> {
            Behavior _effect = it.getEffect();
            return _effect != null;
        };
        Iterable _filter_2 = IterableExtensions.filter(transitions, (Functions.Function1)_function_5);
        List _list_2 = IterableExtensions.toList((Iterable)_filter_2);
        Functions.Function1 _function_6 = it -> {
            Behavior _effect = it.getEffect();
            return (OpaqueBehavior)_effect;
        };
        List _map_1 = ListExtensions.map((List)_list_2, (Functions.Function1)_function_6);
        this.opaqueBehaviors.addAll(_map_1);
        Functions.Function1 _function_7 = it -> {
            Behavior _entry = it.getEntry();
            return _entry != null;
        };
        Iterable _filter_3 = IterableExtensions.filter(states, (Functions.Function1)_function_7);
        List _list_3 = IterableExtensions.toList((Iterable)_filter_3);
        Functions.Function1 _function_8 = it -> {
            Behavior _entry = it.getEntry();
            return (OpaqueBehavior)_entry;
        };
        List _map_2 = ListExtensions.map((List)_list_3, (Functions.Function1)_function_8);
        this.opaqueBehaviors.addAll(_map_2);
        Functions.Function1 _function_9 = it -> {
            Behavior _exit = it.getExit();
            return _exit != null;
        };
        Iterable _filter_4 = IterableExtensions.filter(states, (Functions.Function1)_function_9);
        List _list_4 = IterableExtensions.toList((Iterable)_filter_4);
        Functions.Function1 _function_10 = it -> {
            Behavior _exit = it.getExit();
            return (OpaqueBehavior)_exit;
        };
        List _map_3 = ListExtensions.map((List)_list_4, (Functions.Function1)_function_10);
        this.opaqueBehaviors.addAll(_map_3);
        Function<Resource, List> _function_11 = it -> {
            TreeIterator _allContents = it.getAllContents();
            UnmodifiableIterator _filter_5 = Iterators.filter((Iterator)_allContents, Operation.class);
            return IteratorExtensions.toList((Iterator)_filter_5);
        };
        List _list_5 = rm.getList(_function_11);
        this.operations = _list_5;
    }

    private String getReturnTypeInC(Operation e) {
        String _xblockexpression = null;
        String returnType = "void";
        Parameter returnParameter = OperationParameters.getReturnParameter(e);
        if (returnParameter != null) {
            String _typeNameToC;
            Type _type = returnParameter.getType();
            returnType = _typeNameToC = UmlSerializerExtensions.typeNameToC(_type);
        }
        _xblockexpression = returnType;
        return _xblockexpression;
    }

    private String prototypeToC(OpaqueBehavior e) {
        String _xblockexpression = null;
        Class class_ = this.getClassContainer((EObject)e);
        Signal _signalOfTrigger = this.getSignalOfTrigger(e);
        String parametersType = this.getParametersType(_signalOfTrigger);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"static void c_function_");
        String _variableName = UmlSerializerExtensions.variableName((EObject)e);
        _builder.append((Object)_variableName, "");
        _builder.append((Object)"(");
        String _name = class_.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_Object * this, ");
        _builder.append((Object)parametersType, "");
        _builder.append((Object)" params);");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String prototypeToC(OpaqueExpression e) {
        String _xblockexpression = null;
        Class class_ = this.getClassContainer((EObject)e);
        Signal _signalOfTrigger = this.getSignalOfTrigger(e);
        String parametersType = this.getParametersType(_signalOfTrigger);
        int index = -1;
        try {
            int _indexOfLanguageC;
            EList _languages = e.getLanguages();
            index = _indexOfLanguageC = ActionLanguageC.getIndexOfLanguageC((EList<String>)_languages);
        }
        catch (Throwable _t) {
            if (_t instanceof NoSuchElementException) {
                NoSuchElementException ex = (NoSuchElementException)_t;
                System.err.println("C language was not found for opaque expression " + e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        String _xifexpression = null;
        if (index != -1) {
            boolean _not;
            String _xblockexpression_1 = null;
            EList _bodies = e.getBodies();
            String body = (String)_bodies.get(index);
            String _xifexpression_1 = null;
            boolean _contentEquals = "else".contentEquals(body);
            boolean bl = _not = !_contentEquals;
            if (_not) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"static bool c_function_");
                String _variableName = UmlSerializerExtensions.variableName((EObject)e);
                _builder.append((Object)_variableName, "");
                _builder.append((Object)"(");
                String _name = class_.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)"_Object * this, ");
                _builder.append((Object)parametersType, "");
                _builder.append((Object)" params);");
                _builder.newLineIfNotEmpty();
                _xifexpression_1 = _builder.toString();
            } else {
                _xifexpression_1 = "";
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        } else {
            _xifexpression = "";
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private String prototypeToC(Operation e) {
        String _xblockexpression = null;
        Class class_ = this.getClassContainer((EObject)e);
        String parametersType = OperationParameters.getOperationParametersStructName(e);
        EList _methods = e.getMethods();
        Behavior _head = (Behavior)IterableExtensions.head((Iterable)_methods);
        OpaqueBehavior ob = (OpaqueBehavior)_head;
        String returnType = this.getReturnTypeInC(e);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"static ");
        _builder.append((Object)returnType, "");
        _builder.append((Object)" c_function_");
        String _variableName = UmlSerializerExtensions.variableName((EObject)ob);
        _builder.append((Object)_variableName, "");
        _builder.append((Object)"(");
        String _name = class_.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_Object * this, ");
        _builder.append((Object)parametersType, "");
        _builder.append((Object)" * params);");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private Class getClassContainer(EObject e) {
        Class _xblockexpression = null;
        EObject classContainer = e;
        while (!classContainer.eClass().getName().equals("Class")) {
            EObject _eContainer;
            classContainer = _eContainer = classContainer.eContainer();
        }
        _xblockexpression = (Class)classContainer;
        return _xblockexpression;
    }

    private Transition getTransitionContainer(EObject e) {
        Transition _xblockexpression = null;
        EObject trContainer = e;
        while (trContainer != null && !(trContainer instanceof Transition)) {
            EObject _eContainer;
            trContainer = _eContainer = trContainer.eContainer();
        }
        _xblockexpression = (Transition)trContainer;
        return _xblockexpression;
    }

    private Signal getSignalOfTrigger(OpaqueBehavior e) {
        Signal _xblockexpression = null;
        Signal signal = null;
        if (e.eContainer() != null && e.eContainer() instanceof Transition) {
            EList _triggers;
            Trigger trigger;
            EObject _eContainer = e.eContainer();
            Transition transition = (Transition)_eContainer;
            while (transition != null && transition.getSource() instanceof Pseudostate) {
                boolean _equals;
                Vertex _source = transition.getSource();
                EList _incomings = _source.getIncomings();
                int _length = ((Object[])Conversions.unwrapArray((Object)_incomings, Object.class)).length;
                boolean bl = _equals = _length == 1;
                if (_equals) {
                    Transition _head;
                    Vertex _source_1 = transition.getSource();
                    EList _incomings_1 = _source_1.getIncomings();
                    transition = _head = (Transition)IterableExtensions.head((Iterable)_incomings_1);
                    continue;
                }
                transition = null;
            }
            if (transition != null && (trigger = (Trigger)IterableExtensions.head((Iterable)(_triggers = transition.getTriggers()))) != null) {
                Signal _signal;
                Event _event = trigger.getEvent();
                signal = _signal = ((SignalEvent)_event).getSignal();
            }
        }
        _xblockexpression = signal;
        return _xblockexpression;
    }

    private Signal getSignalOfTrigger(OpaqueExpression e) {
        Signal _xblockexpression = null;
        Signal signal = null;
        Transition transition = null;
        EObject constraint = e.eContainer();
        if (constraint != null && constraint.eContainer() != null && constraint.eContainer() instanceof Transition) {
            EList _triggers;
            Trigger trigger;
            EObject _eContainer = constraint.eContainer();
            transition = (Transition)_eContainer;
            Vertex source = transition.getSource();
            while (source instanceof Pseudostate) {
                Vertex _source;
                Transition _head;
                EList _incomings = ((Pseudostate)source).getIncomings();
                transition = _head = (Transition)IterableExtensions.head((Iterable)_incomings);
                source = _source = transition.getSource();
            }
            if (transition != null && (trigger = (Trigger)IterableExtensions.head((Iterable)(_triggers = transition.getTriggers()))) != null) {
                Signal _signal;
                Event _event = trigger.getEvent();
                signal = _signal = ((SignalEvent)_event).getSignal();
            }
        }
        _xblockexpression = signal;
        return _xblockexpression;
    }

    private String getParametersType(Signal signal) {
        String _xblockexpression = null;
        String parametersType = null;
        if (signal != null) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = signal.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)"_signal_parameters *");
            parametersType = _builder.toString();
        } else {
            parametersType = "void *";
        }
        _xblockexpression = parametersType;
        return _xblockexpression;
    }

    public static int getIndexOfLanguageC(EList<String> languages) {
        int index = -1;
        for (int i = 0; i < languages.size() && index == -1; ++i) {
            String _get = (String)languages.get(i);
            boolean _equals = _get.equals(C_LANGUAGE_NAME);
            if (!_equals) continue;
            index = i;
        }
        if (index == -1) {
            throw new NoSuchElementException("C language not found");
        }
        return index;
    }

    private String toC(OpaqueBehavior e) {
        String _xblockexpression = null;
        Signal _signalOfTrigger = this.getSignalOfTrigger(e);
        String parametersType = this.getParametersType(_signalOfTrigger);
        int index = -1;
        try {
            int _indexOfLanguageC;
            EList _languages = e.getLanguages();
            index = _indexOfLanguageC = ActionLanguageC.getIndexOfLanguageC((EList<String>)_languages);
        }
        catch (Throwable _t) {
            if (_t instanceof NoSuchElementException) {
                NoSuchElementException ex = (NoSuchElementException)_t;
                System.err.println("C language was not found for opaque expression " + e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        Class class_ = this.getClassContainer((EObject)e);
        Transition transition = this.getTransitionContainer((EObject)e);
        String _xifexpression = null;
        if (index != -1) {
            String _xblockexpression_1 = null;
            EList _bodies = e.getBodies();
            String _get = (String)_bodies.get(index);
            String body = _get.replaceAll(";\\s+", ";\n");
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"/*");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* Opaque behavior for the class ");
            String _name = class_.getName();
            _builder.append((Object)_name, " ");
            _builder.append((Object)".");
            _builder.newLineIfNotEmpty();
            StringConcatenation _xifexpression_1 = null;
            if (transition != null) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)" ");
                _builder_1.append((Object)"* Of transition \"");
                String _name_1 = transition.getName();
                _builder_1.append((Object)_name_1, " ");
                _builder_1.append((Object)"\" from \"");
                Vertex _source = transition.getSource();
                String _name_2 = _source.getName();
                _builder_1.append((Object)_name_2, " ");
                _builder_1.append((Object)"\" to \"");
                Vertex _target = transition.getTarget();
                String _name_3 = _target.getName();
                _builder_1.append((Object)_name_3, " ");
                _builder_1.append((Object)"\".");
                _xifexpression_1 = _builder_1;
            }
            _builder.append(_xifexpression_1, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"static void c_function_");
            String _variableName = UmlSerializerExtensions.variableName((EObject)e);
            _builder.append((Object)_variableName, "");
            _builder.append((Object)"(");
            String _name_4 = class_.getName();
            _builder.append((Object)_name_4, "");
            _builder.append((Object)"_Object * this, ");
            _builder.append((Object)parametersType, "");
            _builder.append((Object)" params) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)body, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
            _xifexpression = _xblockexpression_1 = _builder.toString();
        } else {
            _xifexpression = "";
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private String toC(OpaqueExpression e) {
        String _xblockexpression = null;
        Signal _signalOfTrigger = this.getSignalOfTrigger(e);
        String parametersType = this.getParametersType(_signalOfTrigger);
        int index = -1;
        try {
            int _indexOfLanguageC;
            EList _languages = e.getLanguages();
            index = _indexOfLanguageC = ActionLanguageC.getIndexOfLanguageC((EList<String>)_languages);
        }
        catch (Throwable _t) {
            if (_t instanceof NoSuchElementException) {
                NoSuchElementException ex = (NoSuchElementException)_t;
                System.err.println("C language was not found for opaque expression " + e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        Class class_ = this.getClassContainer((EObject)e);
        Transition transition = this.getTransitionContainer((EObject)e);
        String _xifexpression = null;
        if (index != -1) {
            boolean _not;
            String _xblockexpression_1 = null;
            EList _bodies = e.getBodies();
            String body = (String)_bodies.get(index);
            String _xifexpression_1 = null;
            boolean _contentEquals = "else".contentEquals(body);
            boolean bl = _not = !_contentEquals;
            if (_not) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"/*");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* Opaque expression for the class ");
                String _name = class_.getName();
                _builder.append((Object)_name, " ");
                _builder.append((Object)".");
                _builder.newLineIfNotEmpty();
                StringConcatenation _xifexpression_2 = null;
                if (transition != null) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append((Object)" ");
                    _builder_1.append((Object)"* Of transition \"");
                    String _name_1 = transition.getName();
                    _builder_1.append((Object)_name_1, " ");
                    _builder_1.append((Object)"\" from \"");
                    Vertex _source = transition.getSource();
                    String _name_2 = _source.getName();
                    _builder_1.append((Object)_name_2, " ");
                    _builder_1.append((Object)"\" to \"");
                    Vertex _target = transition.getTarget();
                    String _name_3 = _target.getName();
                    _builder_1.append((Object)_name_3, " ");
                    _builder_1.append((Object)"\".");
                    _xifexpression_2 = _builder_1;
                }
                _builder.append(_xifexpression_2, "");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
                _builder.append((Object)"static bool c_function_");
                String _variableName = UmlSerializerExtensions.variableName((EObject)e);
                _builder.append((Object)_variableName, "");
                _builder.append((Object)"(");
                String _name_4 = class_.getName();
                _builder.append((Object)_name_4, "");
                _builder.append((Object)"_Object * this, ");
                _builder.append((Object)parametersType, "");
                _builder.append((Object)" params) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"return (");
                _builder.append((Object)body, "\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
                _xifexpression_1 = _builder.toString();
            } else {
                _xifexpression_1 = "";
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        } else {
            _xifexpression = "";
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private String toC(Operation e) {
        String _xblockexpression = null;
        Class class_ = this.getClassContainer((EObject)e);
        String parametersType = OperationParameters.getOperationParametersStructName(e);
        EList _methods = e.getMethods();
        Behavior _head = (Behavior)IterableExtensions.head((Iterable)_methods);
        OpaqueBehavior ob = (OpaqueBehavior)_head;
        int index = -1;
        try {
            int _indexOfLanguageC;
            EList _languages = ob.getLanguages();
            index = _indexOfLanguageC = ActionLanguageC.getIndexOfLanguageC((EList<String>)_languages);
        }
        catch (Throwable _t) {
            if (_t instanceof NoSuchElementException) {
                NoSuchElementException ex = (NoSuchElementException)_t;
                System.err.println("C language was not found for opaque behavior " + ob);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        String returnType = this.getReturnTypeInC(e);
        String _xifexpression = null;
        if (index != -1) {
            String _xblockexpression_1 = null;
            EList _bodies = ob.getBodies();
            String body = (String)_bodies.get(index);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"/*");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* Opaque behavior for the operation ");
            String _name = e.getName();
            _builder.append((Object)_name, " ");
            _builder.append((Object)" of class ");
            String _name_1 = class_.getName();
            _builder.append((Object)_name_1, " ");
            _builder.append((Object)".");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"static ");
            _builder.append((Object)returnType, "");
            _builder.append((Object)" c_function_");
            String _variableName = UmlSerializerExtensions.variableName((EObject)ob);
            _builder.append((Object)_variableName, "");
            _builder.append((Object)"(");
            String _name_2 = class_.getName();
            _builder.append((Object)_name_2, "");
            _builder.append((Object)"_Object * this, ");
            _builder.append((Object)parametersType, "");
            _builder.append((Object)" * params) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)body, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
            _xifexpression = _xblockexpression_1 = _builder.toString();
        } else {
            _xifexpression = "";
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String serializeEffectsDeclarations() {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> this.prototypeToC((OpaqueBehavior)it);
        List _map = ListExtensions.map(this.opaqueBehaviors, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map);
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        Functions.Function1 _function_1 = it -> this.prototypeToC((Operation)it);
        List _map_1 = ListExtensions.map(this.operations, (Functions.Function1)_function_1);
        String _join_1 = IterableExtensions.join((Iterable)_map_1);
        _builder.append((Object)_join_1, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serializeEffects() {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> this.toC((OpaqueBehavior)it);
        List _map = ListExtensions.map(this.opaqueBehaviors, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map);
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        Functions.Function1 _function_1 = it -> this.toC((Operation)it);
        List _map_1 = ListExtensions.map(this.operations, (Functions.Function1)_function_1);
        String _join_1 = IterableExtensions.join((Iterable)_map_1);
        _builder.append((Object)_join_1, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serializeGuardsDeclarations() {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> this.prototypeToC((OpaqueExpression)it);
        List _map = ListExtensions.map(this.opaqueExpressions, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map);
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serializeGuards() {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> this.toC((OpaqueExpression)it);
        List _map = ListExtensions.map(this.opaqueExpressions, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map);
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }
}

