/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer;

import emi.serializer.EMISerializerOptions;
import emi.serializer.identifiers.IdentifiersSerializer;
import emi.serializer.metamodel.MetamodelSerializer;
import emi.serializer.metamodel.MetamodelTable;
import emi.serializer.metamodel.OffsetsTableStrategy;
import emi.serializer.model.ModelLoader;
import emi.serializer.model.ModelSerializer;
import emi.serializer.model.ResourceManager;
import emi.serializer.types.Types;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ParserProperties;

public class Main {
    private static EMISerializerOptions options;
    private static final int HELP_WIDTH = 150;

    private static final boolean manageOptions(String ... args) throws CmdLineException, IOException {
        ParserProperties _defaults = ParserProperties.defaults();
        ParserProperties _withOptionSorter = _defaults.withOptionSorter((Comparator)options);
        CmdLineParser parser = new CmdLineParser((Object)options, _withOptionSorter);
        try {
            parser.parseArgument(args);
            if (Main.options.help) {
                Main.printHelp(parser);
            }
            if (Main.options.version) {
                Main.printVersion();
            }
            if (Main.options.help || Main.options.version) {
                return false;
            }
        }
        catch (Throwable _t) {
            if (_t instanceof CmdLineException) {
                CmdLineException e = (CmdLineException)_t;
                Main.printHelp(parser);
                throw e;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return true;
    }

    private static final void printHelp(CmdLineParser parser) {
        System.out.println("Usage:");
        ParserProperties _properties = parser.getProperties();
        _properties.withUsageWidth(150);
        parser.printUsage((OutputStream)System.out);
    }

    private static final void printVersion() {
        System.out.println("Version 0.0.5 (under developement) !");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            boolean _not_4;
            boolean _not_3;
            boolean _not_1;
            block28: {
                EMISerializerOptions _eMISerializerOptions;
                options = _eMISerializerOptions = new EMISerializerOptions();
                boolean exit = false;
                try {
                    boolean _not;
                    boolean _manageOptions = Main.manageOptions(args);
                    exit = _not = !_manageOptions;
                }
                catch (Throwable _t) {
                    if (_t instanceof CmdLineException) {
                        CmdLineException e = (CmdLineException)_t;
                        String _message = e.getMessage();
                        System.err.println(_message);
                        exit = true;
                        break block28;
                    }
                    if (_t instanceof IOException) {
                        IOException e_1 = (IOException)_t;
                        String _message_1 = e_1.getMessage();
                        System.err.println(_message_1);
                        exit = true;
                        break block28;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                finally {
                    if (exit) {
                        System.exit(0);
                    }
                }
            }
            ArrayList<String> models = new ArrayList<String>();
            boolean _isEmpty = Main.options.models.isEmpty();
            boolean bl = _not_1 = !_isEmpty;
            if (_not_1) {
                Main.checkModelFiles(Main.options.models);
                models.addAll(Main.options.models);
            } else if (Main.options.sourceDirectory != null) {
                Main.checkSourceDirectory(Main.options.sourceDirectory);
                List<String> _filesInDirectory = Main.getFilesInDirectory(Main.options.sourceDirectory, ".uml");
                models.addAll(_filesInDirectory);
            } else {
                System.err.println("error: No model given at input.");
                System.exit(1);
            }
            String modelName = null;
            if (Main.options.modelName != null) {
                modelName = Main.options.modelName;
            } else {
                boolean _not_2;
                boolean _isEmpty_1 = Main.options.models.isEmpty();
                boolean bl2 = _not_2 = !_isEmpty_1;
                if (_not_2) {
                    String _computeModelName;
                    String _last = (String)IterableExtensions.last(Main.options.models);
                    String _replaceAll = _last.replaceAll(".*/", "");
                    modelName = _computeModelName = Main.computeModelName(_replaceAll);
                } else if (Main.options.sourceDirectory != null) {
                    String _replaceAll_1;
                    modelName = _replaceAll_1 = Main.options.sourceDirectory.replaceAll(".*/", "");
                } else {
                    System.err.println("error: No model given at input.");
                    System.exit(1);
                }
            }
            File emiModelDir = null;
            if (Main.options.outputDirectory != null) {
                File _file;
                String inOutputDir = Main.options.outputDirectory;
                File inOutputDirFile = new File(inOutputDir);
                if (!inOutputDirFile.exists() || !inOutputDirFile.isDirectory()) {
                    System.err.println("error: " + inOutputDir + " is not a directory");
                    System.exit(1);
                }
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)inOutputDir, "");
                _builder.append((Object)"/");
                _builder.append((Object)modelName, "");
                _builder.append((Object)".emi");
                emiModelDir = _file = new File(_builder.toString());
            } else {
                File _file_1;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)modelName, "");
                _builder_1.append((Object)".emi");
                emiModelDir = _file_1 = new File(_builder_1.toString());
            }
            emiModelDir.mkdir();
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append((Object)emiModelDir, "");
            _builder_2.append((Object)"/");
            _builder_2.append((Object)"atoms/", "");
            File emiModelAtomsDir = new File(_builder_2.toString());
            emiModelAtomsDir.mkdir();
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append((Object)emiModelDir, "");
            _builder_3.append((Object)"/src");
            File emiModelSrcDir = new File(_builder_3.toString());
            emiModelSrcDir.mkdir();
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append((Object)emiModelDir, "");
            _builder_4.append((Object)"/uml");
            File emiModelUmlDir = new File(_builder_4.toString());
            emiModelUmlDir.mkdir();
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append((Object)emiModelDir, "");
            _builder_5.append((Object)"/obp2-config");
            File emiModelConfigDir = new File(_builder_5.toString());
            emiModelConfigDir.mkdir();
            StringConcatenation _builder_6 = new StringConcatenation();
            _builder_6.append((Object)emiModelDir, "");
            _builder_6.append((Object)"/src-models");
            File emiModelSrcModelsDir = new File(_builder_6.toString());
            StringConcatenation _builder_7 = new StringConcatenation();
            _builder_7.append((Object)emiModelSrcDir, "");
            _builder_7.append((Object)"/model.c");
            String outFileModelC = _builder_7.toString();
            StringConcatenation _builder_8 = new StringConcatenation();
            _builder_8.append((Object)emiModelSrcDir, "");
            _builder_8.append((Object)"/model.h");
            String outFileModelH = _builder_8.toString();
            StringConcatenation _builder_9 = new StringConcatenation();
            _builder_9.append((Object)emiModelSrcDir, "");
            _builder_9.append((Object)"/types_calibration.h");
            String outFileTypes = _builder_9.toString();
            StringConcatenation _builder_10 = new StringConcatenation();
            _builder_10.append((Object)emiModelSrcDir, "");
            _builder_10.append((Object)"/metamodel.h");
            String outFileMetamodelH = _builder_10.toString();
            StringConcatenation _builder_11 = new StringConcatenation();
            _builder_11.append((Object)emiModelSrcDir, "");
            _builder_11.append((Object)"/metamodel.c");
            String outFileMetamodelC = _builder_11.toString();
            StringConcatenation _builder_12 = new StringConcatenation();
            _builder_12.append((Object)emiModelSrcDir, "");
            _builder_12.append((Object)"/identifiers.h");
            String outFileIdentifiers = _builder_12.toString();
            ModelLoader modelLoader = new ModelLoader();
            Functions.Function1 _function = it -> modelLoader.load((String)it);
            List modelResources = ListExtensions.map(models, (Functions.Function1)_function);
            ResourceManager rm = new ResourceManager(modelResources);
            MetamodelTable metamodelTable = new MetamodelTable(rm);
            metamodelTable.generate();
            OffsetsTableStrategy strategy = new OffsetsTableStrategy(metamodelTable);
            ModelSerializer modelSerializer = new ModelSerializer(rm, metamodelTable, strategy);
            MetamodelSerializer metamodelSerializer = new MetamodelSerializer(metamodelTable, strategy);
            Types typesSerializer = new Types(rm);
            IdentifiersSerializer identifiersSerializer = new IdentifiersSerializer(rm);
            String sMetamodelC = metamodelSerializer.serialize();
            String sMetamodelH = metamodelSerializer.serializeHeaders();
            String sModelC = modelSerializer.serialize();
            String sModelH = modelSerializer.serializeHeaders();
            String sTypes = typesSerializer.serialize();
            String sIdentifiers = identifiersSerializer.serialize();
            Main.writeInFile(outFileMetamodelH, sMetamodelH);
            Main.writeInFile(outFileMetamodelC, sMetamodelC);
            Main.writeInFile(outFileModelC, sModelC);
            Main.writeInFile(outFileModelH, sModelH);
            Main.writeInFile(outFileTypes, sTypes);
            Main.writeInFile(outFileIdentifiers, sIdentifiers);
            Class<?> _class = Main.class.getClass();
            InputStream makefileEmi = _class.getResourceAsStream("/makefiles/Makefile");
            StringConcatenation _builder_13 = new StringConcatenation();
            String _canonicalPath = emiModelDir.getCanonicalPath();
            _builder_13.append((Object)_canonicalPath, "");
            _builder_13.append((Object)"/Makefile");
            File emiModelDirMakefile = new File(_builder_13.toString());
            Path _path = emiModelDirMakefile.toPath();
            Files.copy(makefileEmi, _path, StandardCopyOption.REPLACE_EXISTING);
            Class<?> _class_1 = Main.class.getClass();
            InputStream makefileConfig = _class_1.getResourceAsStream("/makefiles/Makefile.config");
            StringConcatenation _builder_14 = new StringConcatenation();
            String _canonicalPath_1 = emiModelDir.getCanonicalPath();
            _builder_14.append((Object)_canonicalPath_1, "");
            _builder_14.append((Object)"/Makefile.config");
            File emiModelDirMakefileConfig = new File(_builder_14.toString());
            boolean _exists = emiModelDirMakefileConfig.exists();
            boolean bl3 = _not_3 = !_exists;
            if (_not_3) {
                Path _path_1 = emiModelDirMakefileConfig.toPath();
                Files.copy(makefileConfig, _path_1, StandardCopyOption.REPLACE_EXISTING);
            }
            Class<?> _class_2 = Main.class.getClass();
            InputStream makefileSrc = _class_2.getResourceAsStream("/makefiles/src/Makefile");
            StringConcatenation _builder_15 = new StringConcatenation();
            String _canonicalPath_2 = emiModelSrcDir.getCanonicalPath();
            _builder_15.append((Object)_canonicalPath_2, "");
            _builder_15.append((Object)"/Makefile");
            File emiModelSrcDirMakefile = new File(_builder_15.toString());
            Path _path_2 = emiModelSrcDirMakefile.toPath();
            Files.copy(makefileSrc, _path_2, StandardCopyOption.REPLACE_EXISTING);
            Class<?> _class_3 = Main.class.getClass();
            InputStream makefileAtoms = _class_3.getResourceAsStream("/makefiles/atoms/Makefile");
            StringConcatenation _builder_16 = new StringConcatenation();
            String _canonicalPath_3 = emiModelAtomsDir.getCanonicalPath();
            _builder_16.append((Object)_canonicalPath_3, "");
            _builder_16.append((Object)"/Makefile");
            File emiModelAtomsDirMakefile = new File(_builder_16.toString());
            Path _path_3 = emiModelAtomsDirMakefile.toPath();
            Files.copy(makefileAtoms, _path_3, StandardCopyOption.REPLACE_EXISTING);
            for (String modelFile : models) {
                File umlModelFile = new File(modelFile);
                StringConcatenation _builder_17 = new StringConcatenation();
                String _canonicalPath_4 = emiModelUmlDir.getCanonicalPath();
                _builder_17.append((Object)_canonicalPath_4, "");
                _builder_17.append((Object)"/");
                String _computeModelName_1 = Main.computeModelName(modelFile);
                _builder_17.append((Object)_computeModelName_1, "");
                _builder_17.append((Object)".uml");
                File emiModelUmlDirModel = new File(_builder_17.toString());
                Path _path_4 = umlModelFile.toPath();
                Path _path_5 = emiModelUmlDirModel.toPath();
                Files.move(_path_4, _path_5, StandardCopyOption.REPLACE_EXISTING);
            }
            if (Main.options.sourceDirectory != null) {
                File sourceDirectoryFile = new File(Main.options.sourceDirectory);
                Main.deleteDirectory(emiModelSrcModelsDir);
                Path _path_4 = sourceDirectoryFile.toPath();
                Path _path_5 = emiModelSrcModelsDir.toPath();
                Files.move(_path_4, _path_5, StandardCopyOption.REPLACE_EXISTING);
            }
            Class<?> _class_4 = Main.class.getClass();
            InputStream plugConfig = _class_4.getResourceAsStream("/config/config.emi");
            StringConcatenation _builder_17 = new StringConcatenation();
            String _canonicalPath_4 = emiModelConfigDir.getCanonicalPath();
            _builder_17.append((Object)_canonicalPath_4, "");
            _builder_17.append((Object)"/config.emi");
            File emiModelConfigDirPlug = new File(_builder_17.toString());
            boolean _exists_1 = emiModelConfigDirPlug.exists();
            boolean bl4 = _not_4 = !_exists_1;
            if (_not_4) {
                Path _path_6 = emiModelConfigDirPlug.toPath();
                Files.copy(plugConfig, _path_6, StandardCopyOption.REPLACE_EXISTING);
                String emiHome = System.getenv("EMI_HOME");
                if (emiHome != null) {
                    Main.updateProperty(emiModelConfigDirPlug, "emiHome", emiHome);
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static void writeInFile(String filename, String s) {
        try {
            FileOutputStream _fileOutputStream = new FileOutputStream(filename);
            PrintStream file = new PrintStream(_fileOutputStream);
            file.print(s);
            file.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static void updateProperty(File file, String key, String value) {
        try {
            String _canonicalPath = file.getCanonicalPath();
            Path _get = Paths.get(_canonicalPath, new String[0]);
            byte[] _readAllBytes = Files.readAllBytes(_get);
            String content = new String(_readAllBytes);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)key, "");
            _builder.append((Object)"=");
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)key, "");
            _builder_1.append((Object)"=");
            _builder_1.append((Object)value, "");
            String newContent = content.replaceFirst(_builder.toString(), _builder_1.toString());
            FileWriter output = new FileWriter(file);
            output.write(newContent);
            output.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static void checkModelFiles(List<String> modelFiles) {
        for (String inFile : modelFiles) {
            String model;
            String modelExtension;
            boolean _equals;
            boolean _not;
            File umlModelFile = new File(inFile);
            if (!umlModelFile.exists() || !umlModelFile.isFile()) {
                System.err.println("error: " + inFile + " is not a file");
                System.exit(1);
            }
            if (!(_not = !(_equals = (modelExtension = (model = inFile.replaceAll(".*/", "")).replaceAll(".*\\.", "")).equals("uml")))) continue;
            System.err.println("error: The input file \"" + inFile + "\" is not a UML model. Extension is ." + modelExtension + " but expected .uml");
            System.exit(1);
        }
    }

    private static void checkSourceDirectory(String sourceDirectory) {
        List<String> umlModelFiles;
        boolean _isEmpty;
        File sourceDirectoryFile = new File(sourceDirectory);
        if (!sourceDirectoryFile.exists() || !sourceDirectoryFile.isDirectory()) {
            System.err.println("error: " + sourceDirectoryFile + " is not a directory");
            System.exit(1);
        }
        if (_isEmpty = (umlModelFiles = Main.getFilesInDirectory(sourceDirectory, ".uml")).isEmpty()) {
            System.err.println("error: The input source directory \"" + sourceDirectoryFile + "\" does not contains any .uml files.");
            System.exit(1);
        }
    }

    private static List<String> getFilesInDirectory(String directory, String fileExtension) {
        List _xblockexpression = null;
        File directoryFile = new File(directory);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String _lowerCase = name.toLowerCase();
                return _lowerCase.endsWith(".uml");
            }
        };
        String[] _list = directoryFile.list(filter);
        Functions.Function1 _function = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)directory, "");
            _builder.append((Object)"/");
            _builder.append(it, "");
            return _builder.toString();
        };
        _xblockexpression = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_list)), (Functions.Function1)_function);
        return _xblockexpression;
    }

    private static String computeModelName(String modelFile) {
        String _replaceAll = modelFile.replaceAll(".*/", "");
        return _replaceAll.replaceAll("\\..*", "");
    }

    public static void deleteDirectory(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File f : files) {
                boolean _isDirectory = f.isDirectory();
                if (_isDirectory) {
                    Main.deleteDirectory(f);
                    continue;
                }
                f.delete();
            }
        }
        directory.delete();
    }
}

