/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.model;

import java.io.File;
import java.io.IOException;

public final class EMIModel {
    private static final String INTERPRETER_DIR = "emi-uml-c/";
    public static final String BUILD_DIR = "build/";
    public static final String DEFAULT_TARGET = "host";

    private EMIModel() {
    }

    public static final String checkEMIHome(String emiHome) throws IOException {
        String emiHomePath;
        if (emiHome != null) {
            File emiHomeFile = new File(emiHome);
            if (!emiHomeFile.exists() || !emiHomeFile.isDirectory()) {
                throw new IOException("EMI home directory path: " + emiHome + " does not exist");
            }
            emiHomePath = emiHomeFile.getCanonicalPath();
            File interpreterDirFile = new File(emiHome + "/" + INTERPRETER_DIR);
            if (!interpreterDirFile.exists() || !interpreterDirFile.isDirectory()) {
                throw new IOException("EMI home directory path: " + emiHome + " is not a valid EMI home (" + emiHome + "/" + INTERPRETER_DIR + " does not exist)");
            }
        } else {
            throw new IOException("EMI home is null");
        }
        return emiHomePath;
    }

    public static final String checkEMIModel(String emiModel) throws IOException {
        File emiModelFile;
        if (emiModel != null) {
            emiModelFile = new File(emiModel);
            if (!emiModelFile.exists() || !emiModelFile.isDirectory()) {
                throw new IOException("EMI model: " + emiModel + " does not exist");
            }
        } else {
            throw new IOException("EMI model is null");
        }
        String emiModelPath = emiModelFile.getCanonicalPath();
        return emiModelPath;
    }

    public static final String deduceModelName(String emiModel) {
        String[] nameArray = emiModel.split("/");
        return nameArray[nameArray.length - 1].replaceAll(".emi", "");
    }
}

