/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.server.translator;

import emi.analysis.server.translator.MetaECTreeGeneratorDwarfdump;
import emi.analysis.server.translator.MetaECTreeGeneratorObjdump;
import emi.analysis.server.translator.MetaECTreeGeneratorPahole;
import emi.analysis.server.translator.TranslationBuilderJson;
import emi.analysis.server.translator.Translator;
import java.io.IOException;

public final class TranslatorFactory {
    private TranslatorFactory() {
    }

    public static Translator buildTranslator(String emiModel, String target, String dwarfTool, boolean log) throws IOException {
        Translator.IMetaECTreeGenerator metaECTreeGenerator;
        String targetUsed = target != null ? target : "host";
        String dwarfToolUsed = dwarfTool != null ? dwarfTool : "pahole";
        String searchDir = emiModel + "/" + "build/" + targetUsed + "/";
        switch (dwarfToolUsed) {
            case "pahole": {
                metaECTreeGenerator = new MetaECTreeGeneratorPahole(searchDir);
                break;
            }
            case "objdump": {
                metaECTreeGenerator = new MetaECTreeGeneratorObjdump(searchDir);
                break;
            }
            case "dwarfdump": {
                metaECTreeGenerator = new MetaECTreeGeneratorDwarfdump(searchDir);
                break;
            }
            default: {
                throw new IOException("The dwarf tool \"" + dwarfTool + "\" is not supported");
            }
        }
        TranslationBuilderJson translationBuilder = new TranslationBuilderJson();
        Translator translator = new Translator(searchDir, emiModel, metaECTreeGenerator, translationBuilder, log);
        if (log) {
            translator.displayMetaECTree();
        }
        return translator;
    }
}

