/*
 * Decompiled with CFR 0.152.
 */
package plug.language.buchikripke.sk_tba;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import plug.core.ILanguageLoader;
import plug.core.RuntimeDescription;
import plug.language.buchi.runtime.BuchiRuntime;
import plug.language.buchikripke.runtime.KripkeBuchiDescription;
import plug.language.buchikripke.sk_tba.SK_TBA_ProductSemantics;
import properties.BuchiAutomata.BuchiAutomataModel.BuchiDeclaration;
import properties.LTL.transformations.LTL2Buchi;

public class SK_TBA_Loader
implements ILanguageLoader<SK_TBA_ProductSemantics> {
    public SK_TBA_ProductSemantics getRuntime(URI modelURI, Map<String, Object> options) throws Exception {
        KripkeBuchiDescription description = (KripkeBuchiDescription)new ObjectMapper().readValue(modelURI.toURL(), KripkeBuchiDescription.class);
        Path modelPath = Paths.get(description.getModel(), new String[0]);
        Path resolvedModelPath = modelPath.isAbsolute() ? modelPath : Paths.get(modelURI).getParent().resolve(modelPath);
        RuntimeDescription kripke = new RuntimeDescription(resolvedModelPath);
        StringBuilder ltl = new StringBuilder();
        description.getProperties().forEach((name, expression) -> {
            ltl.append((String)name);
            ltl.append(" = ");
            ltl.append((String)expression);
            ltl.append("\n");
        });
        BuchiDeclaration buchiAutomaton = new LTL2Buchi(new PrintWriter(System.out)).getBuchiDeclaration(ltl.toString());
        BuchiRuntime buchiRuntime = new BuchiRuntime(buchiAutomaton);
        SK_TBA_ProductSemantics kbProductSemantics = new SK_TBA_ProductSemantics(kripke, buchiRuntime);
        return kbProductSemantics;
    }
}

