/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.memoryobjects;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import emi.serializer.memoryobjects.Objects;
import emi.serializer.model.ClassifierInstance;
import emi.serializer.model.PartMultiplicity;
import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlNavigation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class PropertiesRO {
    private final List<ClassifierInstance> objects;
    private final List<ClassifierInstance> objectsMAIN;
    private final List<ClassifierInstance> objectsOBS;
    private final Set<Class> classes;
    private final Set<Class> superclasses;
    private final List<Association> associations;
    private final List<Connector> connectors;
    private final Map<ClassifierInstance, Map<Property, List<ClassifierInstance>>> mapping;

    public PropertiesRO(ResourceManager rm) {
        Set _set;
        List _list;
        List<ClassifierInstance> _collectClassifierInstance = UmlNavigation.collectClassifierInstance(rm);
        this.objects = _list = IterableExtensions.toList(_collectClassifierInstance);
        List<ClassifierInstance> _collectClassifierInstanceWithCompositeClass = UmlNavigation.collectClassifierInstanceWithCompositeClass(rm, "Main");
        this.objectsMAIN = _collectClassifierInstanceWithCompositeClass;
        List<ClassifierInstance> _collectClassifierInstanceWithCompositeClass_1 = UmlNavigation.collectClassifierInstanceWithCompositeClass(rm, "Obs");
        this.objectsOBS = _collectClassifierInstanceWithCompositeClass_1;
        Function<Resource, List> _function = it -> {
            TreeIterator _allContents = it.getAllContents();
            UnmodifiableIterator _filter = Iterators.filter((Iterator)_allContents, Association.class);
            return IteratorExtensions.toList((Iterator)_filter);
        };
        List _list_1 = rm.getList(_function);
        this.associations = _list_1;
        Function<Resource, List> _function_1 = it -> {
            TreeIterator _allContents = it.getAllContents();
            UnmodifiableIterator _filter = Iterators.filter((Iterator)_allContents, Connector.class);
            return IteratorExtensions.toList((Iterator)_filter);
        };
        List _list_2 = rm.getList(_function_1);
        this.connectors = _list_2;
        List<Class> _classes = UmlNavigation.getClasses(rm);
        Functions.Function1 _function_2 = it -> it.allParents();
        List _map = ListExtensions.map(_classes, (Functions.Function1)_function_2);
        Iterable _flatten = Iterables.concat((Iterable)_map);
        Iterable _filter = Iterables.filter((Iterable)_flatten, Class.class);
        this.superclasses = _set = IterableExtensions.toSet((Iterable)_filter);
        HashSet<Class> _hashSet = new HashSet<Class>();
        this.classes = _hashSet;
        this.classes.addAll(this.superclasses);
        List<Class> _classes_1 = UmlNavigation.getClasses(rm);
        this.classes.addAll(_classes_1);
        IterableExtensions.toSet(this.classes);
        HashMap<ClassifierInstance, Map<Property, List<ClassifierInstance>>> _hashMap = new HashMap<ClassifierInstance, Map<Property, List<ClassifierInstance>>>();
        this.mapping = _hashMap;
        for (ClassifierInstance o : this.objects) {
            HashMap _hashMap_1 = new HashMap();
            this.mapping.put(o, _hashMap_1);
        }
        Class mainClass = UmlNavigation.getCompositeClass(rm, "Main");
        Class obsClass = UmlNavigation.getCompositeClass(rm, "Obs");
        InstanceSpecification _compositeInstance = UmlNavigation.getCompositeInstance(rm, (Classifier)mainClass);
        this.collectPropertiesOfCompositeClass(this.mapping, mainClass, _compositeInstance);
        InstanceSpecification _compositeInstance_1 = UmlNavigation.getCompositeInstance(rm, (Classifier)obsClass);
        this.collectPropertiesOfCompositeClass(this.mapping, obsClass, _compositeInstance_1);
        InputOutput.println((Object)"PropertiesRO mapping:");
        Set<Map.Entry<ClassifierInstance, Map<Property, List<ClassifierInstance>>>> _entrySet = this.mapping.entrySet();
        Consumer<Map.Entry> _function_3 = it -> {
            ClassifierInstance _key = (ClassifierInstance)it.getKey();
            String _instQualifiedName = _key.getInstQualifiedName();
            InputOutput.println((Object)_instQualifiedName);
            Map _value = (Map)it.getValue();
            Set _entrySet_1 = _value.entrySet();
            Consumer<Map.Entry> _function_4 = it_1 -> {
                Property _key_1 = (Property)it_1.getKey();
                String _name = _key_1.getName();
                String _plus = "\t" + _name;
                String _plus_1 = _plus + "= ";
                List _value_1 = (List)it_1.getValue();
                Functions.Function1 _function_5 = it_2 -> it_2.getInstQualifiedName();
                List _map_1 = ListExtensions.map((List)_value_1, (Functions.Function1)_function_5);
                String _join = IterableExtensions.join((Iterable)_map_1, (CharSequence)", ");
                String _plus_2 = _plus_1 + _join;
                InputOutput.println((Object)_plus_2);
            };
            _entrySet_1.forEach(_function_4);
        };
        _entrySet.forEach(_function_3);
        InputOutput.println((Object)"");
    }

    public void collectPropertiesOfCompositeClass(Map<ClassifierInstance, Map<Property, List<ClassifierInstance>>> mapping, Class composite, InstanceSpecification is) {
        ArrayList compositeContainers = new ArrayList();
        if (composite != null) {
            EList _ownedConnectors = composite.getOwnedConnectors();
            Consumer<Connector> _function = it -> this.processConnector(mapping, (Connector)it, compositeContainers);
            _ownedConnectors.forEach(_function);
            Functions.Function1 _function_1 = it -> it.getContainers().size() == 0 && is.getName().equals(it.getName());
            Iterable _filter = IterableExtensions.filter(this.objects, (Functions.Function1)_function_1);
            List _list = IterableExtensions.toList((Iterable)_filter);
            ClassifierInstance compositeObject = (ClassifierInstance)IterableExtensions.head((Iterable)_list);
            EList _parts = composite.getParts();
            Consumer<Property> _function_2 = it -> this.processCompositePart(mapping, compositeObject, (Property)it, compositeContainers);
            _parts.forEach(_function_2);
            EList _parts_1 = composite.getParts();
            Consumer<Property> _function_3 = it -> this.collectAllProperties(mapping, (Property)it, compositeContainers);
            _parts_1.forEach(_function_3);
        }
    }

    private void collectAllProperties(Map<ClassifierInstance, Map<Property, List<ClassifierInstance>>> mapping, Property p, List<PartMultiplicity> containers) {
        int _lower = p.getLower();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _lower, true);
        Consumer<Integer> _function = it -> {
            ArrayList<PartMultiplicity> pContainers = new ArrayList<PartMultiplicity>();
            pContainers.addAll(containers);
            PartMultiplicity _partMultiplicity = new PartMultiplicity(p, (int)it);
            pContainers.add(_partMultiplicity);
            Type _type = p.getType();
            EList _ownedConnectors = ((Class)_type).getOwnedConnectors();
            Consumer<Connector> _function_1 = it_1 -> this.processConnector(mapping, (Connector)it_1, (List<PartMultiplicity>)pContainers);
            _ownedConnectors.forEach(_function_1);
            Functions.Function1 _function_2 = it_1 -> this.compareToContainers((ClassifierInstance)it_1, (List<PartMultiplicity>)pContainers);
            Iterable _filter = IterableExtensions.filter(this.objects, (Functions.Function1)_function_2);
            List _list = IterableExtensions.toList((Iterable)_filter);
            ClassifierInstance pObject = (ClassifierInstance)IterableExtensions.head((Iterable)_list);
            Type _type_1 = p.getType();
            EList _parts = ((Class)_type_1).getParts();
            Consumer<Property> _function_3 = it_1 -> this.processCompositePart(mapping, pObject, (Property)it_1, (List<PartMultiplicity>)pContainers);
            _parts.forEach(_function_3);
            Type _type_2 = p.getType();
            EList _parts_1 = ((Class)_type_2).getParts();
            Consumer<Property> _function_4 = it_1 -> this.collectAllProperties(mapping, (Property)it_1, (List<PartMultiplicity>)pContainers);
            _parts_1.forEach(_function_4);
        };
        _doubleDotLessThan.forEach(_function);
    }

    private void processConnector(Map<ClassifierInstance, Map<Property, List<ClassifierInstance>>> mapping, Connector c, List<PartMultiplicity> containers) {
        Association association = c.getType();
        EList memberEnds = association.getMemberEnds();
        EList _ends = c.getEnds();
        Consumer<ConnectorEnd> _function = it -> {
            ConnectableElement role = it.getRole();
            Functions.Function1 _function_1 = it_1 -> com.google.common.base.Objects.equal((Object)it_1.getType(), (Object)role.getType()) || ((Class)role.getType()).allParents().contains((Object)it_1.getType());
            Iterable _filter = IterableExtensions.filter((Iterable)memberEnds, (Functions.Function1)_function_1);
            List _list = IterableExtensions.toList((Iterable)_filter);
            Property property = (Property)IterableExtensions.head((Iterable)_list);
            Functions.Function1 _function_2 = it_1 -> !com.google.common.base.Objects.equal((Object)it_1.getType(), (Object)role.getType()) && !((Class)role.getType()).allParents().contains((Object)it_1.getType());
            Iterable _filter_1 = IterableExtensions.filter((Iterable)memberEnds, (Functions.Function1)_function_2);
            List _list_1 = IterableExtensions.toList((Iterable)_filter_1);
            Property oppositeProperty = (Property)IterableExtensions.head((Iterable)_list_1);
            EList _ends_1 = c.getEnds();
            Functions.Function1 _function_3 = it_1 -> com.google.common.base.Objects.equal((Object)oppositeProperty.getType(), (Object)it_1.getRole().getType()) || ((Classifier)it_1.getRole().getType()).allParents().contains((Object)oppositeProperty.getType());
            Iterable _filter_2 = IterableExtensions.filter((Iterable)_ends_1, (Functions.Function1)_function_3);
            List _list_2 = IterableExtensions.toList((Iterable)_filter_2);
            ConnectorEnd oppositeEnd = (ConnectorEnd)IterableExtensions.head((Iterable)_list_2);
            List<ClassifierInstance> endObjects = this.getClassifierInstancesOfConnectorEnd((ConnectorEnd)it, containers);
            List<ClassifierInstance> oppositeEndObjects = this.getClassifierInstancesOfConnectorEnd(oppositeEnd, containers);
            AtomicInteger index = new AtomicInteger(0);
            AtomicInteger oppositeIndex = new AtomicInteger(0);
            AtomicInteger counter = new AtomicInteger(0);
            Consumer<ClassifierInstance> _function_4 = it_1 -> {
                ClassifierInstance endObject = it_1;
                Map mapEndObject = (Map)mapping.get(endObject);
                ArrayList propertyList = new ArrayList();
                int _lower = oppositeProperty.getLower();
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _lower, true);
                Consumer<Integer> _function_5 = it_2 -> {
                    boolean _greaterEqualsThan;
                    int _get = oppositeIndex.get();
                    ClassifierInstance _get_1 = (ClassifierInstance)oppositeEndObjects.get(_get);
                    propertyList.add(_get_1);
                    counter.incrementAndGet();
                    int _get_2 = counter.get();
                    int _lower_1 = property.getLower();
                    boolean bl = _greaterEqualsThan = _get_2 >= _lower_1;
                    if (_greaterEqualsThan) {
                        counter.set(0);
                        oppositeIndex.incrementAndGet();
                    }
                };
                _doubleDotLessThan.forEach(_function_5);
                mapEndObject.put(oppositeProperty, propertyList);
                index.incrementAndGet();
            };
            endObjects.forEach(_function_4);
        };
        _ends.forEach(_function);
    }

    private void processCompositePart(Map<ClassifierInstance, Map<Property, List<ClassifierInstance>>> mapping, ClassifierInstance ownerObject, Property part, List<PartMultiplicity> ownerContainers) {
        ArrayList propertyOwner = new ArrayList();
        int _lower = part.getLower();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _lower, true);
        Consumer<Integer> _function = it -> {
            ArrayList<PartMultiplicity> partContainers = new ArrayList<PartMultiplicity>();
            partContainers.addAll(ownerContainers);
            PartMultiplicity _partMultiplicity = new PartMultiplicity(part, (int)it);
            partContainers.add(_partMultiplicity);
            Functions.Function1 _function_1 = it_1 -> this.compareToContainers((ClassifierInstance)it_1, (List<PartMultiplicity>)partContainers);
            Iterable _filter = IterableExtensions.filter(this.objects, (Functions.Function1)_function_1);
            List _list = IterableExtensions.toList((Iterable)_filter);
            ClassifierInstance partObject = (ClassifierInstance)IterableExtensions.head((Iterable)_list);
            propertyOwner.add(partObject);
        };
        _doubleDotLessThan.forEach(_function);
        Map<Property, List<ClassifierInstance>> mapOwnerObject = mapping.get(ownerObject);
        mapOwnerObject.put(part, propertyOwner);
    }

    private List<ClassifierInstance> getClassifierInstancesOfConnectorEnd(ConnectorEnd ce, List<PartMultiplicity> containers) {
        boolean _tripleNotEquals;
        ArrayList<ClassifierInstance> _xblockexpression = null;
        ArrayList<ClassifierInstance> list = new ArrayList<ClassifierInstance>();
        ArrayList<List<PartMultiplicity>> partWithPortContainers = new ArrayList<List<PartMultiplicity>>();
        ArrayList endContainers = new ArrayList();
        Property _partWithPort = ce.getPartWithPort();
        boolean bl = _tripleNotEquals = _partWithPort != null;
        if (_tripleNotEquals) {
            Property _partWithPort_1 = ce.getPartWithPort();
            int _lower = _partWithPort_1.getLower();
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _lower, true);
            Consumer<Integer> _function = it -> {
                ArrayList<PartMultiplicity> thisContainers = new ArrayList<PartMultiplicity>();
                thisContainers.addAll(containers);
                Property _partWithPort_2 = ce.getPartWithPort();
                PartMultiplicity _partMultiplicity = new PartMultiplicity(_partWithPort_2, (int)it);
                thisContainers.add(_partMultiplicity);
                partWithPortContainers.add(thisContainers);
            };
            _doubleDotLessThan.forEach(_function);
        } else {
            partWithPortContainers.add(containers);
        }
        Consumer<List> _function_1 = it -> {
            List pContainers = it;
            ConnectableElement _role = ce.getRole();
            Property role = (Property)_role;
            int _lower_1 = role.getLower();
            ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _lower_1, true);
            Consumer<Integer> _function_2 = it_1 -> {
                ArrayList<PartMultiplicity> thisContainers = new ArrayList<PartMultiplicity>();
                thisContainers.addAll(pContainers);
                PartMultiplicity _partMultiplicity = new PartMultiplicity(role, (int)it_1);
                thisContainers.add(_partMultiplicity);
                endContainers.add(thisContainers);
            };
            _doubleDotLessThan_1.forEach(_function_2);
        };
        partWithPortContainers.forEach(_function_1);
        Consumer<List> _function_2 = it -> {
            List thisContainers = it;
            Functions.Function1 _function_3 = it_1 -> this.compareToContainers((ClassifierInstance)it_1, thisContainers);
            Iterable _filter = IterableExtensions.filter(this.objects, (Functions.Function1)_function_3);
            List _list = IterableExtensions.toList((Iterable)_filter);
            list.addAll(_list);
        };
        endContainers.forEach(_function_2);
        _xblockexpression = list;
        return _xblockexpression;
    }

    private boolean compareToContainers(ClassifierInstance e, List<PartMultiplicity> containers) {
        boolean _xblockexpression = false;
        if (e == null || containers == null || e.getContainers() == null || e.getContainers().size() != containers.size()) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < containers.size(); ++i) {
            boolean _not;
            PartMultiplicity _get_1;
            List<PartMultiplicity> _containers = e.getContainers();
            PartMultiplicity _get = _containers.get(i);
            boolean _fieldsEqual = PartMultiplicity.fieldsEqual(_get, _get_1 = containers.get(i));
            boolean bl = _not = !_fieldsEqual;
            if (!_not) continue;
            result = false;
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static String getPeersTypeName(Class e) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_peers");
        return _builder.toString();
    }

    private Set<Property> getPeers(Class e) {
        HashSet<Property> _xblockexpression = null;
        HashSet<Property> peers = new HashSet<Property>();
        Functions.Function1 _function = it -> {
            EList _memberEnds = it.getMemberEnds();
            Functions.Function1 _function_1 = it_1 -> {
                Type _type = it_1.getType();
                return (Class)_type;
            };
            List _map = ListExtensions.map((List)_memberEnds, (Functions.Function1)_function_1);
            List _list = IterableExtensions.toList((Iterable)_map);
            return _list.contains(e);
        };
        Iterable _filter = IterableExtensions.filter(this.associations, (Functions.Function1)_function);
        List associations = IterableExtensions.toList((Iterable)_filter);
        Functions.Function1 _function_1 = it -> it.getMemberEnds();
        List _map = ListExtensions.map((List)associations, (Functions.Function1)_function_1);
        List allMemberEnd = IterableExtensions.toList((Iterable)_map);
        Iterable _flatten = Iterables.concat((Iterable)allMemberEnd);
        Functions.Function1 _function_2 = it -> {
            Type _type = it.getType();
            boolean _equals = ((Class)_type).equals(e);
            return !_equals;
        };
        Iterable endPeers = IterableExtensions.filter((Iterable)_flatten, (Functions.Function1)_function_2);
        EList _ownedPorts = e.getOwnedPorts();
        Functions.Function1 _function_3 = it -> it.isBehavior();
        Iterable behavioralPorts = IterableExtensions.filter((Iterable)_ownedPorts, (Functions.Function1)_function_3);
        Iterables.addAll(peers, (Iterable)endPeers);
        Iterables.addAll(peers, (Iterable)behavioralPorts);
        _xblockexpression = peers;
        return _xblockexpression;
    }

    public Set<Property> getAllPeers(Class e) {
        HashSet<Property> _xblockexpression = null;
        HashSet<Property> peers = new HashSet<Property>();
        Set<Property> _peers = this.getPeers(e);
        peers.addAll(_peers);
        EList _allParents = e.allParents();
        Consumer<Classifier> _function = it -> {
            Set<Property> _peers_1 = this.getPeers((Class)it);
            peers.addAll(_peers_1);
        };
        _allParents.forEach(_function);
        _xblockexpression = peers;
        return _xblockexpression;
    }

    private Set<Property> getCompositeParts(Class e) {
        EList _ownedAttributes = e.getOwnedAttributes();
        Functions.Function1 _function = it -> it.isComposite();
        Iterable _filter = IterableExtensions.filter((Iterable)_ownedAttributes, (Functions.Function1)_function);
        return IterableExtensions.toSet((Iterable)_filter);
    }

    private Set<Property> getAllCompositeParts(Class e) {
        HashSet<Property> _xblockexpression = null;
        HashSet<Property> compositeParts = new HashSet<Property>();
        Set<Property> _compositeParts = this.getCompositeParts(e);
        compositeParts.addAll(_compositeParts);
        EList _allParents = e.allParents();
        Consumer<Classifier> _function = it -> {
            Set<Property> _compositeParts_1 = this.getCompositeParts((Class)it);
            compositeParts.addAll(_compositeParts_1);
        };
        _allParents.forEach(_function);
        _xblockexpression = compositeParts;
        return _xblockexpression;
    }

    public HashSet<Property> getReadOnlyAttributes(Class e) {
        HashSet<Property> _xblockexpression = null;
        HashSet<Property> attributes = new HashSet<Property>();
        Set<Property> _peers = this.getPeers(e);
        attributes.addAll(_peers);
        Set<Property> _compositeParts = this.getCompositeParts(e);
        attributes.addAll(_compositeParts);
        _xblockexpression = attributes;
        return _xblockexpression;
    }

    public HashSet<Property> getAllReadOnlyAttributes(Class e) {
        HashSet<Property> _xblockexpression = null;
        HashSet<Property> attributes = new HashSet<Property>();
        Set<Property> _allPeers = this.getAllPeers(e);
        attributes.addAll(_allPeers);
        Set<Property> _allCompositeParts = this.getAllCompositeParts(e);
        attributes.addAll(_allCompositeParts);
        _xblockexpression = attributes;
        return _xblockexpression;
    }

    public int getNbReadOnlyAttributes(Class e) {
        boolean _notEquals;
        Integer _xblockexpression = null;
        HashSet<Property> attributes = this.getAllReadOnlyAttributes(e);
        Integer _xifexpression = null;
        int _length = ((Object[])Conversions.unwrapArray(attributes, Object.class)).length;
        boolean bl = _notEquals = _length != 0;
        if (_notEquals) {
            Functions.Function1 _function = it -> it.getLower();
            Iterable _map = IterableExtensions.map(attributes, (Functions.Function1)_function);
            Functions.Function2 _function_1 = (p1, p2) -> p1 + p2;
            _xifexpression = (Integer)IterableExtensions.reduce((Iterable)_map, (Functions.Function2)_function_1);
        } else {
            _xifexpression = 0;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private String typedefToC(Class e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"typedef struct ");
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_properties_ro ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"_properties_ro;");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String getAbstractTypeName(Class e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"ABSTRACT_");
        String _name = e.getName();
        String _upperCase = _name.toUpperCase();
        _builder.append((Object)_upperCase, "");
        _builder.append((Object)"_PROPERTIES_RO");
        return _builder.toString();
    }

    private String typeToC(Class e) {
        String _xblockexpression = null;
        HashSet<Property> attributes = this.getReadOnlyAttributes(e);
        EList superClasses = e.getSuperClasses();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* The ");
        String _name = e.getName();
        _builder.append((Object)_name, " ");
        _builder.append((Object)"_properties_ro type used to link instances of the ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, " ");
        _builder.append((Object)" class with their properties.");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"struct ");
        String _name_2 = e.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)"_properties_ro {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        Functions.Function1 _function = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _abstractTypeName = this.getAbstractTypeName((Class)it);
            _builder_1.append((Object)_abstractTypeName, "");
            return _builder_1.toString();
        };
        List _map = ListExtensions.map((List)superClasses, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"\n");
        _builder.append((Object)_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        Functions.Function1 _function_1 = it -> this.subfieldTypeToC((Property)it);
        Iterable _map_1 = IterableExtensions.map(attributes, (Functions.Function1)_function_1);
        String _join_1 = IterableExtensions.join((Iterable)_map_1, (CharSequence)"\n");
        _builder.append((Object)_join_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"};");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String abstractPeersToC(Class e) {
        boolean _notEquals;
        String _xblockexpression = null;
        HashSet<Property> attributes = this.getReadOnlyAttributes(e);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"#define ");
        String _abstractTypeName = this.getAbstractTypeName(e);
        _builder.append((Object)_abstractTypeName, "");
        _builder.append((Object)" ");
        StringConcatenation _xifexpression = null;
        int _length = ((Object[])Conversions.unwrapArray(attributes, Object.class)).length;
        boolean bl = _notEquals = _length != 0;
        if (_notEquals) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"\\");
            _xifexpression = _builder_1;
        }
        _builder.append(_xifexpression, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        Functions.Function1 _function = it -> this.subfieldTypeToC((Property)it);
        Iterable _map = IterableExtensions.map(attributes, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)" \\\n");
        _builder.append((Object)_join, "\t");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String subfieldTypeToC(Property e) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        StringConcatenation _xifexpression = null;
        int _lower = e.getLower();
        boolean bl = _equals = _lower == 1;
        if (_equals) {
            StringConcatenation _builder_1 = new StringConcatenation();
            Type _type = e.getType();
            String _name = _type.getName();
            _builder_1.append((Object)_name, "");
            _builder_1.append((Object)"_Object * ");
            String _name_1 = e.getName();
            _builder_1.append((Object)_name_1, "");
            _builder_1.append((Object)";");
            _xifexpression = _builder_1;
        } else {
            StringConcatenation _builder_2 = new StringConcatenation();
            Type _type_1 = e.getType();
            String _name_2 = _type_1.getName();
            _builder_2.append((Object)_name_2, "");
            _builder_2.append((Object)"_Object * ");
            String _name_3 = e.getName();
            _builder_2.append((Object)_name_3, "");
            _builder_2.append((Object)"[");
            int _lower_1 = e.getLower();
            _builder_2.append((Object)_lower_1, "");
            _builder_2.append((Object)"];");
            _xifexpression = _builder_2;
        }
        _builder.append((Object)_xifexpression, "");
        return _builder.toString();
    }

    private String fieldTypeToC(ClassifierInstance e) {
        StringConcatenation _builder = new StringConcatenation();
        Classifier _classifier = e.getClassifier();
        String _name = _classifier.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_properties_ro ");
        String _instQualifiedName = e.getInstQualifiedName();
        _builder.append((Object)_instQualifiedName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String fieldToC(ClassifierInstance e) {
        String _xblockexpression = null;
        Classifier _classifier = e.getClassifier();
        Class type = (Class)_classifier;
        HashSet<Property> attributes = this.getAllReadOnlyAttributes(type);
        Map<Property, List<ClassifierInstance>> mapCurrentObject = this.mapping.get(e);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)".");
        String _instQualifiedName = e.getInstQualifiedName();
        _builder.append((Object)_instQualifiedName, "");
        _builder.append((Object)" = {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        Functions.Function1 _function = it -> {
            List _get = (List)mapCurrentObject.get(it);
            return this.subfieldToC((Property)it, _get);
        };
        Iterable _map = IterableExtensions.map(attributes, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)",\n");
        _builder.append((Object)_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String subfieldToC(Property p, List<ClassifierInstance> objects) {
        String _xblockexpression = null;
        if (objects != null && p.getLower() != objects.size()) {
            System.err.println("Error: number of properties RO is not equal to lower bound of property\n");
        }
        StringConcatenation _builder = new StringConcatenation();
        StringConcatenation _xifexpression = null;
        if (objects == null || objects.isEmpty()) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)".");
            String _name = p.getName();
            _builder_1.append((Object)_name, "");
            _builder_1.append((Object)" = NULL");
            _xifexpression = _builder_1;
        } else {
            boolean _equals;
            StringConcatenation _xifexpression_1 = null;
            int _lower = p.getLower();
            boolean bl = _equals = _lower == 1;
            if (_equals) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append((Object)".");
                String _name_1 = p.getName();
                _builder_2.append((Object)_name_1, "");
                _builder_2.append((Object)" = (");
                Type _type = p.getType();
                String _name_2 = _type.getName();
                _builder_2.append((Object)_name_2, "");
                _builder_2.append((Object)"_Object *) &");
                ClassifierInstance _head = (ClassifierInstance)IterableExtensions.head(objects);
                String _objectName = Objects.getObjectName(_head);
                _builder_2.append((Object)_objectName, "");
                _xifexpression_1 = _builder_2;
            } else {
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append((Object)".");
                String _name_3 = p.getName();
                _builder_3.append((Object)_name_3, "");
                _builder_3.append((Object)" = {");
                _builder_3.newLineIfNotEmpty();
                _builder_3.append((Object)"\t");
                Functions.Function1 _function = it -> {
                    StringConcatenation _builder_4 = new StringConcatenation();
                    _builder_4.append((Object)"(");
                    Type _type_1 = p.getType();
                    String _name_4 = _type_1.getName();
                    _builder_4.append((Object)_name_4, "");
                    _builder_4.append((Object)"_Object *) &");
                    String _objectName_1 = Objects.getObjectName(it);
                    _builder_4.append((Object)_objectName_1, "");
                    return _builder_4.toString();
                };
                List _map = ListExtensions.map(objects, (Functions.Function1)_function);
                String _join = IterableExtensions.join((Iterable)_map, (CharSequence)",\n");
                _builder_3.append((Object)_join, "\t");
                _builder_3.newLineIfNotEmpty();
                _builder_3.append((Object)"}");
                _xifexpression_1 = _builder_3;
            }
            _xifexpression = _xifexpression_1;
        }
        _builder.append((Object)_xifexpression, "");
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String serializeHeadersTypedef() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Typedef of read-only properties types for classes.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.typedefToC((Class)it);
        Iterable _map = IterableExtensions.map(this.classes, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map);
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef struct PropertiesRO PropertiesRO;");
        _builder.newLine();
        return _builder.toString();
    }

    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Declaration of read-only properties types for superclasses.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.abstractPeersToC((Class)it);
        Iterable _map = IterableExtensions.map(this.superclasses, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map);
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Declaration of read-only properties types for classes.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> this.typeToC((Class)it);
        Iterable _map_1 = IterableExtensions.map(this.classes, (Functions.Function1)_function_1);
        String _join_1 = IterableExtensions.join((Iterable)_map_1);
        _builder.append((Object)_join_1, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* The global read-only properties type used to make links between objects.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"struct PropertiesRO {");
        _builder.newLine();
        _builder.append((Object)"\t");
        Functions.Function1 _function_2 = it -> this.fieldTypeToC((ClassifierInstance)it);
        List _map_2 = ListExtensions.map(this.objectsMAIN, (Functions.Function1)_function_2);
        String _join_2 = IterableExtensions.join((Iterable)_map_2);
        _builder.append((Object)_join_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"#ifdef WITH_OBSERVERS");
        _builder.newLine();
        _builder.append((Object)"\t");
        Functions.Function1 _function_3 = it -> this.fieldTypeToC((ClassifierInstance)it);
        List _map_3 = ListExtensions.map(this.objectsOBS, (Functions.Function1)_function_3);
        String _join_3 = IterableExtensions.join((Iterable)_map_3);
        _builder.append((Object)_join_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.append((Object)"extern PropertiesRO properties_ro;");
        _builder.newLine();
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Struct initializer for read-only properties.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"PropertiesRO properties_ro = {");
        _builder.newLine();
        _builder.append((Object)"\t");
        Functions.Function1 _function = it -> this.fieldToC((ClassifierInstance)it);
        List _map = ListExtensions.map(this.objectsMAIN, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)",\n");
        _builder.append((Object)_join, "\t");
        _builder.append((Object)",");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"#ifdef WITH_OBSERVERS");
        _builder.newLine();
        _builder.append((Object)"\t");
        Functions.Function1 _function_1 = it -> this.fieldToC((ClassifierInstance)it);
        List _map_1 = ListExtensions.map(this.objectsOBS, (Functions.Function1)_function_1);
        String _join_1 = IterableExtensions.join((Iterable)_map_1, (CharSequence)",\n");
        _builder.append((Object)_join_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        return _builder.toString();
    }
}

