/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.actionlanguage;

import emi.serializer.actionlanguage.C.AtomC;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class AtomSerializer {
    public static final String ATOMS_DIR = "atoms/";
    public static final String ATOMS_GEN = "gen/";
    public static final String ATOM_PREFIX = "atom_";
    private String outPath;
    private String target;

    public void init(String emiModel, String modelName, String target) throws IOException {
        this.target = target;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)emiModel, "");
        _builder.append((Object)"/");
        _builder.append((Object)ATOMS_DIR, "");
        _builder.append((Object)ATOMS_GEN, "");
        _builder.append((Object)target, "");
        this.outPath = _builder.toString();
        File outFile = new File(this.outPath);
        if (!(outFile.exists() && outFile.isDirectory() || new File(this.outPath).mkdir())) {
            throw new IOException(emiModel + " is not a valid EMI model (" + this.outPath + " cannot be created)");
        }
    }

    public void serialize(String stringCode, String id) {
        try {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)this.outPath, "");
            _builder.append((Object)"/");
            _builder.append((Object)ATOM_PREFIX, "");
            _builder.append((Object)id, "");
            _builder.append((Object)".c");
            String outFileC = _builder.toString();
            AtomC _atomC = new AtomC();
            String sOutput = _atomC.serialize(stringCode, id, this.target);
            FileOutputStream _fileOutputStream = new FileOutputStream(outFileC);
            PrintStream outC = new PrintStream(_fileOutputStream);
            outC.print(sOutput);
            outC.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

