/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.scheduling;

import emi.serializer.model.ClassifierInstance;
import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlNavigation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class SchedulingPolicyFP {
    private static final int DEFAUT_FP_PRIORITY = 1;
    private final List<ClassifierInstance> activeObjects;
    private final File configFile;
    private final Properties props;

    public SchedulingPolicyFP(ResourceManager rm, String file) {
        try {
            Properties _properties;
            File _file;
            this.activeObjects = UmlNavigation.getActiveObjectsList(rm);
            this.configFile = _file = new File(file);
            this.configFile.createNewFile();
            this.props = _properties = new Properties();
            FileInputStream _fileInputStream = new FileInputStream(this.configFile);
            this.props.load(_fileInputStream);
            this.updateConfigurationFile();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private String getKeyName(ClassifierInstance activeObject) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Priority_");
        String _instQualifiedName = activeObject.getInstQualifiedName();
        _builder.append(_instQualifiedName);
        return _builder.toString();
    }

    public void updateConfigurationFile() {
        try {
            Functions.Function1 _function = it -> {
                boolean _containsKey = this.props.containsKey(this.getKeyName((ClassifierInstance)it));
                return !_containsKey;
            };
            Consumer<ClassifierInstance> _function_1 = it -> this.props.setProperty(this.getKeyName((ClassifierInstance)it), Integer.valueOf(1).toString());
            IterableExtensions.filter(this.activeObjects, (Functions.Function1)_function).forEach(_function_1);
            Functions.Function1 _function_2 = it -> this.getKeyName((ClassifierInstance)it);
            List keysName = IterableExtensions.toList((Iterable)ListExtensions.map(this.activeObjects, (Functions.Function1)_function_2));
            Functions.Function1 _function_3 = it -> {
                boolean _contains = keysName.contains(it);
                return !_contains;
            };
            List oldKeys = IterableExtensions.toList((Iterable)IterableExtensions.filter(this.props.keySet(), (Functions.Function1)_function_3));
            Consumer<Object> _function_4 = it -> this.props.remove(it);
            oldKeys.forEach(_function_4);
            FileOutputStream os = new FileOutputStream(this.configFile);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("@file ");
            String _name = this.configFile.getName();
            _builder.append(_name);
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.newLine();
            _builder.append("This file is used to configure fixed priority of active objects used with fised priority scheduling policy.");
            _builder.newLine();
            _builder.newLine();
            _builder.append("Configure manually fixed priority of each active object.");
            _builder.newLine();
            _builder.append("This file is not overwritten during serialization but updated accoding to active objects creation and deletion.");
            _builder.newLine();
            _builder.newLine();
            _builder.append("@author Valentin Besnard (valentin.besnard@eseo.fr)");
            _builder.newLine();
            String comments = _builder.toString();
            this.props.store(os, comments);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String getFPMacroName(ClassifierInstance activeObject) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("FP_PRIORITY_");
        String _instQualifiedName = activeObject.getInstQualifiedName();
        _builder.append(_instQualifiedName);
        return _builder.toString();
    }

    public int getFPValue(ClassifierInstance activeObject) {
        int _xblockexpression = 0;
        String value = this.props.getProperty(this.getKeyName(activeObject));
        int priority = 1;
        if (value != null && !"".contentEquals(value)) {
            try {
                priority = Integer.parseInt(value);
            }
            catch (Throwable _t) {
                if (_t instanceof NumberFormatException) {
                    NumberFormatException e = (NumberFormatException)_t;
                    e.printStackTrace();
                    priority = 1;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        } else {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("ERROR: No fixed priority given for the ");
            String _instQualifiedName = activeObject.getInstQualifiedName();
            _builder.append(_instQualifiedName);
            _builder.append(" active object.");
            System.err.println(_builder);
        }
        _xblockexpression = priority;
        return _xblockexpression;
    }

    public String serializeHeaderTypdef() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#ifdef SCHEDULING_POLICY_FP");
        _builder.newLine();
        Functions.Function1 _function = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("#define ");
            String _fPMacroName = SchedulingPolicyFP.getFPMacroName(it);
            _builder_1.append(_fPMacroName);
            _builder_1.append("    ");
            int _fPValue = this.getFPValue((ClassifierInstance)it);
            _builder_1.append((Object)_fPValue);
            return _builder_1.toString();
        };
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.activeObjects, (Functions.Function1)_function), (CharSequence)"\n");
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _builder.append("#endif /* SCHEDULING_POLICY_FP */");
        _builder.newLine();
        return _builder.toString();
    }
}

