/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.memoryobjects;

import com.google.common.base.Objects;
import emi.serializer.model.ClassifierInstance;
import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlNavigation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class Transitions {
    private final List<ClassifierInstance> activeObjectsOBS;
    private final List<ClassifierInstance> activeObjectsMAIN;

    public Transitions(ResourceManager rm) {
        this.activeObjectsOBS = UmlNavigation.getActiveObjectsListOfComposite(rm, "Obs");
        this.activeObjectsMAIN = UmlNavigation.getActiveObjectsListOfComposite(rm, "Main");
    }

    public static boolean canPropagateEvaluation(Vertex v) {
        return !(v instanceof State) && (!(v instanceof Pseudostate) || !Objects.equal((Object)((Pseudostate)v).getKind(), (Object)PseudostateKind.CHOICE_LITERAL));
    }

    public static int getMaxTransitionLength(StateMachine sm) {
        Integer _xblockexpression = null;
        ArrayList list = new ArrayList();
        Functions.Function1 _function = it -> {
            boolean _canPropagateEvaluation = Transitions.canPropagateEvaluation(it);
            return !_canPropagateEvaluation;
        };
        Consumer<Vertex> _function_1 = it -> {
            Consumer<Transition> _function_2 = it_1 -> {
                Functions.Function1 _function_3 = it_2 -> ((Object[])Conversions.unwrapArray((Object)it_2, Object.class)).length;
                list.add(IterableExtensions.max((Iterable)ListExtensions.map(Transitions.getTransitions(it_1), (Functions.Function1)_function_3)));
            };
            it.getOutgoings().forEach(_function_2);
        };
        IterableExtensions.filter(UmlNavigation.getAllVertices(sm), (Functions.Function1)_function).forEach(_function_1);
        Integer _xifexpression = null;
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(list);
        _xifexpression = _isNullOrEmpty ? Integer.valueOf(1) : (Integer)IterableExtensions.max(list);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static int getMaxFireablesTransition(StateMachine sm) {
        Integer _xblockexpression = null;
        ArrayList list = new ArrayList();
        Functions.Function1 _function = it -> {
            boolean _canPropagateEvaluation = Transitions.canPropagateEvaluation(it);
            return !_canPropagateEvaluation;
        };
        Consumer<Vertex> _function_1 = it -> {
            ArrayList transitions = new ArrayList();
            Consumer<Transition> _function_2 = it_1 -> transitions.addAll(Transitions.getTransitions(it_1));
            it.getOutgoings().forEach(_function_2);
            list.add(((Object[])Conversions.unwrapArray(transitions, Object.class)).length);
        };
        IterableExtensions.filter(UmlNavigation.getAllVertices(sm), (Functions.Function1)_function).forEach(_function_1);
        Integer _xifexpression = null;
        Integer _max = (Integer)IterableExtensions.max(list);
        boolean _greaterEqualsThan = _max >= 1;
        _xifexpression = _greaterEqualsThan ? (Integer)IterableExtensions.max(list) : Integer.valueOf(1);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static List<List<Transition>> getTransitions(Transition t) {
        boolean _not;
        ArrayList<List<Transition>> _xblockexpression = null;
        ArrayList<List<Transition>> list = new ArrayList<List<Transition>>();
        boolean _canPropagateEvaluation = Transitions.canPropagateEvaluation(t.getTarget());
        boolean bl = _not = !_canPropagateEvaluation;
        if (_not) {
            list.add(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Transition[]{t})));
        } else {
            Consumer<Transition> _function = it -> {
                Consumer<List> _function_1 = it_1 -> {
                    ArrayList<Transition> compoundTransition = new ArrayList<Transition>();
                    compoundTransition.add(t);
                    compoundTransition.addAll((Collection<Transition>)it_1);
                    list.add(compoundTransition);
                };
                Transitions.getTransitions(it).forEach(_function_1);
            };
            t.getTarget().getOutgoings().forEach(_function);
        }
        _xblockexpression = list;
        return _xblockexpression;
    }

    public String serializeFireables(ClassifierInstance object) {
        String _xblockexpression = null;
        Classifier _classifier = object.getClassifier();
        StateMachine sm = UmlNavigation.getStateMachine((Class)_classifier);
        int maxFireables = Transitions.getMaxFireablesTransition(sm);
        int fireableLength = Transitions.getMaxTransitionLength(sm);
        String initializer = "";
        if (maxFireables != 0 && fireableLength != 0) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(" ");
            _builder.append("= {{0}}");
            initializer = _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("static NbOutgoings_t fireables_");
        String _instQualifiedName = object.getInstQualifiedName();
        _builder_1.append(_instQualifiedName);
        _builder_1.append("[");
        _builder_1.append((Object)maxFireables);
        _builder_1.append("][");
        _builder_1.append((Object)fireableLength);
        _builder_1.append("]");
        _builder_1.append(initializer);
        _builder_1.append(";");
        _xblockexpression = _builder_1.toString();
        return _xblockexpression;
    }

    public String serializeHeadersTypedef() {
        String _xblockexpression = null;
        Functions.Function1 _function = it -> {
            Classifier _classifier = it.getClassifier();
            int _maxFireablesTransition = Transitions.getMaxFireablesTransition(UmlNavigation.getStateMachine((Class)_classifier));
            int _lower = it.getLower();
            return _maxFireablesTransition * _lower;
        };
        Functions.Function2 _function_1 = (p1, p2) -> p1 + p2;
        Integer nbFireableSystem = (Integer)IterableExtensions.reduce((Iterable)ListExtensions.map(this.activeObjectsMAIN, (Functions.Function1)_function), (Functions.Function2)_function_1);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The number of fireable transitions of the system.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("#define MAX_FIREABLE_SYSTEM  (");
        _builder.append((Object)nbFireableSystem);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String serializeHeaders() {
        return "";
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Objects to store fireable transtions.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.serializeFireables((ClassifierInstance)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.activeObjectsMAIN, (Functions.Function1)_function), (CharSequence)"\n");
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifdef WITH_OBSERVERS");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> this.serializeFireables((ClassifierInstance)it);
        String _join_1 = IterableExtensions.join((Iterable)ListExtensions.map(this.activeObjectsOBS, (Functions.Function1)_function_1), (CharSequence)"\n");
        _builder.append(_join_1);
        _builder.newLineIfNotEmpty();
        _builder.append("#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        return _builder.toString();
    }
}

