/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.protocol;

import emi.analysis.model.EMIFireableTransition;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public final class EMIProtocolFireableTransition {
    public static final int SIZEOF_NB_TRANSITIONS = 4;
    public static final int SIZEOF_ACTIVE_OBJECT_ID = 4;
    public static final int SIZEOF_ACTIVE_OBJECT_CS = 4;
    public static final int SIZEOF_TRANSITION_ID = 4;
    public static final int SIZEOF_TRANSITION_LENGTH = 4;
    public static final int SIZEOF_TRANSITION_CONTENT = 4;
    public static final int SIZEOF_FIREABLE_TRANSITION_HEADER = 16;

    private EMIProtocolFireableTransition() {
    }

    public static int deserialize(ArrayList<EMIFireableTransition> fireableTransitions, byte[] data) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        int nb = byteBuffer.getInt();
        for (int i = 0; i < nb; ++i) {
            int activeObjectId = byteBuffer.getInt();
            int activeObjectCS = byteBuffer.getInt();
            int transitionId = byteBuffer.getInt();
            int transitionLength = byteBuffer.getInt();
            int[] transitionContent = new int[transitionLength];
            for (int j = 0; j < transitionLength; ++j) {
                transitionContent[j] = byteBuffer.getInt();
            }
            fireableTransitions.add(new EMIFireableTransition(activeObjectId, activeObjectCS, transitionId, transitionContent));
        }
        return byteBuffer.position();
    }

    public static byte[] serialize(EMIFireableTransition transition) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(EMIProtocolFireableTransition.getSize(transition));
        byteBuffer.putInt(transition.getActiveObjectId());
        byteBuffer.putInt(transition.getActiveObjectCS());
        byteBuffer.putInt(transition.getTransitionId());
        byteBuffer.putInt(transition.getTransitionContent().length);
        for (int oneTransitionId : transition.getTransitionContent()) {
            byteBuffer.putInt(oneTransitionId);
        }
        return byteBuffer.array();
    }

    public static int getSize(EMIFireableTransition fireable) {
        return 16 + fireable.getTransitionContent().length * 4;
    }
}

