/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.protocol;

import emi.analysis.com.IConnection;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class EMIProtocol {
    public static final byte REQ_RESET = 1;
    public static final byte REQ_RESET_DIFF = 2;
    public static final byte REQ_ASK_DIFF_AVAILABLE = 3;
    public static final byte REQ_GET_CONFIGURATION = 4;
    public static final byte REQ_GET_CONFIGURATION_DIFF = 5;
    public static final byte REQ_SET_CONFIGURATION = 6;
    public static final byte REQ_SET_CONFIGURATION_DIFF = 7;
    public static final byte REQ_GET_FIREABLE_TRANSITIONS = 8;
    public static final byte REQ_FIRE_TRANSITION = 9;
    public static final byte REQ_SET_C_GET_FT = 10;
    public static final byte REQ_SET_C_GET_FT_DIFF = 11;
    public static final byte REQ_SET_C_FIRE_T_GET_C = 12;
    public static final byte REQ_SET_C_FIRE_T_GET_C_DIFF = 13;
    public static final byte REQ_LOAD_ATOM = 14;
    public static final byte REQ_EVALUATE_ATOMS = 15;
    public static final byte REQ_TRANSLATE_CONFIGURATION = 101;
    public static final byte REQ_TRANSLATE_FIREABLE_TRANSITION = 102;
    public static final byte RSP_ERROR = 1;
    public static final byte RSP_DIFF_AVAILABLE = 2;
    public static final byte RSP_CONFIGURATION = 3;
    public static final byte RSP_CONFIGURATION_DIFF = 4;
    public static final byte RSP_FIREABLE_TRANSITIONS = 5;
    public static final byte RSP_ATOMS_EVALUATION = 6;
    public static final byte RSP_TRANSLATE_CONFIGURATION = 101;
    public static final byte RSP_TRANSLATE_FIREABLE_TRANSITION = 102;

    private EMIProtocol() {
    }

    private static byte readKind(IConnection connection) throws IOException {
        return connection.read(1)[0];
    }

    private static int readSize(IConnection connection) throws IOException {
        return ByteBuffer.wrap(connection.read(4)).getInt();
    }

    public static Header readHeader(IConnection connection) throws IOException {
        Header header = new Header();
        header.kind = EMIProtocol.readKind(connection);
        header.size = EMIProtocol.readSize(connection);
        return header;
    }

    public static void writeHeader(IConnection connection, Header header) throws IOException {
        connection.write(ByteBuffer.allocate(5).put(header.kind).putInt(header.size).array());
    }

    public static class Header {
        public byte kind;
        public static final int SIZEOF_KIND = 1;
        public int size;
        public static final int SIZEOF_SIZE = 4;
        public static final int SIZEOF_HEADER = 5;

        public Header() {
            this(0, 0);
        }

        public Header(byte kind) {
            this(kind, 0);
        }

        public Header(byte kind, int size) {
            this.kind = kind;
            this.size = size;
        }
    }
}

