/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.json;

import emi.analysis.server.translator.TransitionIdKind;
import java.io.Reader;
import java.io.StringReader;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;

public class DefaultTransitionJson {
    public String deserialize(String transition) {
        JsonReader reader = Json.createReader((Reader)new StringReader(transition));
        JsonArray transitions = reader.readArray();
        reader.close();
        StringBuilder builder = new StringBuilder();
        if (transitions.size() > 0) {
            String transitionSystem = this.deserializeOneTransition(((JsonValue)transitions.get(0)).asJsonObject());
            if (transitionSystem == null) {
                builder.append("Initial transition");
            } else {
                builder.append(transitionSystem);
            }
        }
        for (int i = 1; i < transitions.size(); ++i) {
            builder.append("\n/\\\n");
            String transitionObservers = this.deserializeOneTransition(((JsonValue)transitions.get(i)).asJsonObject());
            if (transitionObservers == null) {
                builder.append("Implicit transition");
                continue;
            }
            builder.append(transitionObservers);
        }
        return builder.toString();
    }

    private String deserializeOneTransition(JsonObject object) {
        String deserializedTransition = "";
        String ao = object.getString("activeObject");
        String transitionIdKind = object.getString("transitionIdKind");
        JsonArray transitionsNames = object.getJsonArray("transitions");
        JsonArray verticesNames = object.getJsonArray("vertices");
        String source = object.getString("source");
        String target = object.getString("target");
        if (transitionIdKind.contentEquals(TransitionIdKind.NO_TRANSITION_ID.getStringValue())) {
            deserializedTransition = "No transition";
        } else if (transitionIdKind.contentEquals(TransitionIdKind.INITIAL_TRANSITION_ID.getStringValue())) {
            deserializedTransition = "Initial transition";
        } else if (transitionIdKind.contentEquals(TransitionIdKind.IMPLICIT_TRANSITION_ID.getStringValue())) {
            deserializedTransition = "|" + ao + "|   " + source + " -> " + target;
        } else if (transitionIdKind.contentEquals(TransitionIdKind.STUTTERING_TRANSITION_ID.getStringValue())) {
            deserializedTransition = "Stuttering transition";
        } else if (transitionIdKind.contentEquals(TransitionIdKind.EXPLICIT_TRANSITION_ID.getStringValue())) {
            StringBuilder builder = new StringBuilder("|" + ao + "|   " + source);
            for (int i = 0; i < transitionsNames.size(); ++i) {
                builder.append(" -");
                String name = transitionsNames.getString(i);
                if (name != null && !"".contentEquals(name)) {
                    builder.append("(" + name + ")");
                }
                builder.append("-> " + verticesNames.getString(i + 1));
            }
            deserializedTransition = builder.toString();
        } else {
            deserializedTransition = "*** Json deserialization error ***";
        }
        return deserializedTransition;
    }
}

