/*
 * Decompiled with CFR 0.152.
 */
package plug.language.emi.analysis;

import emi.analysis.exception.EMIException;
import emi.analysis.model.EMIAtom;

public class EMIIntermediateAtom {
    private static final char SEPARATOR_INTERMEDIATE_ATOM = '@';
    private EMIAtom originalAtom;
    private String[] originalAtomElements;
    private EMIAtom[] iatoms;
    private int[] positions;
    private int[] values;

    public EMIIntermediateAtom(EMIAtom originalAtom) throws EMIException {
        this.originalAtom = originalAtom;
        this.originalAtomElements = null;
        this.iatoms = null;
        this.positions = null;
        this.values = null;
        this.computeIntermediateAtoms();
    }

    public void computeIntermediateAtoms() throws EMIException {
        String originalAtomContent = this.originalAtom.getStringCode();
        long count = originalAtomContent.chars().filter(ch -> ch == 64).count();
        if (count >= 1L) {
            if (count % 2L == 0L) {
                this.originalAtomElements = originalAtomContent.split("@");
                int length = this.originalAtomElements.length;
                int nb = (int)(count / 2L);
                this.iatoms = new EMIAtom[nb];
                this.positions = new int[nb];
                int index = 0;
                for (int j = 1; j < length; j += 2) {
                    this.iatoms[index] = new EMIAtom(this.originalAtomElements[j]);
                    this.positions[index] = j;
                    ++index;
                }
            } else {
                throw new EMIException("Invalid number of @ in atom \"" + originalAtomContent + "\"");
            }
        }
    }

    public String replaceIntermediateAtoms() {
        CharSequence[] elements = (String[])this.originalAtomElements.clone();
        for (int i = 0; i < this.iatoms.length; ++i) {
            elements[this.positions[i]] = "" + this.values[i];
        }
        return String.join((CharSequence)"", elements);
    }

    public void setValues(int[] values) {
        this.values = values;
    }

    public EMIAtom[] getIntermediateAtoms() {
        return this.iatoms;
    }

    public boolean hasIntermediateAtoms() {
        if (this.iatoms != null) {
            return this.iatoms.length != 0;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Atom \"" + this.originalAtom.getStringCode() + " has " + this.iatoms.length + " iatoms:");
        for (int i = 0; i < this.iatoms.length; ++i) {
            sb.append("[" + i + "]: \"" + this.iatoms[i].getStringCode() + "\"");
        }
        return sb.toString();
    }
}

