/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.model;

import emi.serializer.actionlanguage.ActionLanguages;
import emi.serializer.memoryobjects.ActiveObjects;
import emi.serializer.memoryobjects.ClassInfo;
import emi.serializer.memoryobjects.Enumerations;
import emi.serializer.memoryobjects.EventPools;
import emi.serializer.memoryobjects.EventsParameters;
import emi.serializer.memoryobjects.Interpreter;
import emi.serializer.memoryobjects.Observers;
import emi.serializer.memoryobjects.OperationParameters;
import emi.serializer.memoryobjects.Operations;
import emi.serializer.memoryobjects.PassiveObjects;
import emi.serializer.memoryobjects.Ports;
import emi.serializer.memoryobjects.PropertiesRO;
import emi.serializer.memoryobjects.SignalEvents;
import emi.serializer.memoryobjects.Store;
import emi.serializer.memoryobjects.Transitions;
import emi.serializer.metamodel.IStrategy;
import emi.serializer.metamodel.MetamodelTable;
import emi.serializer.model.ResourceManager;
import emi.serializer.scheduling.SchedulingPolicyFP;
import emi.serializer.serialization.uml.AUmlSerializer;
import emi.serializer.serialization.uml.UmlModelSerializer;
import org.eclipse.xtend2.lib.StringConcatenation;

public class ModelSerializer {
    public static final String INTERPRETER_DIR = "emi-uml-c/";
    private final UmlModelSerializer umlModel;
    private final AUmlSerializer umlSerializer;
    private final ActionLanguages actionLanguages;
    private final EventsParameters eventsParameters;
    private final Store store;
    private final PropertiesRO peers;
    private final ClassInfo classInfo;
    private final SignalEvents signalEvents;
    private final ActiveObjects activeObjects;
    private final PassiveObjects passiveObjects;
    private final EventPools eventPools;
    private OperationParameters operationParameters;
    private final Operations operations;
    private final Ports ports;
    private final Transitions transitions;
    private final Interpreter interpreter;
    private final Enumerations enumerations;
    private final SchedulingPolicyFP schedulingPolicyFP;
    private final Observers observers;

    public ModelSerializer(ResourceManager rm, MetamodelTable table, IStrategy strategy, String configSchedulingFP) {
        Observers _observers;
        SchedulingPolicyFP _schedulingPolicyFP;
        Enumerations _enumerations;
        Interpreter _interpreter;
        Transitions _transitions;
        Ports _ports;
        Operations _operations;
        OperationParameters _operationParameters;
        EventPools _eventPools;
        EventsParameters _eventsParameters;
        PassiveObjects _passiveObjects;
        ActiveObjects _activeObjects;
        SignalEvents _signalEvents;
        ClassInfo _classInfo;
        PropertiesRO _propertiesRO;
        Store _store;
        ActionLanguages _actionLanguages;
        AUmlSerializer _aUmlSerializer;
        UmlModelSerializer _umlModelSerializer;
        this.umlModel = _umlModelSerializer = new UmlModelSerializer(rm);
        this.umlSerializer = _aUmlSerializer = new AUmlSerializer(rm, table, strategy);
        this.actionLanguages = _actionLanguages = new ActionLanguages(rm);
        this.store = _store = new Store(rm);
        this.peers = _propertiesRO = new PropertiesRO(rm);
        this.classInfo = _classInfo = new ClassInfo(rm);
        this.signalEvents = _signalEvents = new SignalEvents(rm);
        this.activeObjects = _activeObjects = new ActiveObjects(rm);
        this.passiveObjects = _passiveObjects = new PassiveObjects(rm);
        this.eventsParameters = _eventsParameters = new EventsParameters(rm);
        this.eventPools = _eventPools = new EventPools(rm);
        this.operationParameters = _operationParameters = new OperationParameters(rm);
        this.operations = _operations = new Operations(rm);
        this.ports = _ports = new Ports(rm);
        this.transitions = _transitions = new Transitions(rm);
        this.interpreter = _interpreter = new Interpreter(rm);
        this.enumerations = _enumerations = new Enumerations(rm);
        this.schedulingPolicyFP = _schedulingPolicyFP = new SchedulingPolicyFP(rm, configSchedulingFP);
        this.observers = _observers = new Observers(rm);
    }

    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#ifndef MODEL_H");
        _builder.newLine();
        _builder.append("#define MODEL_H");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @file model.h");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Define the UML model to interpret.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This file is automatically generated by the uml-serializer-c tool.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Do not modify manually.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author Matthias Brun (matthias.brun@eseo.fr)");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author Valentin Besnard (valentin.besnard@eseo.fr)");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"types_calibration.h\"");
        _builder.newLine();
        _builder.append("//#include \"interpreter/interpreter.h\"");
        _builder.newLine();
        _builder.append("#include \"interpreter/active_object.h\"");
        _builder.newLine();
        _builder.append("#include \"interpreter/passive_object.h\"");
        _builder.newLine();
        _builder.newLine();
        String _serializeHeadersTypedef = this.observers.serializeHeadersTypedef();
        _builder.append(_serializeHeadersTypedef);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeDeclarations = this.umlSerializer.serializeDeclarations();
        _builder.append(_serializeDeclarations);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_1 = this.enumerations.serializeHeadersTypedef();
        _builder.append(_serializeHeadersTypedef_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_2 = this.eventsParameters.serializeHeadersTypedef();
        _builder.append(_serializeHeadersTypedef_2);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_3 = this.store.serializeHeadersTypedef();
        _builder.append(_serializeHeadersTypedef_3);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_4 = this.signalEvents.serializeHeadersTypedef();
        _builder.append(_serializeHeadersTypedef_4);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_5 = this.eventPools.serializeHeadersTypedef();
        _builder.append(_serializeHeadersTypedef_5);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_6 = this.peers.serializeHeadersTypedef();
        _builder.append(_serializeHeadersTypedef_6);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_7 = this.transitions.serializeHeadersTypedef();
        _builder.append(_serializeHeadersTypedef_7);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_8 = this.classInfo.serializeHeadersTypedef();
        _builder.append(_serializeHeadersTypedef_8);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_9 = this.activeObjects.serializeHeadersTypedef();
        _builder.append(_serializeHeadersTypedef_9);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_10 = this.passiveObjects.serializeHeadersTypedef();
        _builder.append(_serializeHeadersTypedef_10);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_11 = this.operationParameters.serializeHeadersTypedef();
        _builder.append(_serializeHeadersTypedef_11);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_12 = this.operations.serializeHeadersTypedef();
        _builder.append(_serializeHeadersTypedef_12);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_13 = this.ports.serializeHeadersTypedef();
        _builder.append(_serializeHeadersTypedef_13);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeadersTypedef_14 = this.interpreter.serializeHeadersTypedef();
        _builder.append(_serializeHeadersTypedef_14);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaderTypdef = this.schedulingPolicyFP.serializeHeaderTypdef();
        _builder.append(_serializeHeaderTypdef);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        String _serializeHeaders = this.umlModel.serializeHeaders();
        _builder.append(_serializeHeaders);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_1 = this.eventsParameters.serializeHeaders();
        _builder.append(_serializeHeaders_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_2 = this.operationParameters.serializeHeaders();
        _builder.append(_serializeHeaders_2);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_3 = this.store.serializeHeaders();
        _builder.append(_serializeHeaders_3);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_4 = this.signalEvents.serializeHeaders();
        _builder.append(_serializeHeaders_4);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_5 = this.eventPools.serializeHeaders();
        _builder.append(_serializeHeaders_5);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_6 = this.operations.serializeHeaders();
        _builder.append(_serializeHeaders_6);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_7 = this.transitions.serializeHeaders();
        _builder.append(_serializeHeaders_7);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_8 = this.classInfo.serializeHeaders();
        _builder.append(_serializeHeaders_8);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_9 = this.activeObjects.serializeHeaders();
        _builder.append(_serializeHeaders_9);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_10 = this.passiveObjects.serializeHeaders();
        _builder.append(_serializeHeaders_10);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_11 = this.peers.serializeHeaders();
        _builder.append(_serializeHeaders_11);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serializeHeaders_12 = this.ports.serializeHeaders();
        _builder.append(_serializeHeaders_12);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif /* MODEL_H */");
        _builder.newLine();
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @file model.c");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Define the UML model to interpret.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This file is automatically generated by the uml-serializer-c tool.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Do not modify manually.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author Matthias Brun (matthias.brun@eseo.fr)");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author Valentin Besnard (valentin.besnard@eseo.fr)");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include <stdlib.h>");
        _builder.newLine();
        _builder.append("#include <stdio.h>");
        _builder.newLine();
        _builder.append("#include <stddef.h>");
        _builder.newLine();
        _builder.append("#include <string.h>");
        _builder.newLine();
        _builder.append("#include <unistd.h>");
        _builder.newLine();
        _builder.append("#ifdef MATH_LIBRARY");
        _builder.newLine();
        _builder.append("#include <math.h>");
        _builder.newLine();
        _builder.append("#endif /* MATH_LIBRARY */");
        _builder.newLine();
        _builder.append("#include \"model.h\"");
        _builder.newLine();
        _builder.append("#include \"identifiers.h\"");
        _builder.newLine();
        _builder.append("#include \"metamodel/uml.h\"");
        _builder.newLine();
        _builder.append("#include \"interpreter/action_language/action_language.h\"");
        _builder.newLine();
        _builder.append("#include \"interpreter/guard_evaluator/guard_evaluator.h\"");
        _builder.newLine();
        _builder.append("#include \"interpreter/effect_interpreter/effect_interpreter.h\"");
        _builder.newLine();
        _builder.append("#include \"interpreter/event_pool/event_pool.h\"");
        _builder.newLine();
        _builder.append("#include \"interpreter/store.h\"");
        _builder.newLine();
        _builder.append("#include \"utilities/types.h\"");
        _builder.newLine();
        _builder.append("#include \"trace/trace.h\"");
        _builder.newLine();
        _builder.append("#include \"target/bsp/uml_api.h\"");
        _builder.newLine();
        _builder.append("#include \"target/bsp/utils.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        String _serializeDeclarations = this.actionLanguages.serializeDeclarations();
        _builder.append(_serializeDeclarations);
        _builder.newLineIfNotEmpty();
        _builder.append("\n\n\n");
        _builder.newLineIfNotEmpty();
        String _serialize = this.umlModel.serialize();
        _builder.append(_serialize);
        _builder.newLineIfNotEmpty();
        String _serialize_1 = this.umlSerializer.serialize();
        _builder.append(_serialize_1);
        _builder.newLineIfNotEmpty();
        String _serialize_2 = this.actionLanguages.serialize();
        _builder.append(_serialize_2);
        _builder.newLineIfNotEmpty();
        _builder.append("\n\n\n");
        _builder.newLineIfNotEmpty();
        String _serialize_3 = this.eventsParameters.serialize();
        _builder.append(_serialize_3);
        _builder.newLineIfNotEmpty();
        _builder.append("\n\n\n");
        _builder.newLineIfNotEmpty();
        String _serialize_4 = this.operationParameters.serialize();
        _builder.append(_serialize_4);
        _builder.newLineIfNotEmpty();
        _builder.append("\n\n\n");
        _builder.newLineIfNotEmpty();
        String _serialize_5 = this.store.serialize();
        _builder.append(_serialize_5);
        _builder.newLineIfNotEmpty();
        _builder.append("\n\n\n");
        _builder.newLineIfNotEmpty();
        String _serialize_6 = this.signalEvents.serialize();
        _builder.append(_serialize_6);
        _builder.newLineIfNotEmpty();
        _builder.append("\n\n\n");
        _builder.newLineIfNotEmpty();
        String _serialize_7 = this.eventPools.serialize();
        _builder.append(_serialize_7);
        _builder.newLineIfNotEmpty();
        _builder.append("\n\n\n");
        _builder.newLineIfNotEmpty();
        String _serialize_8 = this.operations.serialize();
        _builder.append(_serialize_8);
        _builder.newLineIfNotEmpty();
        _builder.append("\n\n\n");
        _builder.newLineIfNotEmpty();
        String _serialize_9 = this.transitions.serialize();
        _builder.append(_serialize_9);
        _builder.newLineIfNotEmpty();
        _builder.append("\n\n\n");
        _builder.newLineIfNotEmpty();
        String _serialize_10 = this.classInfo.serialize();
        _builder.append(_serialize_10);
        _builder.newLineIfNotEmpty();
        _builder.append("\n\n\n");
        _builder.newLineIfNotEmpty();
        String _serialize_11 = this.activeObjects.serialize();
        _builder.append(_serialize_11);
        _builder.newLineIfNotEmpty();
        _builder.append("\n\n\n");
        _builder.newLineIfNotEmpty();
        String _serialize_12 = this.passiveObjects.serialize();
        _builder.append(_serialize_12);
        _builder.newLineIfNotEmpty();
        _builder.append("\n\n\n");
        _builder.newLineIfNotEmpty();
        String _serialize_13 = this.peers.serialize();
        _builder.append(_serialize_13);
        _builder.newLineIfNotEmpty();
        _builder.append("\n\n\n");
        _builder.newLineIfNotEmpty();
        String _serialize_14 = this.ports.serialize();
        _builder.append(_serialize_14);
        _builder.newLineIfNotEmpty();
        _builder.append("\n\n\n");
        _builder.newLineIfNotEmpty();
        String _serialize_15 = this.interpreter.serialize();
        _builder.append(_serialize_15);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder.toString();
    }
}

