/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.memoryobjects;

import emi.serializer.memoryobjects.Objects;
import emi.serializer.memoryobjects.Operations;
import emi.serializer.memoryobjects.PropertiesRO;
import emi.serializer.model.ClassifierInstance;
import emi.serializer.model.PartClassifierInstance;
import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlNavigation;
import emi.serializer.utils.UmlSerializerExtensions;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class PassiveObjects
extends Objects {
    private final List<Class> passiveClasses;
    private final List<ClassifierInstance> passiveObjectsMAIN;
    private final List<ClassifierInstance> passiveObjectsOBS;
    private final PropertiesRO peers;

    public PassiveObjects(ResourceManager rm) {
        PropertiesRO _propertiesRO;
        this.passiveClasses = UmlNavigation.getPassiveClasses(rm);
        this.passiveObjectsMAIN = UmlNavigation.getPassiveObjectsListOfComposite(rm, "Main");
        this.passiveObjectsOBS = UmlNavigation.getPassiveObjectsListOfComposite(rm, "Obs");
        this.peers = _propertiesRO = new PropertiesRO(rm);
    }

    public static String getPassiveObjectName(ClassifierInstance passiveObject) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("po_");
        String _instQualifiedName = passiveObject.getInstQualifiedName();
        _builder.append(_instQualifiedName);
        return _builder.toString();
    }

    private String specificPassiveTypeToC(Classifier passiveClass) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("SPECIFIC_STRUCT_PassiveObject(");
        String _name = passiveClass.getName();
        _builder.append(_name);
        _builder.append(")");
        return _builder.toString();
    }

    private String passiveObjectToC(ClassifierInstance passiveObject, int nbPeers) {
        String _xblockexpression = null;
        Classifier classifier = passiveObject.getClassifier();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Struct initializer for the ");
        String _name = passiveObject.getName();
        _builder.append(_name, " ");
        _builder.append(" passive object.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        String _name_1 = classifier.getName();
        _builder.append(_name_1);
        _builder.append("_Object ");
        String _passiveObjectName = PassiveObjects.getPassiveObjectName(passiveObject);
        _builder.append(_passiveObjectName);
        _builder.append(" = {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _passiveObjectCoreToC = this.passiveObjectCoreToC(passiveObject, nbPeers);
        _builder.append(_passiveObjectCoreToC, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String passiveObjectRefToC(ClassifierInstance passiveObject) {
        String _xblockexpression = null;
        Classifier classifier = passiveObject.getClassifier();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("extern ");
        String _name = classifier.getName();
        _builder.append(_name);
        _builder.append("_Object ");
        String _passiveObjectName = PassiveObjects.getPassiveObjectName(passiveObject);
        _builder.append(_passiveObjectName);
        _builder.append(";");
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String passiveObjectCoreToC(ClassifierInstance passiveObject, int nbPeers) {
        boolean _notEquals_1;
        boolean _notEquals;
        String _xblockexpression = null;
        InstanceSpecification instance = passiveObject.getInstance();
        Classifier _classifier = passiveObject.getClassifier();
        Class class_ = (Class)_classifier;
        Behavior classifierBehavior = class_.getClassifierBehavior();
        String instQualifiedName = passiveObject.getInstQualifiedName();
        if (classifierBehavior != null) {
            String _name = passiveObject.getName();
            String _plus = "Passive object " + _name;
            String _plus_1 = _plus + " should not have a classifier behavior.";
            System.err.println(_plus_1);
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".name = \"");
        _builder.append(instQualifiedName);
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
        _builder.append(".classInfo = &");
        String _actualName = UmlSerializerExtensions.actualName((EObject)passiveObject.getClassifier());
        _builder.append(_actualName);
        _builder.append("_classInfo,");
        _builder.newLineIfNotEmpty();
        if (passiveObject instanceof PartClassifierInstance) {
            _builder.append(".part = (UML_Property *) &");
            String _variableName = UmlSerializerExtensions.variableName((EObject)((PartClassifierInstance)passiveObject).getPart());
            _builder.append(_variableName);
            _builder.append(",");
            _builder.newLineIfNotEmpty();
        }
        _builder.append(".properties_ro = (void *) &(properties_ro.");
        String _instQualifiedName = passiveObject.getInstQualifiedName();
        _builder.append(_instQualifiedName);
        _builder.append("),");
        _builder.newLineIfNotEmpty();
        _builder.append(".nb_properties_ro = ");
        _builder.append((Object)nbPeers);
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        if (instance != null) {
            _builder.append(".instance = &");
            String _name_1 = passiveObject.getInstance().getName();
            _builder.append(_name_1);
            _builder.append("_od_specification,");
            _builder.newLineIfNotEmpty();
            _builder.append(".instanceSize = sizeof(");
            String _name_2 = class_.getName();
            _builder.append(_name_2);
            _builder.append("_od),");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append(".instance = NULL,");
            _builder.newLine();
            _builder.append(".instanceSize = 0,");
            _builder.newLine();
        }
        int _length = ((Object[])Conversions.unwrapArray(Operations.getOperations(class_), Object.class)).length;
        boolean bl = _notEquals = _length != 0;
        if (_notEquals) {
            _builder.append(".operations = &");
            String _name_3 = class_.getName();
            _builder.append(_name_3);
            _builder.append("_operations_vtable,");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append(".operations = NULL,");
            _builder.newLine();
        }
        _builder.append(".multiplicity_id = ");
        int _multiplicityId = passiveObject.getMultiplicityId();
        _builder.append((Object)_multiplicityId);
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append(".store = &(store.");
        _builder.append(instQualifiedName);
        _builder.append("),");
        _builder.newLineIfNotEmpty();
        int _length_1 = ((Object[])Conversions.unwrapArray(UmlNavigation.getAttributesNotPeers((Classifier)class_), Object.class)).length;
        boolean bl2 = _notEquals_1 = _length_1 != 0;
        if (_notEquals_1) {
            _builder.append(".properties_rw = &(store.");
            _builder.append(instQualifiedName);
            _builder.append(".od)");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append(".properties_rw = NULL");
            _builder.newLine();
        }
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String fieldTypeToC(ClassifierInstance passiveObject) {
        String _xblockexpression = null;
        Classifier classifier = passiveObject.getClassifier();
        StringConcatenation _builder = new StringConcatenation();
        String _name = classifier.getName();
        _builder.append(_name);
        _builder.append("_Object * ");
        String _instQualifiedName = passiveObject.getInstQualifiedName();
        _builder.append(_instQualifiedName);
        _builder.append(";");
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String fieldToC(ClassifierInstance e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".");
        String _instQualifiedName = e.getInstQualifiedName();
        _builder.append(_instQualifiedName);
        _builder.append(" = &");
        String _passiveObjectName = PassiveObjects.getPassiveObjectName(e);
        _builder.append(_passiveObjectName);
        return _builder.toString();
    }

    public String serializeHeadersTypedef() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Typedef of passive objects types.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.specificTypedefToC((Classifier)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.passiveClasses, (Functions.Function1)_function), (CharSequence)"\n");
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _builder.append("typedef struct PassiveObjects PassiveObjects;");
        _builder.newLine();
        return _builder.toString();
    }

    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Specific types for passive objects.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.specificPassiveTypeToC((Classifier)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.passiveClasses, (Functions.Function1)_function), (CharSequence)"\n");
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Active objects definition.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> this.passiveObjectRefToC((ClassifierInstance)it);
        String _join_1 = IterableExtensions.join((Iterable)ListExtensions.map(this.passiveObjectsMAIN, (Functions.Function1)_function_1), (CharSequence)"\n");
        _builder.append(_join_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The PassiveObjects type used to gather all passive objects");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("struct PassiveObjects {");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function_2 = it -> this.fieldTypeToC((ClassifierInstance)it);
        String _join_2 = IterableExtensions.join((Iterable)ListExtensions.map(this.passiveObjectsMAIN, (Functions.Function1)_function_2), (CharSequence)"\n");
        _builder.append(_join_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#ifdef WITH_OBSERVERS");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function_3 = it -> this.fieldTypeToC((ClassifierInstance)it);
        String _join_3 = IterableExtensions.join((Iterable)ListExtensions.map(this.passiveObjectsOBS, (Functions.Function1)_function_3), (CharSequence)"\n");
        _builder.append(_join_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.append("extern PassiveObjects passiveObjects;");
        _builder.newLine();
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> {
            String _xblockexpression = null;
            Classifier _classifier = it.getClassifier();
            int nbPeers = this.peers.getNbReadOnlyAttributes((Class)_classifier);
            _xblockexpression = this.passiveObjectToC((ClassifierInstance)it, nbPeers);
            return _xblockexpression;
        };
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.passiveObjectsMAIN, (Functions.Function1)_function));
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifdef WITH_OBSERVERS");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> {
            String _xblockexpression = null;
            Classifier _classifier = it.getClassifier();
            int nbPeers = this.peers.getNbReadOnlyAttributes((Class)_classifier);
            _xblockexpression = this.passiveObjectToC((ClassifierInstance)it, nbPeers);
            return _xblockexpression;
        };
        String _join_1 = IterableExtensions.join((Iterable)ListExtensions.map(this.passiveObjectsOBS, (Functions.Function1)_function_1));
        _builder.append(_join_1);
        _builder.newLineIfNotEmpty();
        _builder.append("#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Struct initializer for passive objects.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("PassiveObjects passiveObjects = {");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function_2 = it -> this.fieldToC((ClassifierInstance)it);
        String _join_2 = IterableExtensions.join((Iterable)ListExtensions.map(this.passiveObjectsMAIN, (Functions.Function1)_function_2), (CharSequence)",\n");
        _builder.append(_join_2, "\t");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#ifdef WITH_OBSERVERS");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function_3 = it -> this.fieldToC((ClassifierInstance)it);
        String _join_3 = IterableExtensions.join((Iterable)ListExtensions.map(this.passiveObjectsOBS, (Functions.Function1)_function_3), (CharSequence)",\n");
        _builder.append(_join_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        return _builder.toString();
    }
}

