/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.memoryobjects;

import emi.serializer.model.ClassifierInstance;
import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlNavigation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Region;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class Observers {
    private final List<ClassifierInstance> observers;

    public Observers(ResourceManager rm) {
        this.observers = UmlNavigation.getActiveObjectsListOfComposite(rm, "Obs");
    }

    public int computeMaximumFireablesForAllObservers(List<Class> classifiers) {
        Functions.Function1 _function = it -> {
            Functions.Function1 _function_1 = it_1 -> it_1.getOutgoings().size();
            return (Integer)IterableExtensions.max((Iterable)ListExtensions.map((List)((Region)IterableExtensions.head((Iterable)UmlNavigation.getStateMachine(it).getRegions())).getSubvertices(), (Functions.Function1)_function_1));
        };
        Functions.Function2 _function_1 = (a, b) -> a * b;
        return (Integer)IterableExtensions.reduce((Iterable)ListExtensions.map(classifiers, (Functions.Function1)_function), (Functions.Function2)_function_1);
    }

    public String serializeHeadersTypedef() {
        String _xblockexpression = null;
        ArrayList<Class> observerClasses = new ArrayList<Class>();
        Functions.Function1 _function = it -> it.getClassifier();
        Consumer<Classifier> _function_1 = it -> {
            if (it instanceof Class) {
                observerClasses.add((Class)it);
            }
        };
        ListExtensions.map(this.observers, (Functions.Function1)_function).forEach(_function_1);
        int nbObservers = this.observers.size();
        int maxFireableForAllObservers = 0;
        if (nbObservers != 0) {
            maxFireableForAllObservers = this.computeMaximumFireablesForAllObservers(observerClasses);
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Number of observers in the model (observers that are active objects).");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("#define NB_OBSERVERS (");
        _builder.append((Object)nbObservers);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Maximum number of fireables for all observers. ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* With observer as Buch\u00ef = MAX_FIREABLE_PER_OBSERVER ^ NB_OBSERVERS gives an overapproximation of the value");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* With deterministic observers = NB_OBSERVERS");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("#ifdef WITH_BUCHI");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define MAX_FIREABLES_FOR_ALL_OBSERVERS (");
        _builder.append((Object)maxFireableForAllObservers, "\t");
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("#else");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define MAX_FIREABLES_FOR_ALL_OBSERVERS (NB_OBSERVERS)");
        _builder.newLine();
        _builder.append("#endif /* WITH_BUCHI */");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String serializeHeaders() {
        return "";
    }

    public String serialize() {
        return "";
    }
}

