/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.memoryobjects;

import emi.serializer.model.ClassifierInstance;
import emi.serializer.model.GlobalClassifierInstance;
import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlNavigation;
import java.util.List;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class Interpreter {
    private final List<ClassifierInstance> objectsMAIN;
    private final List<ClassifierInstance> objectsOBS;

    public Interpreter(ResourceManager rm) {
        this.objectsMAIN = UmlNavigation.collectClassifierInstanceWithCompositeClass(rm, "Main");
        this.objectsOBS = UmlNavigation.collectClassifierInstanceWithCompositeClass(rm, "Obs");
    }

    public String serializeStructInitializerInterpreter() {
        String _xblockexpression = null;
        int nbObjectsInMAIN = this.objectsMAIN.size();
        Functions.Function1 _function = it -> {
            Classifier _classifier = it.getClassifier();
            return ((Class)_classifier).isActive();
        };
        int nbActiveObjectsInMAIN = IterableExtensions.toList((Iterable)IterableExtensions.filter(this.objectsMAIN, (Functions.Function1)_function)).size();
        int nbPassiveObjectsInMAIN = nbObjectsInMAIN - nbActiveObjectsInMAIN;
        Functions.Function1 _function_1 = it -> it instanceof GlobalClassifierInstance;
        ClassifierInstance obs = (ClassifierInstance)IterableExtensions.findFirst(this.objectsOBS, (Functions.Function1)_function_1);
        int nbObjectsInOBS = this.objectsOBS.size();
        Functions.Function1 _function_2 = it -> {
            Classifier _classifier = it.getClassifier();
            return ((Class)_classifier).isActive();
        };
        int nbActiveObjectsInOBS = IterableExtensions.toList((Iterable)IterableExtensions.filter(this.objectsOBS, (Functions.Function1)_function_2)).size();
        int nbPassiveObjectsInOBS = nbObjectsInOBS - nbActiveObjectsInOBS;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Interpreter interpreter_system = {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(".activeObjects = (ActiveObject **) (((char *) &activeObjects) + 0 * sizeof(ActiveObject *)),");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(".offsetActiveObjectsId = 0,");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(".nbActiveObjects = ");
        _builder.append((Object)nbActiveObjectsInMAIN, "\t");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(".passiveObjects = (PassiveObject **) (((char *) &passiveObjects) + 0 * sizeof(PassiveObject *)),");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(".nbPassiveObjects = ");
        _builder.append((Object)nbPassiveObjectsInMAIN, "\t");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(".store = &store, // Do not begin at &(store.instMAIN) to take into account the scheduling state");
        _builder.newLine();
        _builder.append("\t");
        StringConcatenation _xifexpression = null;
        if (obs == null) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(".storeSize = sizeof(Store)");
            _xifexpression = _builder_1;
        } else {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("#ifdef WITH_OBSERVERS");
            _builder_2.newLine();
            _builder_2.append(".storeSize = offsetof(Store, ");
            String _name = obs.getName();
            _builder_2.append(_name);
            _builder_2.append(")");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("#else");
            _builder_2.newLine();
            _builder_2.append(".storeSize = sizeof(Store)");
            _builder_2.newLine();
            _builder_2.append("#endif");
            _xifexpression = _builder_2;
        }
        _builder.append((Object)_xifexpression, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#ifdef WITH_OBSERVERS");
        _builder.newLine();
        _builder.append("Interpreter interpreter_observers = {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(".activeObjects = (ActiveObject **) (((char *) &activeObjects) + ");
        _builder.append((Object)nbActiveObjectsInMAIN, "\t");
        _builder.append(" * sizeof(ActiveObject *)),");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(".offsetActiveObjectsId = ");
        _builder.append((Object)nbActiveObjectsInMAIN, "\t");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(".nbActiveObjects = ");
        _builder.append((Object)nbActiveObjectsInOBS, "\t");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(".passiveObjects = (PassiveObject **) (((char *) &passiveObjects) + ");
        _builder.append((Object)nbPassiveObjectsInMAIN, "\t");
        _builder.append(" * sizeof(PassiveObject *)),");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(".nbPassiveObjects = ");
        _builder.append((Object)nbPassiveObjectsInOBS, "\t");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        StringConcatenation _xifexpression_1 = null;
        if (obs != null) {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append(".store = &(store.");
            String _name_1 = obs.getName();
            _builder_3.append(_name_1);
            _builder_3.append("),");
            _builder_3.newLineIfNotEmpty();
            _builder_3.append(".storeSize = sizeof(Store) - offsetof(Store, ");
            String _name_2 = obs.getName();
            _builder_3.append(_name_2);
            _builder_3.append(")");
            _builder_3.newLineIfNotEmpty();
            _xifexpression_1 = _builder_3;
        } else {
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append(".store = NULL,");
            _builder_4.newLine();
            _builder_4.append(".storeSize = 0");
            _builder_4.newLine();
            _xifexpression_1 = _builder_4;
        }
        _builder.append((Object)_xifexpression_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _builder.append("#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String serializeHeadersTypedef() {
        return "";
    }

    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("extern Interpreter interpreter_system;");
        _builder.newLine();
        _builder.append("#ifdef WITH_OBSERVERS");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("extern Interpreter interpreter_observers;");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        String _serializeStructInitializerInterpreter = this.serializeStructInitializerInterpreter();
        _builder.append(_serializeStructInitializerInterpreter);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }
}

