/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.client;

import emi.analysis.client.AEMIClient;
import emi.analysis.exception.EMIException;
import emi.analysis.model.EMIAtom;
import emi.analysis.model.EMIConfiguration;
import emi.analysis.model.EMIFireableTransitionComposite;
import emi.analysis.protocol.EMIProtocol;
import emi.analysis.protocol.EMIProtocolAtoms;
import emi.analysis.protocol.EMIProtocolConfiguration;
import emi.analysis.protocol.EMIProtocolFireableTransitionComposite;
import emi.analysis.protocol.EMIProtocolTranslation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class EMISynchronousClient
extends AEMIClient {
    public EMISynchronousClient(String address, int port) throws EMIException {
        super(address, port);
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        catch (IOException e) {
            throw new IOException("EMI synchronous client exception: " + e.getMessage());
        }
    }

    public EMIConfiguration startDiffMode() throws EMIException {
        EMIConfiguration configuration;
        try {
            EMIProtocol.writeHeader(this.getConnection(), new EMIProtocol.Header(3));
            EMIProtocol.Header header = EMIProtocol.readHeader(this.getConnection());
            if (header.kind != 2) {
                throw this.createException(header);
            }
            configuration = this.readResponseStartDiffMode(header);
        }
        catch (IOException e) {
            throw new EMIException("EMI synchronous client start diff mode exception: " + e.getMessage());
        }
        return configuration;
    }

    public EMIConfiguration reset() throws EMIException {
        EMIConfiguration configuration;
        try {
            if (this.isDiffMode().booleanValue()) {
                EMIProtocol.writeHeader(this.getConnection(), new EMIProtocol.Header(2));
            } else {
                EMIProtocol.writeHeader(this.getConnection(), new EMIProtocol.Header(1));
            }
            configuration = this.readConfiguration();
        }
        catch (IOException e) {
            throw new EMIException("EMI synchronous client reset exception: " + e.getMessage());
        }
        return configuration;
    }

    public EMIConfiguration getConfiguration() throws EMIException {
        EMIConfiguration configuration;
        try {
            if (this.isDiffMode().booleanValue()) {
                EMIProtocol.writeHeader(this.getConnection(), new EMIProtocol.Header(5));
            } else {
                EMIProtocol.writeHeader(this.getConnection(), new EMIProtocol.Header(4));
            }
            configuration = this.readConfiguration();
        }
        catch (IOException e) {
            throw new EMIException("EMI synchronous client get configuration exception: " + e.getMessage());
        }
        return configuration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EMIConfiguration readConfiguration() throws IOException {
        EMIProtocol.Header header = EMIProtocol.readHeader(this.getConnection());
        if (this.isDiffMode().booleanValue()) {
            if (header.kind != 4) throw this.createException(header);
            return this.readResponseGetConfigurationDiff(header);
        }
        if (header.kind != 3) throw this.createException(header);
        return EMIProtocolConfiguration.deserialize(this.getConnection().read(header.size));
    }

    public ArrayList<EMIFireableTransitionComposite> getFireableTransitions() throws EMIException {
        ArrayList<EMIFireableTransitionComposite> fireableTransitions;
        try {
            EMIProtocol.writeHeader(this.getConnection(), new EMIProtocol.Header(8));
            fireableTransitions = this.readFireableTransitions();
        }
        catch (IOException e) {
            throw new EMIException("EMI synchronous client get fireable transition exception: " + e.getMessage());
        }
        return fireableTransitions;
    }

    public ArrayList<EMIFireableTransitionComposite> getFireableTransitions(EMIConfiguration configuration) throws EMIException {
        ArrayList<EMIFireableTransitionComposite> fireableTransitions;
        if (configuration == null) {
            throw new EMIException("EMI synchronous client get fireable transitions stateless exception: configuration is null");
        }
        try {
            this.sendRequestGetFireableTransition(configuration);
            fireableTransitions = this.readFireableTransitions();
        }
        catch (IOException e) {
            throw new EMIException("EMI synchronous client get fireable transitions stateless exception: " + e.getMessage());
        }
        return fireableTransitions;
    }

    private ArrayList<EMIFireableTransitionComposite> readFireableTransitions() throws IOException {
        ArrayList<EMIFireableTransitionComposite> fireableTransitions = new ArrayList<EMIFireableTransitionComposite>();
        EMIProtocol.Header header = EMIProtocol.readHeader(this.getConnection());
        if (header.kind != 5) {
            throw this.createException(header);
        }
        EMIProtocolFireableTransitionComposite.deserialize(fireableTransitions, this.getConnection().read(header.size));
        return fireableTransitions;
    }

    public EMIConfiguration fireTransition(EMIFireableTransitionComposite transition, EMIConfiguration configuration) throws EMIException {
        EMIConfiguration returnConfiguration;
        if (transition == null) {
            throw new EMIException("EMI synchronous client fire transition stateless exception: transition is null");
        }
        if (configuration == null) {
            throw new EMIException("EMI synchronous client fire transition stateless exception: configuration is null");
        }
        try {
            this.sendRequestFireTransition(transition, configuration);
            returnConfiguration = this.readConfiguration();
        }
        catch (IOException e) {
            throw new EMIException("EMI synchronous client fire transition stateless exception: " + e.getMessage());
        }
        return returnConfiguration;
    }

    public int[] evaluateAtoms(EMIAtom[] atoms, List<byte[]> params) throws EMIException {
        int[] atomEvaluations;
        if (atoms == null) {
            throw new EMIException("EMI synchronous client evaluate atoms exception: atoms are null");
        }
        try {
            this.sendRequestEvaluateAtoms(atoms, params);
            atomEvaluations = this.readEvaluationOfAtoms();
        }
        catch (IOException e) {
            throw new EMIException("EMI synchronous client evaluate atoms exception: " + e.getMessage());
        }
        return atomEvaluations;
    }

    protected int[] readEvaluationOfAtoms() throws IOException {
        EMIProtocol.Header header = EMIProtocol.readHeader(this.getConnection());
        if (header.kind != 6) {
            throw this.createException(header);
        }
        int[] atomEvaluations = EMIProtocolAtoms.deserializeEvaluationResults(this.getConnection().read(header.size));
        return atomEvaluations;
    }

    public String getTranslation(EMIConfiguration configuration) throws EMIException {
        String translatedConfiguration;
        if (configuration == null) {
            throw new EMIException("EMI synchronous client get translation: configuration is null");
        }
        try {
            this.sendRequestTranslate(configuration);
            translatedConfiguration = this.readTranslationOfConfiguration();
        }
        catch (IOException e) {
            throw new EMIException("EMI synchronous client get translation: " + e.getMessage());
        }
        return translatedConfiguration;
    }

    private String readTranslationOfConfiguration() throws IOException {
        EMIProtocol.Header header = EMIProtocol.readHeader(this.getConnection());
        if (header.kind != 101) {
            throw this.createException(header);
        }
        String translatedConfiguration = EMIProtocolTranslation.deserialize(this.getConnection().read(header.size));
        return translatedConfiguration;
    }

    public String getTranslation(EMIFireableTransitionComposite transition) throws EMIException {
        String translatedTransition;
        if (transition == null) {
            throw new EMIException("EMI synchronous client get translation: fireable transition is null");
        }
        try {
            this.sendRequestTranslate(transition);
            translatedTransition = this.readTranslationOfFireableTransition();
        }
        catch (IOException e) {
            throw new EMIException("EMI synchronous client get translation: " + e.getMessage());
        }
        return translatedTransition;
    }

    private String readTranslationOfFireableTransition() throws IOException {
        EMIProtocol.Header header = EMIProtocol.readHeader(this.getConnection());
        if (header.kind != 102) {
            throw this.createException(header);
        }
        String translatedFireableTransition = EMIProtocolTranslation.deserialize(this.getConnection().read(header.size));
        return translatedFireableTransition;
    }

    protected IOException createException(EMIProtocol.Header header) {
        switch (header.kind) {
            case 1: {
                return new IOException("error message received");
            }
        }
        return new IOException("response " + header.kind + " is not expected");
    }
}

