/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.client;

import emi.analysis.client.AEMIClient;
import emi.analysis.exception.EMIException;
import emi.analysis.model.EMIAtom;
import emi.analysis.model.EMIConfiguration;
import emi.analysis.model.EMIFireableTransitionComposite;
import emi.analysis.protocol.EMIProtocol;
import emi.analysis.protocol.EMIProtocolAtoms;
import emi.analysis.protocol.EMIProtocolConfiguration;
import emi.analysis.protocol.EMIProtocolFireableTransitionComposite;
import emi.analysis.protocol.EMIProtocolTranslation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class EMIAsynchronousClient
extends AEMIClient {
    private ICallBack callback;
    private Dispatcher dispatcher;

    public EMIAsynchronousClient(String address, int port, ICallBack callback) throws EMIException {
        super(address, port);
        this.callback = callback;
        this.dispatcher = new Dispatcher(this);
        this.dispatcher.start();
    }

    @Override
    public void close() throws IOException {
        try {
            this.dispatcher.stopRunning();
            super.close();
        }
        catch (IOException e) {
            throw new IOException("EMI asynchronous client exception: " + e.getMessage());
        }
    }

    public void startDiffMode() throws EMIException {
        try {
            EMIProtocol.writeHeader(this.getConnection(), new EMIProtocol.Header(3));
        }
        catch (IOException e) {
            throw new EMIException("EMI asynchronous client start diff mode exception: " + e.getMessage());
        }
    }

    public void reset() throws EMIException {
        try {
            if (this.isDiffMode().booleanValue()) {
                EMIProtocol.writeHeader(this.getConnection(), new EMIProtocol.Header(2));
            } else {
                EMIProtocol.writeHeader(this.getConnection(), new EMIProtocol.Header(1));
            }
        }
        catch (IOException e) {
            throw new EMIException("EMI asynchronous client reset exception: " + e.getMessage());
        }
    }

    public void getConfiguration() throws EMIException {
        try {
            if (this.isDiffMode().booleanValue()) {
                EMIProtocol.writeHeader(this.getConnection(), new EMIProtocol.Header(5));
            } else {
                EMIProtocol.writeHeader(this.getConnection(), new EMIProtocol.Header(4));
            }
        }
        catch (IOException e) {
            throw new EMIException("EMI asynchronous client get configuration exception: " + e.getMessage());
        }
    }

    public void getFireableTransitions() throws EMIException {
        try {
            EMIProtocol.writeHeader(this.getConnection(), new EMIProtocol.Header(8));
        }
        catch (IOException e) {
            throw new EMIException("EMI asynchronous client get fireable transition exception: " + e.getMessage());
        }
    }

    public void getFireableTransitions(EMIConfiguration configuration) throws EMIException {
        if (configuration == null) {
            throw new EMIException("EMI asynchronous client get fireable transitions stateless exception: configuration is null");
        }
        try {
            this.sendRequestGetFireableTransition(configuration);
        }
        catch (IOException e) {
            throw new EMIException("EMI asynchronous client get fireable transitions stateless exception: " + e.getMessage());
        }
    }

    public void fireTransition(EMIFireableTransitionComposite transition, EMIConfiguration configuration) throws EMIException {
        if (transition == null) {
            throw new EMIException("EMI asynchronous client fire transition stateless exception: transition is null");
        }
        if (configuration == null) {
            throw new EMIException("EMI asynchronous client fire transition stateless exception: configuration is null");
        }
        try {
            this.sendRequestFireTransition(transition, configuration);
        }
        catch (IOException e) {
            throw new EMIException("EMI asynchronous client fire transition stateless exception: " + e.getMessage());
        }
    }

    public void evaluateAtoms(EMIAtom[] atoms, List<byte[]> params) throws EMIException {
        if (atoms == null) {
            throw new EMIException("EMI asynchronous client evaluate atoms exception: atoms are null");
        }
        try {
            this.sendRequestEvaluateAtoms(atoms, params);
        }
        catch (IOException e) {
            throw new EMIException("EMI asynchronous client evaluate atoms exception: " + e.getMessage());
        }
    }

    public void getTranslation(EMIConfiguration configuration) throws EMIException {
        if (configuration == null) {
            throw new EMIException("EMI asynchronous client get translation: configuration is null");
        }
        try {
            this.sendRequestTranslate(configuration);
        }
        catch (IOException e) {
            throw new EMIException("EMI asynchronous client get translation: " + e.getMessage());
        }
    }

    public void getTranslation(EMIFireableTransitionComposite transition) throws EMIException {
        if (transition == null) {
            throw new EMIException("EMI asynchronous client get translation: fireable transition is null");
        }
        try {
            this.sendRequestTranslate(transition);
        }
        catch (IOException e) {
            throw new EMIException("EMI synchronous client get translation: " + e.getMessage());
        }
    }

    public static interface ICallBack {
        public void onStartDiffMode(Boolean var1, EMIConfiguration var2);

        public void onReceiveConfiguration(EMIConfiguration var1);

        public void onReceiveFirableTransitions(ArrayList<EMIFireableTransitionComposite> var1);

        public void onReceiveEvaluateAtoms(int[] var1);

        public void onReceiveTranslationOfConfiguration(String var1);

        public void onReceiveTranslationOfFireableTransition(String var1);

        public void onError(String var1);

        public void onDisconnected(String var1);
    }

    private static final class Dispatcher
    extends Thread {
        private boolean isRunning;
        private EMIAsynchronousClient client;

        private Dispatcher(EMIAsynchronousClient client) {
            this.client = client;
            this.isRunning = false;
        }

        @Override
        public void run() {
            this.isRunning = true;
            while (this.isRunning) {
                try {
                    EMIProtocol.Header header = EMIProtocol.readHeader(this.client.getConnection());
                    this.dispatch(header);
                }
                catch (IOException e) {
                    this.isRunning = false;
                    this.client.callback.onDisconnected("EMI asynchronous client dispatch stop: " + e.getMessage());
                }
            }
        }

        private void stopRunning() {
            this.isRunning = false;
        }

        private void dispatch(EMIProtocol.Header header) throws IOException {
            switch (header.kind) {
                case 2: {
                    EMIConfiguration configuration = this.client.readResponseStartDiffMode(header);
                    this.client.callback.onStartDiffMode(this.client.isDiffMode(), configuration);
                    break;
                }
                case 3: {
                    this.client.callback.onReceiveConfiguration(EMIProtocolConfiguration.deserialize(this.client.getConnection().read(header.size)));
                    break;
                }
                case 4: {
                    EMIConfiguration configuration = this.client.readResponseGetConfigurationDiff(header);
                    this.client.callback.onReceiveConfiguration(configuration);
                    break;
                }
                case 5: {
                    ArrayList<EMIFireableTransitionComposite> fireableTransitions = new ArrayList<EMIFireableTransitionComposite>();
                    EMIProtocolFireableTransitionComposite.deserialize(fireableTransitions, this.client.getConnection().read(header.size));
                    this.client.callback.onReceiveFirableTransitions(fireableTransitions);
                    break;
                }
                case 6: {
                    this.client.callback.onReceiveEvaluateAtoms(EMIProtocolAtoms.deserializeEvaluationResults(this.client.getConnection().read(header.size)));
                    break;
                }
                case 101: {
                    this.client.callback.onReceiveTranslationOfConfiguration(EMIProtocolTranslation.deserialize(this.client.getConnection().read(header.size)));
                    break;
                }
                case 102: {
                    this.client.callback.onReceiveTranslationOfFireableTransition(EMIProtocolTranslation.deserialize(this.client.getConnection().read(header.size)));
                    break;
                }
                case 1: {
                    this.client.callback.onError("error message received");
                    break;
                }
                default: {
                    throw new IOException("the received message kind is not in the protocol");
                }
            }
        }
    }
}

