/*
 * Decompiled with CFR 0.152.
 */
package plug.language.emi;

import emi.analysis.client.EMISynchronousClient;
import emi.analysis.exception.EMIException;
import emi.analysis.model.EMIModel;
import emi.analysis.standalone.client.EMISynchronousStandaloneClient;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ParserProperties;
import plug.language.emi.EMIPlugin;
import plug.language.emi.EMIRuntimeOptions;
import plug.language.emi.analysis.EMIVerifier;
import plug.language.emi.runtime.EMIRuntime;

public final class Main {
    private static EMIRuntimeOptions options;
    private static final int HELP_WIDTH = 150;

    private Main() {
    }

    private static final boolean manageOptions(String ... args) throws CmdLineException, IOException {
        CmdLineParser parser = new CmdLineParser((Object)options, ParserProperties.defaults().withOptionSorter((Comparator)options));
        try {
            parser.parseArgument(args);
            if (Main.options.help) {
                Main.printHelp(parser);
            }
            if (Main.options.version) {
                Main.printVersion();
            }
            if (Main.options.help || Main.options.version) {
                return false;
            }
            if (Main.options.configurationFile != null) {
                Main.checkConfigurationFile(parser);
            } else {
                if (Main.options.port == 0) {
                    Main.options.port = Main.options.standaloneMode ? 12345 : 12346;
                }
                Main.checkEMIHomeOption(parser);
                Main.checkEMIModelOption(parser);
                Main.checkFileOfProperties(parser);
            }
        }
        catch (CmdLineException e) {
            Main.printHelp(parser);
            throw e;
        }
        return true;
    }

    private static final void checkEMIHomeOption(CmdLineParser parser) throws CmdLineException, IOException {
        if (Main.options.standaloneMode && Main.options.emiHome == null) {
            throw new CmdLineException(parser, "EMI home directory must be set in standalone mode (for atom evaluation)", (Throwable)new Error());
        }
        if (Main.options.emiHome != null) {
            Main.options.emiHome = EMIModel.checkEMIHome((String)Main.options.emiHome);
        }
    }

    private static final void checkEMIModelOption(CmdLineParser parser) throws CmdLineException, IOException {
        if (Main.options.standaloneMode && Main.options.emiModel == null) {
            throw new CmdLineException(parser, "The EMI model must be set in standalone mode (for atom evaluation or for translation)", (Throwable)new Error());
        }
        if (Main.options.emiModel != null) {
            Main.options.emiModel = EMIModel.checkEMIModel((String)Main.options.emiModel);
        }
    }

    private static final void checkFileOfProperties(CmdLineParser parser) throws CmdLineException, IOException {
        File file;
        if (!(Main.options.fileToVerify == null || (file = new File(Main.options.fileToVerify)).exists() && file.isFile())) {
            throw new CmdLineException(parser, "The file \"" + Main.options.fileToVerify + "\" is invalid.", (Throwable)new Error());
        }
    }

    private static final void checkConfigurationFile(CmdLineParser parser) throws CmdLineException, IOException {
        File file;
        if (!(Main.options.configurationFile == null || (file = new File(Main.options.configurationFile)).exists() && file.isFile())) {
            throw new CmdLineException(parser, "The file \"" + Main.options.configurationFile + "\" is invalid.", (Throwable)new Error());
        }
    }

    private static final void printHelp(CmdLineParser parser) {
        System.out.println("Usage:");
        parser.getProperties().withUsageWidth(150);
        parser.printUsage((OutputStream)System.out);
    }

    private static final void printVersion() {
        System.out.println("Version 0.0.5 (under developement) !");
    }

    public static final void main(String[] args) throws Exception {
        block13: {
            options = new EMIRuntimeOptions();
            boolean exit = false;
            try {
                exit = !Main.manageOptions(args);
            }
            catch (IOException | CmdLineException e) {
                System.err.println(e.getMessage());
                exit = true;
            }
            finally {
                if (!exit) break block13;
                return;
            }
        }
        EMIPlugin languagePlugin = null;
        EMIRuntime runtime = null;
        System.out.println("---- Plug Runtime EMI ----");
        if (Main.options.configurationFile != null) {
            languagePlugin = new EMIPlugin();
            runtime = (EMIRuntime)languagePlugin.getLoader().getRuntime(Main.options.configurationFile);
        } else {
            Object client = null;
            try {
                client = Main.options.standaloneMode ? new EMISynchronousStandaloneClient(Main.options.address, Main.options.port, Main.options.emiModel, Main.options.emiHome, Main.options.target, Main.options.compiler, Main.options.makeTool, Main.options.dwarfTool) : new EMISynchronousClient(Main.options.address, Main.options.port);
            }
            catch (EMIException e) {
                System.err.println("Connection to the model interpreter has failed");
                return;
            }
            runtime = new EMIRuntime((EMISynchronousClient)client, Main.options.checkAtomSideEffect);
        }
        EMIVerifier verifier = new EMIVerifier(runtime);
        if (Main.options.exploration || Main.options.deadlock) {
            verifier.exploreStateSpace(Main.options.deadlock, Main.options.exportGraph);
        }
        if (Main.options.propertyToVerify != null && !"".contentEquals(Main.options.propertyToVerify)) {
            verifier.verifyProperty(Main.options.propertyToVerify, false);
        }
        if (Main.options.fileToVerify != null) {
            verifier.verifyFile(Main.options.fileToVerify, false);
        }
        if (Main.options.checkWithBuchiAutomaton && Main.options.configurationFile != null) {
            verifier.verifyViaBuchiAutomaton(languagePlugin, Main.options.configurationFile, true);
        }
        runtime.close();
        System.out.println("Plug Runtime EMI exits");
    }
}

