/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.prune;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class Prune {
    private static final String DEFAULT_FILTER_CONDITION = "false";
    private String filterCondition;

    public Prune(String filterConditionPath) {
        if (filterConditionPath != null) {
            try {
                String _string;
                byte[] _readAllBytes = Files.readAllBytes(Paths.get(filterConditionPath, new String[0]));
                this.filterCondition = _string = new String(_readAllBytes);
            }
            catch (Throwable _t) {
                if (_t instanceof IOException) {
                    this.filterCondition = DEFAULT_FILTER_CONDITION;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            boolean _contentEquals = "".contentEquals(this.filterCondition);
            if (_contentEquals) {
                this.filterCondition = DEFAULT_FILTER_CONDITION;
                System.err.println("ERROR: the prune file is empty");
            }
        } else {
            this.filterCondition = DEFAULT_FILTER_CONDITION;
        }
    }

    public String serializeHeader() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#ifndef MODELS_PRUNE_H");
        _builder.newLine();
        _builder.append("#define MODELS_PRUNE_H");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @file prune.h");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Define filter condition to prune uninteresting execution paths.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This file is automatically generated by the uml-serializer-c tool.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Do not modify manually.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author Valentin Besnard (valentin.besnard@eseo.fr)");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#ifdef PRUNE");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"types_calibration.h\"");
        _builder.newLine();
        _builder.append("#include \"interpreter/active_object.h\"");
        _builder.newLine();
        _builder.append("#include \"transition_relation/tr_interpreter.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Filter condition to prune a given execution path.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param this the active object of the fireable transition.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param __transition the fireable transition concerned.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @return true if the transition should be filtered/removed and false the transition should be kept.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("bool Prune_filter(ActiveObject * this, TRTransition * transition);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif /* PRUNE */");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif /* MODELS_PRUNE_H */");
        _builder.newLine();
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @file prune.c");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Define filter condition to prune uninteresting execution paths.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This file is automatically generated by the uml-serializer-c tool.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Do not modify manually.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author Valentin Besnard (valentin.besnard@eseo.fr)");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#ifdef PRUNE");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include <stdio.h>");
        _builder.newLine();
        _builder.append("#include <stdlib.h>");
        _builder.newLine();
        _builder.append("#include <string.h>");
        _builder.newLine();
        _builder.append("#include \"prune.h\"");
        _builder.newLine();
        _builder.append("#include \"identifiers.h\"");
        _builder.newLine();
        _builder.append("#include \"interpreter/action_language/action_language.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Filter condition to prune a given execution path.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param this the active object of the fireable transition.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param __transition the fireable transition concerned.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @return true if the transition should be filtered/removed and false the transition should be kept.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("bool Prune_filter(ActiveObject * this, TRTransition * __transition)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return (");
        _builder.append(this.filterCondition, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif /* PRUNE */");
        _builder.newLine();
        _builder.newLine();
        return _builder.toString();
    }
}

