/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.memoryobjects;

import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlNavigation;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class EventsParameters {
    private final List<Signal> signals;
    private final Set<Class> activeObjectsMAINClassifier;
    private final Set<Class> activeObjectsOBSClassifier;

    public EventsParameters(ResourceManager rm) {
        this.signals = UmlNavigation.getSignals(rm);
        Functions.Function1 _function = it -> {
            Classifier _classifier = it.getClassifier();
            return (Class)_classifier;
        };
        this.activeObjectsMAINClassifier = IterableExtensions.toSet((Iterable)ListExtensions.map(UmlNavigation.getActiveObjectsListOfComposite(rm, "Main"), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> {
            Classifier _classifier = it.getClassifier();
            return (Class)_classifier;
        };
        this.activeObjectsOBSClassifier = IterableExtensions.toSet((Iterable)ListExtensions.map(UmlNavigation.getActiveObjectsListOfComposite(rm, "Obs"), (Functions.Function1)_function_1));
    }

    private String typedefToC(Signal e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("typedef struct ");
        String _name = e.getName();
        _builder.append(_name);
        _builder.append("_signal_parameters ");
        String _name_1 = e.getName();
        _builder.append(_name_1);
        _builder.append("_signal_parameters;");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String typeToC(Signal e) {
        String _xblockexpression = null;
        EList params = e.getOwnedAttributes();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Type ");
        String _name = e.getName();
        _builder.append(_name, " ");
        _builder.append("_signal_parameters corresponding to parameters of the event ");
        String _name_1 = e.getName();
        _builder.append(_name_1, " ");
        _builder.append(".");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("struct ");
        String _name_2 = e.getName();
        _builder.append(_name_2);
        _builder.append("_signal_parameters {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Functions.Function1 _function = it -> this.subfieldTypeToC((Property)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)params, (Functions.Function1)_function));
        _builder.append(_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String subfieldTypeToC(Property e) {
        String _xblockexpression = null;
        String typeName = new String();
        boolean _equals = e.getType().getName().equals("Integer");
        if (_equals) {
            typeName = "int32_t";
        } else {
            boolean _equals_1 = e.getType().getName().equals("Boolean");
            if (_equals_1) {
                typeName = "int8_t";
            } else {
                Type _type = e.getType();
                if (_type instanceof Enumeration) {
                    StringConcatenation _builder = new StringConcatenation();
                    String _name = e.getType().getName();
                    _builder.append(_name);
                    _builder.append("_ut");
                    typeName = _builder.toString();
                } else {
                    String _name_1 = e.getType().getName();
                    String _plus = "Error: type \"" + _name_1;
                    String _plus_1 = _plus + "\" is unknown.";
                    System.err.println(_plus_1);
                }
            }
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append(typeName);
        _builder_1.append(" ");
        String _name_2 = e.getName();
        _builder_1.append(_name_2);
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
        _xblockexpression = _builder_1.toString();
        return _xblockexpression;
    }

    private String paramsSubfieldTypeToC(Signal e) {
        boolean _greaterThan;
        String _xifexpression = null;
        int _length = ((Object[])Conversions.unwrapArray((Object)e.getOwnedAttributes(), Object.class)).length;
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = e.getName();
            _builder.append(_name);
            _builder.append("_signal_parameters ");
            String _name_1 = e.getName();
            _builder.append(_name_1);
            _builder.append("_params;");
            _builder.newLineIfNotEmpty();
            _xifexpression = _builder.toString();
        } else {
            _xifexpression = "";
        }
        return _xifexpression;
    }

    private String eventsTypedefToC(Class e) {
        StringConcatenation _builder = new StringConcatenation();
        StringConcatenation _xifexpression = null;
        boolean _hasEventsParameters = UmlNavigation.hasEventsParameters(e);
        if (_hasEventsParameters) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("typedef struct ");
            String _name = e.getName();
            _builder_1.append(_name);
            _builder_1.append("_events ");
            String _name_1 = e.getName();
            _builder_1.append(_name_1);
            _builder_1.append("_events;");
            _builder_1.newLineIfNotEmpty();
            _xifexpression = _builder_1;
        }
        _builder.append(_xifexpression);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String eventsTypeToC(Class e) {
        StringConcatenation _builder = new StringConcatenation();
        StringConcatenation _xifexpression = null;
        boolean _hasEventsParameters = UmlNavigation.hasEventsParameters(e);
        if (_hasEventsParameters) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("/**");
            _builder_1.newLine();
            _builder_1.append(" ");
            _builder_1.append("* Type ");
            String _name = e.getName();
            _builder_1.append(_name, " ");
            _builder_1.append("_events corresponding to an event of the event pool.");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append(" ");
            _builder_1.append("*/");
            _builder_1.newLine();
            _builder_1.append("struct ");
            String _name_1 = e.getName();
            _builder_1.append(_name_1);
            _builder_1.append("_events {");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.append("union {");
            _builder_1.newLine();
            _builder_1.append("\t\t");
            Functions.Function1 _function = it -> this.paramsSubfieldTypeToC((Signal)it);
            String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)IterableExtensions.toSet(UmlNavigation.getSignals(e)), (Functions.Function1)_function));
            _builder_1.append(_join, "\t\t");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.append("};");
            _builder_1.newLine();
            _builder_1.append("};");
            _builder_1.newLine();
            _xifexpression = _builder_1;
        }
        _builder.append(_xifexpression);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serializeHeadersTypedef() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Typedef for events parameters.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.typedefToC((Signal)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.signals, (Functions.Function1)_function));
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Typedef for events.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> this.eventsTypedefToC((Class)it);
        String _join_1 = IterableExtensions.join((Iterable)IterableExtensions.map(this.activeObjectsMAINClassifier, (Functions.Function1)_function_1));
        _builder.append(_join_1);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifdef WITH_OBSERVERS");
        _builder.newLine();
        Functions.Function1 _function_2 = it -> this.eventsTypedefToC((Class)it);
        String _join_2 = IterableExtensions.join((Iterable)IterableExtensions.map(this.activeObjectsOBSClassifier, (Functions.Function1)_function_2));
        _builder.append(_join_2);
        _builder.newLineIfNotEmpty();
        _builder.append("#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        return _builder.toString();
    }

    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Declarations of types for events parameters.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.typeToC((Signal)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.signals, (Functions.Function1)_function));
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Declarations of types for events.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> this.eventsTypeToC((Class)it);
        String _join_1 = IterableExtensions.join((Iterable)IterableExtensions.map(this.activeObjectsMAINClassifier, (Functions.Function1)_function_1));
        _builder.append(_join_1);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifdef WITH_OBSERVERS");
        _builder.newLine();
        Functions.Function1 _function_2 = it -> this.eventsTypeToC((Class)it);
        String _join_2 = IterableExtensions.join((Iterable)IterableExtensions.map(this.activeObjectsOBSClassifier, (Functions.Function1)_function_2));
        _builder.append(_join_2);
        _builder.newLineIfNotEmpty();
        _builder.append("#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        return _builder.toString();
    }

    public String serialize() {
        return "";
    }
}

