/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.server.translator;

import emi.analysis.model.EMIConfiguration;
import emi.analysis.model.EMIFireableTransition;
import emi.analysis.model.EMIFireableTransitionComposite;
import emi.analysis.server.log.Log;
import emi.analysis.server.translator.EndiannessDetection;
import emi.analysis.server.translator.TransitionIdKind;
import emi.analysis.server.translator.TranslatorException;
import emi.serializer.symbols.SymbolMatcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class Translator {
    public static final String DEFAULT_DWARF_TOOL = "pahole";
    private boolean log;
    private MetaECTreeItem metaECTreeRoot;
    private IMetaECTreeGenerator metaECTreeGenerator;
    private ITranslationBuilder translationBuilder;
    private SymbolMatcher symbolMatcher;

    public boolean hasLog() {
        return this.log;
    }

    Translator(String searchDir, String emiModel, IMetaECTreeGenerator metaECTreeGenerator, ITranslationBuilder translationBuilder, boolean log) throws IOException {
        this.log = log;
        this.metaECTreeGenerator = metaECTreeGenerator;
        this.translationBuilder = translationBuilder;
        this.symbolMatcher = new SymbolMatcher(emiModel);
        this.metaECTreeRoot = new MetaECTreeItem("Store", "store", 1, 0, 0, null);
        this.metaECTreeGenerator.generateMetaECTree(this.metaECTreeRoot);
        this.metaECTreeGenerator.close();
        this.metaECTreeRoot.computeParent(null);
        MetaECTreeItem.endianness = EndiannessDetection.detectEndianness(searchDir);
        MetaECTreeItem.symbolMatcher = this.symbolMatcher;
    }

    public MetaECTreeItem getMetaECTreeRoot() {
        return this.metaECTreeRoot;
    }

    public SymbolMatcher getSymbolMatcher() {
        return this.symbolMatcher;
    }

    public String translate(EMIConfiguration configuration) throws TranslatorException {
        return this.translationBuilder.translate(configuration, this.metaECTreeRoot);
    }

    public String translate(EMIFireableTransitionComposite transition) throws TranslatorException {
        ArrayList<MetaEFT> listEFT = new ArrayList<MetaEFT>();
        for (EMIFireableTransition fireableTransition : transition.getTransitions()) {
            listEFT.add(this.translate(fireableTransition));
        }
        return this.translationBuilder.translate(listEFT);
    }

    private MetaEFT translate(EMIFireableTransition transition) throws TranslatorException {
        int transitionId = transition.getTransitionId();
        TransitionIdKind transitionIdKind = TransitionIdKind.getTransitionIdKindByValue(transitionId);
        if (transitionId == TransitionIdKind.NO_TRANSITION_ID.getValue() || transitionId == TransitionIdKind.INITIAL_TRANSITION_ID.getValue() || transitionId == TransitionIdKind.STUTTERING_TRANSITION_ID.getValue()) {
            return new MetaEFT(null, new ArrayList<String>(), new ArrayList<String>(), transitionIdKind);
        }
        String ao = this.symbolMatcher.searchActiveObject(transition.getActiveObjectId());
        int stateId = transition.getActiveObjectCS();
        ArrayList<String> verticesNames = new ArrayList<String>();
        ArrayList<String> transitionsNames = new ArrayList<String>();
        verticesNames.add(this.symbolMatcher.searchStateName(ao, stateId));
        if (transitionId >= 0) {
            int transitionContent = 0;
            int transitionContentLength = transition.getTransitionContent().length;
            for (int transitionIndex = 0; transitionIndex < transitionContentLength && transitionContent != TransitionIdKind.NO_TRANSITION_ID.getValue(); ++transitionIndex) {
                transitionContent = transition.getTransitionContent()[transitionIndex];
                if (transitionContent == TransitionIdKind.NO_TRANSITION_ID.getValue()) continue;
                SymbolMatcher.TransitionInfo trInfo = this.symbolMatcher.searchTransitionInfo(ao, stateId, transitionContent);
                verticesNames.add(trInfo.getTargetName());
                transitionsNames.add(trInfo.getName());
                stateId = trInfo.getTargetId();
            }
        }
        return new MetaEFT(ao, transitionsNames, verticesNames, transitionIdKind);
    }

    public void displayMetaECTree() {
        Log.d("Target endianness: " + MetaECTreeItem.endianness.getValue());
        if (this.metaECTreeRoot != null) {
            this.metaECTreeRoot.display(0, false, new boolean[0]);
        } else {
            Log.d("[MetaECTree] The meta EMI configuration tree is null (bug)");
        }
    }

    public static String createArrayItemName(String itemName, int index) {
        return itemName + "[" + index + "]";
    }

    public static boolean isPrimitiveType(String typeName) {
        return typeName != null && (typeName.startsWith("int") || typeName.startsWith("unsigned int") || typeName.startsWith("char") || typeName.startsWith("unsigned char") || typeName.startsWith("bool") || typeName.endsWith("_t"));
    }

    public static boolean isUnion(String typeName) {
        return typeName != null && typeName.startsWith("union");
    }

    public static boolean isUMLType(String typeName) {
        return typeName != null && typeName.startsWith("UML_");
    }

    public static boolean isUserType(String typeName) {
        return typeName != null && typeName.endsWith("_ut");
    }

    public static interface ITranslationBuilder {
        public String translate(EMIConfiguration var1, MetaECTreeItem var2);

        public String translate(List<MetaEFT> var1);
    }

    public static interface IMetaECTreeGenerator {
        public void generateMetaECTree(MetaECTreeItem var1) throws IOException;

        public void close() throws IOException;
    }

    public static class MetaEFT {
        private String activeObject;
        private List<String> transitions;
        private List<String> vertices;
        private String source;
        private String target;
        private TransitionIdKind transitionIdKind;

        public MetaEFT(String activeObject, List<String> transitions, List<String> vertices, TransitionIdKind transitionIdKind) {
            this.activeObject = activeObject;
            this.transitions = transitions;
            this.vertices = vertices;
            if (this.vertices.size() > 0) {
                this.source = this.vertices.get(0);
                this.target = this.vertices.get(this.vertices.size() - 1);
            } else {
                this.source = null;
                this.target = null;
            }
            this.transitionIdKind = transitionIdKind;
        }

        public String getActiveObject() {
            return this.activeObject;
        }

        public List<String> getTransitions() {
            return this.transitions;
        }

        public List<String> getVertices() {
            return this.vertices;
        }

        public String getSource() {
            return this.source;
        }

        public String getTarget() {
            return this.target;
        }

        public TransitionIdKind getTransitionIdKind() {
            return this.transitionIdKind;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.activeObject + ": " + this.source);
            for (int i = 0; i < this.transitions.size(); ++i) {
                String name = this.transitions.get(i);
                builder.append(" -");
                if (name != null) {
                    builder.append("[" + this.transitions.get(i) + "]");
                }
                builder.append("-> " + this.vertices.get(i + 1));
            }
            return builder.toString();
        }
    }

    public static class MetaECTreeItem {
        private String type;
        private String name;
        private int nbElements;
        private int offset;
        private int size;
        private final List<MetaECTreeItem> children = new ArrayList<MetaECTreeItem>();
        private MetaECTreeItem parent;
        private static EndiannessDetection.Endianness endianness;
        private static SymbolMatcher symbolMatcher;

        public MetaECTreeItem(String type, String name, int nbElements, int offset, int size, List<MetaECTreeItem> children) {
            this.type = type;
            this.name = name;
            this.nbElements = nbElements;
            this.offset = offset;
            this.size = size;
            if (children != null) {
                this.children.addAll(children);
            }
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public int getNbElements() {
            return this.nbElements;
        }

        public void setNbElements(int nbElements) {
            this.nbElements = nbElements;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public List<MetaECTreeItem> getChildren() {
            return this.children;
        }

        public boolean isLeaf() {
            return this.children == null || this.children.size() == 0;
        }

        public String toString() {
            return this.type + " " + this.name + " (nb: " + this.nbElements + ", offset: " + this.offset + " size: " + this.size + " children: " + this.children.size() + ")";
        }

        public void display(int level, Boolean last, boolean[] connectParent) {
            StringBuffer indent = new StringBuffer();
            if (level > 0) {
                for (int i = 0; i < level - 1; ++i) {
                    indent.append(connectParent[i] ? " \u2502 " : "   ");
                }
                indent.append(last != false ? " \u2514\u2500 " : " \u251c\u2500 ");
            }
            Log.d("[MetaECTree] " + indent.toString() + this.toString());
            boolean[] cParent = new boolean[level + 1];
            for (int i = 0; i < connectParent.length; ++i) {
                cParent[i] = connectParent[i];
            }
            cParent[cParent.length - 1] = true;
            if (last.booleanValue()) {
                cParent[level - 1] = false;
            }
            int index = 0;
            for (MetaECTreeItem child : this.children) {
                child.display(level + 1, ++index == this.children.size(), cParent);
            }
        }

        public void computeParent(MetaECTreeItem parent) {
            this.parent = parent;
            for (MetaECTreeItem child : this.children) {
                child.computeParent(this);
            }
        }

        public String computeValue(EMIConfiguration configuration) {
            String value = null;
            switch (this.size) {
                case 0: {
                    value = "";
                    break;
                }
                case 1: {
                    value = Integer.toString(configuration.getData().get(this.offset));
                    break;
                }
                case 4: {
                    int intValue = configuration.getData().getInt(this.offset);
                    if (endianness == EndiannessDetection.Endianness.LITTLE_ENDIAN) {
                        intValue = Integer.reverseBytes(intValue);
                    }
                    value = Integer.toString(intValue);
                    break;
                }
                default: {
                    value = "***error***";
                }
            }
            if ("cs".equals(this.name) && this.parent != null && this.parent.getType().endsWith("_store")) {
                value = MetaECTreeItem.resolveCSName(this.parent.getName(), Integer.parseInt(value));
            }
            if ("signalEventId".equals(this.name) && this.parent != null && this.parent.getName().startsWith("eventOccurred")) {
                value = MetaECTreeItem.resolveSEName(Integer.parseInt(value));
            }
            if ("portId".equals(this.name) && this.parent != null && this.parent.getName().startsWith("eventOccurred")) {
                value = MetaECTreeItem.resolvePortName(Integer.parseInt(value));
            }
            if (Translator.isUserType(this.type) && this.parent != null && Integer.parseInt(value) != -1) {
                value = MetaECTreeItem.resolveEnumerationLiteralName(this.type, Integer.parseInt(value));
            }
            return value;
        }

        private static String resolveCSName(String activeObject, int intValue) {
            return symbolMatcher.searchStateName(activeObject, intValue);
        }

        private static String resolveSEName(int intValue) {
            if (intValue == -1) {
                return "(empty)";
            }
            return symbolMatcher.searchSignalEventName(intValue);
        }

        private static String resolvePortName(int intValue) {
            if (intValue == -1) {
                return "(no port)";
            }
            return symbolMatcher.searchPortName(intValue);
        }

        private static String resolveEnumerationLiteralName(String enumName, int intValue) {
            String symbol = null;
            try {
                symbol = symbolMatcher.searchEnumerationLiteralName(enumName, intValue);
            }
            catch (IndexOutOfBoundsException e) {
                symbol = Integer.toString(intValue);
            }
            return symbol;
        }
    }
}

