/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.server.com;

import emi.analysis.com.IConnection;
import emi.analysis.com.TCPConnection;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class TCPServer {
    private int port;
    private ServerSocket serverSocket;
    private IConnection clientConnection;

    public IConnection getClientConnection() {
        return this.clientConnection;
    }

    public TCPServer(int port) {
        this.port = port;
    }

    public void open() throws IOException {
        try {
            this.serverSocket = new ServerSocket(this.port);
        }
        catch (IOException e) {
            throw new IOException("TCP server exception: can't open the server @any:" + this.port + " " + e.getMessage());
        }
    }

    protected void accept() throws IOException {
        if (this.serverSocket == null) {
            throw new IOException("TCP server exception: try to accept a connection before openning the server");
        }
        Socket clientSocket = this.serverSocket.accept();
        clientSocket.setTcpNoDelay(true);
        this.clientConnection = new TCPConnection(clientSocket);
    }

    public void close() throws IOException {
        this.closeClient();
        this.closeServer();
    }

    private void closeClient() throws IOException {
        try {
            if (this.clientConnection != null) {
                this.clientConnection.close();
                this.clientConnection = null;
            }
        }
        catch (IOException e) {
            throw new IOException("Can't close the TCP client connection (" + e.getMessage() + ")");
        }
    }

    private void closeServer() throws IOException {
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            throw new IOException("Can't close the TCP server connection (" + e.getMessage() + ")");
        }
    }
}

