/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.server;

import emi.analysis.com.IConnection;
import emi.analysis.model.EMIFireableTransitionComposite;
import emi.analysis.protocol.EMIProtocol;
import emi.analysis.protocol.EMIProtocolFireableTransitionComposite;
import emi.analysis.protocol.EMIProtocolTranslation;
import emi.analysis.server.EMIServer;
import emi.analysis.server.log.Log;
import emi.analysis.server.translator.Translator;
import emi.analysis.server.translator.TranslatorException;
import java.io.IOException;
import java.util.ArrayList;

public class ServiceTranslateFireableTransition
extends EMIServer.AService {
    private Translator translator;

    public ServiceTranslateFireableTransition(Translator translator, boolean log) {
        super(log);
        this.translator = translator;
        if (this.translator != null) {
            Log.i("Service: translation of fireable transitions");
        }
    }

    @Override
    public void execute(EMIProtocol.Header header, IConnection connection) throws IOException {
        ArrayList<EMIFireableTransitionComposite> compositeFireableTransitions = new ArrayList<EMIFireableTransitionComposite>();
        EMIProtocolFireableTransitionComposite.deserialize(compositeFireableTransitions, connection.read(header.size));
        EMIFireableTransitionComposite transition = compositeFireableTransitions.get(0);
        try {
            if (this.translator == null) {
                throw new TranslatorException("not available");
            }
            if (this.log || this.translator.hasLog()) {
                Log.d("Service: translate fireable transition (" + transition.toString() + ")");
            }
            String translation = this.translator.translate(transition);
            EMIProtocol.writeHeader(connection, new EMIProtocol.Header(102, translation.length()));
            connection.write(EMIProtocolTranslation.serialize(translation));
        }
        catch (TranslatorException e) {
            Log.e("Translation service: " + e.getMessage());
            EMIProtocol.writeHeader(connection, new EMIProtocol.Header(1));
        }
    }
}

