/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.metamodel;

import com.google.common.base.Objects;
import emi.serializer.metamodel.Metaclass;
import emi.serializer.model.ResourceManager;
import emi.serializer.serialization.propertyserializer.DefaultPropertySerializer;
import emi.serializer.serialization.propertyserializer.FunctionPropertySerializer;
import emi.serializer.serialization.propertyserializer.IndexPropertySerializer;
import emi.serializer.serialization.propertyserializer.InlinePropertySerializer;
import emi.serializer.serialization.propertyserializer.KindPropertySerializer;
import emi.serializer.serialization.propertyserializer.OnlyInlinePropertySerializer;
import emi.serializer.serialization.propertyserializer.PropertySerializer;
import emi.serializer.serialization.uml.UmlSubset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class MetamodelTable {
    private final UmlSubset umlSubset;
    private final Map<EClassifier, Metaclass> metaclasses;
    private final Map<EClassifier, Set<Pair<EClass, EClass>>> multipleInheritances;

    public MetamodelTable(ResourceManager rm) {
        UmlSubset _umlSubset;
        this.umlSubset = _umlSubset = new UmlSubset(rm);
        HashMap<EClassifier, Metaclass> _hashMap = new HashMap<EClassifier, Metaclass>();
        this.metaclasses = _hashMap;
        HashMap<EClassifier, Set<Pair<EClass, EClass>>> _hashMap_1 = new HashMap<EClassifier, Set<Pair<EClass, EClass>>>();
        this.multipleInheritances = _hashMap_1;
    }

    public void generate() {
        this.generateMetaclasses(this.umlSubset.getPropertiesByClass().entrySet());
        Consumer<Map.Entry> _function = it -> {
            StringConcatenation _builder = new StringConcatenation();
            String _name = ((EClassifier)it.getKey()).getName();
            _builder.append(_name);
            InputOutput.println((Object)_builder.toString());
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("    ");
            _builder_1.append("attributes -> [");
            Functions.Function1 _function_1 = it_1 -> (String)it_1.getKey();
            String _join = IterableExtensions.join((Iterable)IterableExtensions.map(((Metaclass)it.getValue()).getAttributes().entrySet(), (Functions.Function1)_function_1), (CharSequence)", ");
            _builder_1.append(_join, "    ");
            _builder_1.append("]");
            InputOutput.println((Object)_builder_1.toString());
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("    ");
            _builder_2.append("superclasses -> [");
            Functions.Function1 _function_2 = it_1 -> it_1.getName();
            String _join_1 = IterableExtensions.join((Iterable)IterableExtensions.map(((Metaclass)it.getValue()).getSuperclasses(), (Functions.Function1)_function_2), (CharSequence)", ");
            _builder_2.append(_join_1, "    ");
            _builder_2.append("]");
            InputOutput.println((Object)_builder_2.toString());
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("    ");
            _builder_3.append("properties -> ");
            List<PropertySerializer> _properties = ((Metaclass)it.getValue()).getProperties();
            _builder_3.append(_properties, "    ");
            InputOutput.println((Object)_builder_3.toString());
        };
        this.metaclasses.entrySet().forEach(_function);
        InputOutput.println((Object)"\n");
        this.checkTypes();
        InputOutput.println((Object)"\n");
        this.checkMultipleInheritances();
        this.displayMultipleInheritances(this.multipleInheritances);
        this.sortSuperclasses();
        this.computeAllAttributesSerializer();
    }

    public void generateMetaclasses(Set<Map.Entry<EClass, List<? extends PropertySerializer>>> properties) {
        Consumer<Map.Entry> _function = it -> {
            EClass eClass = (EClass)it.getKey();
            if (it.getValue() == null || ((List)it.getValue()).isEmpty()) {
                Metaclass _metaclass = new Metaclass();
                this.metaclasses.put((EClassifier)eClass, _metaclass);
            } else {
                Consumer<PropertySerializer> _function_1 = it_1 -> {
                    if (it_1 instanceof DefaultPropertySerializer) {
                        this.computeAttributeSymbol(eClass, ((DefaultPropertySerializer)it_1).getPropertyName(), (PropertySerializer)it_1);
                    } else if (it_1 instanceof InlinePropertySerializer) {
                        this.computeAttributeSymbol(eClass, ((InlinePropertySerializer)it_1).getPropertyName(), (PropertySerializer)it_1);
                    } else {
                        Metaclass thisMetaclass = this.metaclasses.get(eClass);
                        if (thisMetaclass == null) {
                            Metaclass _metaclass_1;
                            thisMetaclass = _metaclass_1 = new Metaclass();
                        }
                        if (it_1 instanceof OnlyInlinePropertySerializer) {
                            thisMetaclass.setOnlyInline(true);
                        } else {
                            thisMetaclass.getProperties().add((PropertySerializer)it_1);
                        }
                        this.metaclasses.put((EClassifier)eClass, thisMetaclass);
                    }
                };
                ((List)it.getValue()).forEach(_function_1);
            }
        };
        properties.forEach(_function);
    }

    public void computeAttributeSymbol(EClass eClass, String attributeName, PropertySerializer serializer) {
        EStructuralFeature feature = eClass.getEStructuralFeature(attributeName);
        if (feature != null) {
            boolean _notEquals;
            Metaclass thisMetaclass;
            Metaclass typeMetaclass;
            EClass container = feature.getEContainingClass();
            EClassifier featureType = null;
            featureType = serializer instanceof DefaultPropertySerializer ? ((DefaultPropertySerializer)serializer).getType(feature) : feature.getEType();
            Metaclass attributeMetaclass = this.metaclasses.get(container);
            if (attributeMetaclass == null) {
                Metaclass _metaclass;
                attributeMetaclass = _metaclass = new Metaclass();
            }
            if ((typeMetaclass = this.metaclasses.get(featureType)) == null) {
                Metaclass _metaclass_1;
                typeMetaclass = _metaclass_1 = new Metaclass();
                this.metaclasses.put(featureType, typeMetaclass);
            }
            if ((thisMetaclass = this.metaclasses.get(eClass)) == null) {
                Metaclass _metaclass_2;
                thisMetaclass = _metaclass_2 = new Metaclass();
            }
            attributeMetaclass.getAttributes().put(attributeName, serializer);
            boolean bl = _notEquals = !Objects.equal((Object)attributeMetaclass, (Object)thisMetaclass);
            if (_notEquals) {
                thisMetaclass.getSuperclasses().add(container);
                this.metaclasses.put((EClassifier)eClass, thisMetaclass);
                this.metaclasses.put((EClassifier)container, attributeMetaclass);
            } else {
                this.metaclasses.put((EClassifier)container, attributeMetaclass);
            }
        } else {
            InputOutput.println((Object)(attributeName + " -> not found"));
        }
    }

    public void checkTypes() {
        HashMap<EClass, List<? extends PropertySerializer>> properties = new HashMap<EClass, List<? extends PropertySerializer>>();
        properties.putAll(this.umlSubset.getPropertiesByClass());
        HashMap<EClassifier, Set<Pair<String, EClass>>> unfoundTypes = new HashMap<EClassifier, Set<Pair<String, EClass>>>();
        Consumer<Map.Entry> _function = it -> {
            EClass eClass = (EClass)it.getKey();
            Consumer<PropertySerializer> _function_1 = it_1 -> {
                if (it_1 instanceof DefaultPropertySerializer) {
                    this.checkPropertyType(eClass, ((DefaultPropertySerializer)it_1).getPropertyName(), ((DefaultPropertySerializer)it_1).getSimplifiedPropertyType(), properties, unfoundTypes);
                } else if (it_1 instanceof InlinePropertySerializer) {
                    this.checkPropertyType(eClass, ((InlinePropertySerializer)it_1).getPropertyName(), null, properties, unfoundTypes);
                }
            };
            ((List)it.getValue()).forEach(_function_1);
        };
        properties.entrySet().forEach(_function);
        this.displayUnfoundTypes(unfoundTypes);
    }

    private void checkPropertyType(EClass eClass, String propertyName, EClassifier simplifiedPropertyType, Map<EClass, List<? extends PropertySerializer>> properties, Map<EClassifier, Set<Pair<String, EClass>>> unfoundTypes) {
        EClassifier type = null;
        type = simplifiedPropertyType != null ? simplifiedPropertyType : eClass.getEStructuralFeature(propertyName).getEType();
        if ((type instanceof EClass || type instanceof EEnum) && properties.get(type) == null) {
            Pair pair = new Pair((Object)propertyName, (Object)eClass);
            Set<Pair<String, EClass>> list = unfoundTypes.get(type);
            if (list == null) {
                HashSet<Pair<String, EClass>> _hashSet = new HashSet<Pair<String, EClass>>();
                list = _hashSet;
            }
            list.add((Pair<String, EClass>)pair);
            unfoundTypes.put(type, list);
        }
    }

    private void displayUnfoundTypes(Map<EClassifier, Set<Pair<String, EClass>>> unfoundTypes) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("List of unfound types (automatically added in the metamodel serialization):");
        _builder.newLine();
        Functions.Function1 _function = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("[");
            String _name = ((EClassifier)it.getKey()).getName();
            _builder_1.append(_name);
            _builder_1.append("]:");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            Functions.Function1 _function_1 = it_1 -> {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("attribute \"");
                String _key = (String)it_1.getKey();
                _builder_2.append(_key);
                _builder_2.append("\" of class \"");
                String _name_1 = ((EClass)it_1.getValue()).getName();
                _builder_2.append(_name_1);
                _builder_2.append("\"");
                return _builder_2.toString();
            };
            String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)((Iterable)it.getValue()), (Functions.Function1)_function_1), (CharSequence)"\n");
            _builder_1.append(_join, "\t");
            _builder_1.newLineIfNotEmpty();
            return _builder_1.toString();
        };
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map(unfoundTypes.entrySet(), (Functions.Function1)_function), (CharSequence)"");
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        String string = _builder.toString();
        InputOutput.println((Object)string);
    }

    public void checkMultipleInheritances() {
        boolean _equals;
        int _size = this.metaclasses.size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            this.generate();
        }
        Consumer<Map.Entry> _function = it -> {
            Map.Entry metaclass = it;
            Set<EClass> superclasses = ((Metaclass)it.getValue()).getSuperclasses();
            Consumer<EClass> _function_1 = it_1 -> {
                EClass superclass = it_1;
                Consumer<EClass> _function_2 = it_2 -> {
                    if (!(Objects.equal((Object)it_2, (Object)superclass) || it_2.getEAllSuperTypes().contains((Object)superclass) || superclass.getEAllSuperTypes().contains(it_2))) {
                        Set<Pair<EClass, EClass>> list = this.multipleInheritances.get(metaclass.getKey());
                        if (list == null) {
                            HashSet<Pair<EClass, EClass>> _hashSet = new HashSet<Pair<EClass, EClass>>();
                            list = _hashSet;
                        }
                        if (!list.contains(new Pair((Object)superclass, it_2)) && !list.contains(new Pair(it_2, (Object)superclass))) {
                            Pair _pair = new Pair((Object)superclass, it_2);
                            list.add((Pair<EClass, EClass>)_pair);
                            this.multipleInheritances.put((EClassifier)metaclass.getKey(), list);
                        }
                    }
                };
                superclasses.forEach(_function_2);
            };
            ((Metaclass)it.getValue()).getSuperclasses().forEach(_function_1);
        };
        this.metaclasses.entrySet().forEach(_function);
    }

    private void displayMultipleInheritances(Map<EClassifier, Set<Pair<EClass, EClass>>> inheritances) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("List of multiple inheritance conflicts:");
        _builder.newLine();
        Functions.Function1 _function = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("[");
            String _name = ((EClassifier)it.getKey()).getName();
            _builder_1.append(_name);
            _builder_1.append("]:");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            Functions.Function1 _function_1 = it_1 -> {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("inherits from both \"");
                String _name_1 = ((EClass)it_1.getKey()).getName();
                _builder_2.append(_name_1);
                _builder_2.append("\" and \"");
                String _name_2 = ((EClass)it_1.getValue()).getName();
                _builder_2.append(_name_2);
                _builder_2.append("\"");
                return _builder_2.toString();
            };
            String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)((Iterable)it.getValue()), (Functions.Function1)_function_1), (CharSequence)"\n");
            _builder_1.append(_join, "\t");
            _builder_1.newLineIfNotEmpty();
            return _builder_1.toString();
        };
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map(inheritances.entrySet(), (Functions.Function1)_function), (CharSequence)"\n");
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        String string = _builder.toString();
        InputOutput.println((Object)string);
    }

    public Map<EClassifier, Metaclass> getMetaclasses() {
        return this.metaclasses;
    }

    public void sortSuperclasses() {
        Functions.Function1 _function = it -> {
            EClassifier _key = (EClassifier)it.getKey();
            return _key instanceof EClass;
        };
        Iterable classes = IterableExtensions.filter(this.metaclasses.entrySet(), (Functions.Function1)_function);
        Consumer<Map.Entry> _function_1 = it -> {
            boolean _tripleEquals;
            Set<Pair<EClass, EClass>> _get = this.multipleInheritances.get(it.getKey());
            boolean bl = _tripleEquals = _get == null;
            if (_tripleEquals) {
                Metaclass _value = (Metaclass)it.getValue();
                _value.setHasMultipleInheritances(false);
                ((Metaclass)it.getValue()).sortSuperclasses();
            } else {
                Metaclass _value_1 = (Metaclass)it.getValue();
                _value_1.setHasMultipleInheritances(true);
            }
        };
        classes.forEach(_function_1);
    }

    public List<String> getAllAttributesNames(Metaclass metaclass) {
        ArrayList<String> _xblockexpression = null;
        ArrayList<String> list = new ArrayList<String>();
        Consumer<EClass> _function = it -> {
            Metaclass superMetaclass = this.metaclasses.get(it);
            list.addAll(this.getAttributesNames(superMetaclass));
        };
        metaclass.getSuperclasses().forEach(_function);
        list.addAll(this.getAttributesNames(metaclass));
        _xblockexpression = list;
        return _xblockexpression;
    }

    public List<String> getAttributesNames(Metaclass metaclass) {
        ArrayList<String> _xblockexpression = null;
        ArrayList<String> list = new ArrayList<String>();
        Consumer<PropertySerializer> _function = it -> {
            if (it instanceof KindPropertySerializer) {
                list.add("c_kind");
            } else if (it instanceof IndexPropertySerializer) {
                list.add("c_index");
            } else if (it instanceof FunctionPropertySerializer) {
                list.add("c_function");
            }
        };
        metaclass.getProperties().forEach(_function);
        Consumer<Map.Entry> _function_1 = it -> list.add((String)it.getKey());
        metaclass.getAttributes().entrySet().forEach(_function_1);
        _xblockexpression = list;
        return _xblockexpression;
    }

    public void computeAllAttributesSerializer() {
        Consumer<Map.Entry> _function = it -> ((Metaclass)it.getValue()).getAllAttributes().addAll(this.getAllAttributesSerializer((Metaclass)it.getValue()));
        this.metaclasses.entrySet().forEach(_function);
    }

    public List<PropertySerializer> getAllAttributesSerializer(Metaclass metaclass) {
        ArrayList<PropertySerializer> _xblockexpression = null;
        ArrayList<PropertySerializer> list = new ArrayList<PropertySerializer>();
        Consumer<EClass> _function = it -> {
            Metaclass superMetaclass = this.metaclasses.get(it);
            list.addAll(this.getAttributesSerializer(superMetaclass));
        };
        metaclass.getSuperclasses().forEach(_function);
        list.addAll(this.getAttributesSerializer(metaclass));
        _xblockexpression = list;
        return _xblockexpression;
    }

    private List<PropertySerializer> getAttributesSerializer(Metaclass metaclass) {
        ArrayList<PropertySerializer> _xblockexpression = null;
        ArrayList<PropertySerializer> list = new ArrayList<PropertySerializer>();
        Consumer<PropertySerializer> _function = it -> list.add((PropertySerializer)it);
        metaclass.getProperties().forEach(_function);
        Consumer<Map.Entry> _function_1 = it -> list.add((PropertySerializer)it.getValue());
        metaclass.getAttributes().entrySet().forEach(_function_1);
        _xblockexpression = list;
        return _xblockexpression;
    }
}

