/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.memoryobjects;

import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlNavigation;
import emi.serializer.utils.UmlSerializerExtensions;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class SignalEvents {
    private final List<SignalEvent> signalEvents;
    private final Map<Signal, SignalEvent> mappingWithSignals;

    public SignalEvents(ResourceManager rm) {
        this.signalEvents = UmlNavigation.getSignalEvents(rm);
        LinkedHashMap<Signal, SignalEvent> _linkedHashMap = new LinkedHashMap<Signal, SignalEvent>();
        this.mappingWithSignals = _linkedHashMap;
        Consumer<SignalEvent> _function = it -> this.mappingWithSignals.put(it.getSignal(), (SignalEvent)it);
        this.signalEvents.forEach(_function);
    }

    private String fieldTypeToC(SignalEvent e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("UML_SignalEvent * ");
        String _name = e.getSignal().getName();
        _builder.append(_name);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String fieldToC(SignalEvent e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".");
        String _name = e.getSignal().getName();
        _builder.append(_name);
        _builder.append(" = &");
        String _variableName = UmlSerializerExtensions.variableName((EObject)e);
        _builder.append(_variableName);
        return _builder.toString();
    }

    public String serializeHeadersTypedef() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Typedef for signal events.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("typedef struct SignalEvents SignalEvents;");
        _builder.newLine();
        return _builder.toString();
    }

    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The SignalEvents type used to gather all signal events.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("struct SignalEvents {");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function = it -> this.fieldTypeToC((SignalEvent)it.getValue());
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map(this.mappingWithSignals.entrySet(), (Functions.Function1)_function));
        _builder.append(_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _builder.append("extern SignalEvents globalSignalEvents;");
        _builder.newLine();
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Struct initializer for signal events.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("SignalEvents globalSignalEvents = {");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function = it -> this.fieldToC((SignalEvent)it.getValue());
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map(this.mappingWithSignals.entrySet(), (Functions.Function1)_function), (CharSequence)",\n");
        _builder.append(_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        return _builder.toString();
    }
}

