/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer;

import emi.serializer.EMISerializerOptions;
import emi.serializer.identifiers.IdentifiersSerializer;
import emi.serializer.metamodel.MetamodelSerializer;
import emi.serializer.metamodel.MetamodelTable;
import emi.serializer.metamodel.OffsetsTableStrategy;
import emi.serializer.model.ModelLoader;
import emi.serializer.model.ModelSerializer;
import emi.serializer.model.ResourceManager;
import emi.serializer.types.Types;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ParserProperties;

public class Main {
    private static EMISerializerOptions options;
    private static final int HELP_WIDTH = 150;

    private static final boolean manageOptions(String ... args) throws CmdLineException, IOException {
        ParserProperties _withOptionSorter = ParserProperties.defaults().withOptionSorter((Comparator)options);
        CmdLineParser parser = new CmdLineParser((Object)options, _withOptionSorter);
        try {
            parser.parseArgument(args);
            if (Main.options.help) {
                Main.printHelp(parser);
            }
            if (Main.options.version) {
                Main.printVersion();
            }
            if (Main.options.help || Main.options.version) {
                return false;
            }
        }
        catch (Throwable _t) {
            if (_t instanceof CmdLineException) {
                CmdLineException e = (CmdLineException)_t;
                Main.printHelp(parser);
                throw e;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return true;
    }

    private static final void printHelp(CmdLineParser parser) {
        System.out.println("Usage:");
        parser.getProperties().withUsageWidth(150);
        parser.printUsage((OutputStream)System.out);
    }

    private static final void printVersion() {
        System.out.println("Version 0.0.5 (under developement) !");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            boolean _not_3;
            boolean _not_2;
            boolean _not;
            block29: {
                EMISerializerOptions _eMISerializerOptions;
                options = _eMISerializerOptions = new EMISerializerOptions();
                boolean exit = false;
                try {
                    boolean _not2;
                    boolean _manageOptions = Main.manageOptions(args);
                    exit = _not2 = !_manageOptions;
                }
                catch (Throwable _t) {
                    if (_t instanceof CmdLineException) {
                        CmdLineException e = (CmdLineException)_t;
                        System.err.println(e.getMessage());
                        exit = true;
                        break block29;
                    }
                    if (_t instanceof IOException) {
                        IOException e_1 = (IOException)_t;
                        System.err.println(e_1.getMessage());
                        exit = true;
                        break block29;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                finally {
                    if (exit) {
                        System.exit(0);
                    }
                }
            }
            ArrayList<String> models = new ArrayList<String>();
            boolean _isEmpty = Main.options.models.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                Main.checkModelFiles(Main.options.models);
                models.addAll(Main.options.models);
            } else if (Main.options.sourceDirectory != null) {
                Main.checkSourceDirectory(Main.options.sourceDirectory);
                models.addAll(Main.getFilesInDirectory(Main.options.sourceDirectory, ".uml"));
            } else {
                System.err.println("error: No model given at input.");
                System.exit(1);
            }
            String modelName = null;
            if (Main.options.modelName != null) {
                modelName = Main.options.modelName;
            } else {
                boolean _not_1;
                boolean _isEmpty_1 = Main.options.models.isEmpty();
                boolean bl2 = _not_1 = !_isEmpty_1;
                if (_not_1) {
                    modelName = Main.computeModelName(((String)IterableExtensions.last(Main.options.models)).replaceAll(".*/", ""));
                } else if (Main.options.sourceDirectory != null) {
                    modelName = Main.options.sourceDirectory.replaceAll(".*/", "");
                } else {
                    System.err.println("error: No model given at input.");
                    System.exit(1);
                }
            }
            File emiModelDir = null;
            if (Main.options.outputDirectory != null) {
                File _file;
                String inOutputDir = Main.options.outputDirectory;
                File inOutputDirFile = new File(inOutputDir);
                if (!inOutputDirFile.exists() || !inOutputDirFile.isDirectory()) {
                    System.err.println("error: " + inOutputDir + " is not a directory");
                    System.exit(1);
                }
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(inOutputDir);
                _builder.append("/");
                _builder.append(modelName);
                _builder.append(".emi");
                emiModelDir = _file = new File(_builder.toString());
            } else {
                File _file_1;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append(modelName);
                _builder_1.append(".emi");
                emiModelDir = _file_1 = new File(_builder_1.toString());
            }
            emiModelDir.mkdir();
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append((Object)emiModelDir);
            _builder_2.append("/");
            _builder_2.append("atoms/");
            File emiModelAtomsDir = new File(_builder_2.toString());
            emiModelAtomsDir.mkdir();
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append((Object)emiModelDir);
            _builder_3.append("/src");
            File emiModelSrcDir = new File(_builder_3.toString());
            emiModelSrcDir.mkdir();
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append((Object)emiModelDir);
            _builder_4.append("/uml");
            File emiModelUmlDir = new File(_builder_4.toString());
            emiModelUmlDir.mkdir();
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append((Object)emiModelDir);
            _builder_5.append("/obp2-config");
            File emiModelConfigDir = new File(_builder_5.toString());
            emiModelConfigDir.mkdir();
            StringConcatenation _builder_6 = new StringConcatenation();
            _builder_6.append((Object)emiModelDir);
            _builder_6.append("/src-models");
            File emiModelSrcModelsDir = new File(_builder_6.toString());
            StringConcatenation _builder_7 = new StringConcatenation();
            _builder_7.append((Object)emiModelDir);
            _builder_7.append("/fp_scheduling.config");
            String configSchedulingFP = _builder_7.toString();
            File fileSchedulingFP = new File(configSchedulingFP);
            if (Main.options.priorityFile != null && !fileSchedulingFP.exists()) {
                Files.copy(Paths.get(Main.options.priorityFile, new String[0]), Paths.get(configSchedulingFP, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            StringConcatenation _builder_8 = new StringConcatenation();
            _builder_8.append((Object)emiModelSrcDir);
            _builder_8.append("/model.c");
            String outFileModelC = _builder_8.toString();
            StringConcatenation _builder_9 = new StringConcatenation();
            _builder_9.append((Object)emiModelSrcDir);
            _builder_9.append("/model.h");
            String outFileModelH = _builder_9.toString();
            StringConcatenation _builder_10 = new StringConcatenation();
            _builder_10.append((Object)emiModelSrcDir);
            _builder_10.append("/types_calibration.h");
            String outFileTypes = _builder_10.toString();
            StringConcatenation _builder_11 = new StringConcatenation();
            _builder_11.append((Object)emiModelSrcDir);
            _builder_11.append("/metamodel.h");
            String outFileMetamodelH = _builder_11.toString();
            StringConcatenation _builder_12 = new StringConcatenation();
            _builder_12.append((Object)emiModelSrcDir);
            _builder_12.append("/metamodel.c");
            String outFileMetamodelC = _builder_12.toString();
            StringConcatenation _builder_13 = new StringConcatenation();
            _builder_13.append((Object)emiModelSrcDir);
            _builder_13.append("/identifiers.h");
            String outFileIdentifiers = _builder_13.toString();
            ModelLoader modelLoader = new ModelLoader();
            Functions.Function1 _function = it -> modelLoader.load((String)it);
            List modelResources = ListExtensions.map(models, (Functions.Function1)_function);
            ResourceManager rm = new ResourceManager(modelResources);
            MetamodelTable metamodelTable = new MetamodelTable(rm);
            metamodelTable.generate();
            OffsetsTableStrategy strategy = new OffsetsTableStrategy(metamodelTable);
            ModelSerializer modelSerializer = new ModelSerializer(rm, metamodelTable, strategy, configSchedulingFP);
            MetamodelSerializer metamodelSerializer = new MetamodelSerializer(metamodelTable, strategy);
            Types typesSerializer = new Types(rm);
            IdentifiersSerializer identifiersSerializer = new IdentifiersSerializer(rm);
            String sMetamodelC = metamodelSerializer.serialize();
            String sMetamodelH = metamodelSerializer.serializeHeaders();
            String sModelC = modelSerializer.serialize();
            String sModelH = modelSerializer.serializeHeaders();
            String sTypes = typesSerializer.serialize();
            String sIdentifiers = identifiersSerializer.serialize();
            Main.writeInFile(outFileMetamodelH, sMetamodelH);
            Main.writeInFile(outFileMetamodelC, sMetamodelC);
            Main.writeInFile(outFileModelC, sModelC);
            Main.writeInFile(outFileModelH, sModelH);
            Main.writeInFile(outFileTypes, sTypes);
            Main.writeInFile(outFileIdentifiers, sIdentifiers);
            InputStream makefileEmi = Main.class.getResourceAsStream("/makefiles/Makefile");
            StringConcatenation _builder_14 = new StringConcatenation();
            String _canonicalPath = emiModelDir.getCanonicalPath();
            _builder_14.append(_canonicalPath);
            _builder_14.append("/Makefile");
            File emiModelDirMakefile = new File(_builder_14.toString());
            Files.copy(makefileEmi, emiModelDirMakefile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            InputStream makefileConfig = Main.class.getResourceAsStream("/makefiles/Makefile.config");
            StringConcatenation _builder_15 = new StringConcatenation();
            String _canonicalPath_1 = emiModelDir.getCanonicalPath();
            _builder_15.append(_canonicalPath_1);
            _builder_15.append("/Makefile.config");
            File emiModelDirMakefileConfig = new File(_builder_15.toString());
            boolean _exists = emiModelDirMakefileConfig.exists();
            boolean bl3 = _not_2 = !_exists;
            if (_not_2) {
                Files.copy(makefileConfig, emiModelDirMakefileConfig.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            InputStream makefileSrc = Main.class.getResourceAsStream("/makefiles/src/Makefile");
            StringConcatenation _builder_16 = new StringConcatenation();
            String _canonicalPath_2 = emiModelSrcDir.getCanonicalPath();
            _builder_16.append(_canonicalPath_2);
            _builder_16.append("/Makefile");
            File emiModelSrcDirMakefile = new File(_builder_16.toString());
            Files.copy(makefileSrc, emiModelSrcDirMakefile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            InputStream makefileAtoms = Main.class.getResourceAsStream("/makefiles/atoms/Makefile");
            StringConcatenation _builder_17 = new StringConcatenation();
            String _canonicalPath_3 = emiModelAtomsDir.getCanonicalPath();
            _builder_17.append(_canonicalPath_3);
            _builder_17.append("/Makefile");
            File emiModelAtomsDirMakefile = new File(_builder_17.toString());
            Files.copy(makefileAtoms, emiModelAtomsDirMakefile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            for (String modelFile : models) {
                File umlModelFile = new File(modelFile);
                StringConcatenation _builder_18 = new StringConcatenation();
                String _canonicalPath_4 = emiModelUmlDir.getCanonicalPath();
                _builder_18.append(_canonicalPath_4);
                _builder_18.append("/");
                String _computeModelName = Main.computeModelName(modelFile);
                _builder_18.append(_computeModelName);
                _builder_18.append(".uml");
                File emiModelUmlDirModel = new File(_builder_18.toString());
                Files.move(umlModelFile.toPath(), emiModelUmlDirModel.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            if (Main.options.sourceDirectory != null) {
                File sourceDirectoryFile = new File(Main.options.sourceDirectory);
                Main.deleteDirectory(emiModelSrcModelsDir);
                Files.move(sourceDirectoryFile.toPath(), emiModelSrcModelsDir.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            InputStream plugConfig = Main.class.getResourceAsStream("/config/config.emi");
            StringConcatenation _builder_18 = new StringConcatenation();
            String _canonicalPath_4 = emiModelConfigDir.getCanonicalPath();
            _builder_18.append(_canonicalPath_4);
            _builder_18.append("/config.emi");
            File emiModelConfigDirPlug = new File(_builder_18.toString());
            boolean _exists_1 = emiModelConfigDirPlug.exists();
            boolean bl4 = _not_3 = !_exists_1;
            if (_not_3) {
                Files.copy(plugConfig, emiModelConfigDirPlug.toPath(), StandardCopyOption.REPLACE_EXISTING);
                String emiHome = System.getenv("EMI_HOME");
                if (emiHome != null) {
                    Main.updateProperty(emiModelConfigDirPlug, "emiHome", emiHome);
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static void writeInFile(String filename, String s) {
        try {
            FileOutputStream _fileOutputStream = new FileOutputStream(filename);
            PrintStream file = new PrintStream(_fileOutputStream);
            file.print(s);
            file.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static void updateProperty(File file, String key, String value) {
        try {
            byte[] _readAllBytes = Files.readAllBytes(Paths.get(file.getCanonicalPath(), new String[0]));
            String content = new String(_readAllBytes);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(key);
            _builder.append("=");
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(key);
            _builder_1.append("=");
            _builder_1.append(value);
            String newContent = content.replaceFirst(_builder.toString(), _builder_1.toString());
            FileWriter output = new FileWriter(file);
            output.write(newContent);
            output.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static void checkModelFiles(List<String> modelFiles) {
        for (String inFile : modelFiles) {
            String model;
            String modelExtension;
            boolean _equals;
            boolean _not;
            File umlModelFile = new File(inFile);
            if (!umlModelFile.exists() || !umlModelFile.isFile()) {
                System.err.println("error: " + inFile + " is not a file");
                System.exit(1);
            }
            if (!(_not = !(_equals = (modelExtension = (model = inFile.replaceAll(".*/", "")).replaceAll(".*\\.", "")).equals("uml")))) continue;
            System.err.println("error: The input file \"" + inFile + "\" is not a UML model. Extension is ." + modelExtension + " but expected .uml");
            System.exit(1);
        }
    }

    private static void checkSourceDirectory(String sourceDirectory) {
        List<String> umlModelFiles;
        boolean _isEmpty;
        File sourceDirectoryFile = new File(sourceDirectory);
        if (!sourceDirectoryFile.exists() || !sourceDirectoryFile.isDirectory()) {
            System.err.println("error: " + sourceDirectoryFile + " is not a directory");
            System.exit(1);
        }
        if (_isEmpty = (umlModelFiles = Main.getFilesInDirectory(sourceDirectory, ".uml")).isEmpty()) {
            System.err.println("error: The input source directory \"" + sourceDirectoryFile + "\" does not contains any .uml files.");
            System.exit(1);
        }
    }

    private static List<String> getFilesInDirectory(String directory, final String fileExtension) {
        List _xblockexpression = null;
        File directoryFile = new File(directory);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(fileExtension);
            }
        };
        Functions.Function1 _function = it -> {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(directory);
            _builder.append("/");
            _builder.append(it);
            return _builder.toString();
        };
        _xblockexpression = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)directoryFile.list(filter))), (Functions.Function1)_function);
        return _xblockexpression;
    }

    private static String computeModelName(String modelFile) {
        return modelFile.replaceAll(".*/", "").replaceAll("\\..*", "");
    }

    public static void deleteDirectory(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File f : files) {
                boolean _isDirectory = f.isDirectory();
                if (_isDirectory) {
                    Main.deleteDirectory(f);
                    continue;
                }
                f.delete();
            }
        }
        directory.delete();
    }
}

