/*
 * Decompiled with CFR 0.152.
 */
package plug.language.emi.visualization;

import emi.analysis.client.EMISynchronousClient;
import emi.analysis.exception.EMIException;
import emi.analysis.model.EMIFireableTransition;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import plug.core.IFiredTransition;
import plug.language.emi.model.PlugRuntimeConfiguration;
import plug.statespace.IGraphAccess;

public final class StateSpace2Json {
    private StateSpace2Json() {
    }

    public static void toJson(IGraphAccess<PlugRuntimeConfiguration, EMIFireableTransition> graphView, EMISynchronousClient client, String dirname) throws IOException, EMIException {
        HashMap<PlugRuntimeConfiguration, Integer> idMap = new HashMap<PlugRuntimeConfiguration, Integer>();
        File directory = new File(dirname);
        boolean directoryCreated = directory.mkdir();
        if (!directoryCreated) {
            System.err.println("Directory \"" + dirname + "\" can not be created");
        }
        graphView.getVertices().parallelStream().forEach(vertex -> {
            try {
                StateSpace2Json.writeNode(vertex, dirname, idMap, client);
            }
            catch (EMIException | IOException e) {
                e.printStackTrace();
            }
        });
        OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(dirname + "/transitions.graph"), StandardCharsets.UTF_8);
        try (BufferedWriter transitionWriter = new BufferedWriter(streamWriter);){
            for (PlugRuntimeConfiguration vertex2 : graphView.getInitialVertices()) {
                transitionWriter.write("0 " + StateSpace2Json.getID(vertex2, idMap) + "\n");
            }
            for (PlugRuntimeConfiguration source : graphView.getVertices()) {
                int sourceId = StateSpace2Json.getID(source, idMap);
                for (IFiredTransition transition : graphView.getOutgoingEdges((Object)source)) {
                    for (PlugRuntimeConfiguration target : transition.getTargets()) {
                        transitionWriter.write(sourceId + " " + StateSpace2Json.getID(target, idMap) + "\n");
                    }
                }
            }
        }
    }

    private static int getID(PlugRuntimeConfiguration vertex, Map<PlugRuntimeConfiguration, Integer> idMap) {
        Integer id = idMap.get((Object)vertex);
        if (id == null) {
            id = idMap.size() + 1;
            idMap.put(vertex, id);
        }
        return id;
    }

    private static void writeNode(PlugRuntimeConfiguration node, String dirname, Map<PlugRuntimeConfiguration, Integer> idMap, EMISynchronousClient client) throws IOException, EMIException {
        int id = StateSpace2Json.getID(node, idMap);
        OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(dirname + "/node_" + id + ".json"), StandardCharsets.UTF_8);
        try (BufferedWriter vertexWriter = new BufferedWriter(streamWriter);){
            String content = client.getTranslation(node.getEMIConfiguration());
            vertexWriter.write(content);
        }
    }
}

