/*
 * Decompiled with CFR 0.152.
 */
package plug.language.emi.runtime;

import emi.analysis.client.EMISynchronousClient;
import emi.analysis.exception.EMIException;
import emi.analysis.exception.EMIRuntimeException;
import emi.analysis.model.EMIConfiguration;
import emi.analysis.model.EMIFireableTransitionComposite;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import plug.core.IAtomicPropositionsEvaluator;
import plug.core.IFiredTransition;
import plug.core.ITransitionRelation;
import plug.language.emi.analysis.EMIAtomicPropositionEvaluator;
import plug.language.emi.model.PlugRuntimeConfiguration;
import plug.language.emi.observers.EMIObserver;
import plug.statespace.transitions.FiredTransition;

public class EMIRuntime
implements ITransitionRelation<PlugRuntimeConfiguration, EMIFireableTransitionComposite> {
    private EMISynchronousClient client;
    private EMIAtomicPropositionEvaluator propositionEvaluator;
    private List<EMIObserver> observers;
    private EMIConfiguration configurationOnInterpreter;
    private Collection<EMIFireableTransitionComposite> ftsOnInterpreter;

    public EMIRuntime(EMISynchronousClient client, boolean checkSideEffect) {
        this.client = client;
        try {
            this.client.startDiffMode();
        }
        catch (EMIException e) {
            e.printStackTrace();
            throw new EMIRuntimeException(e.getMessage());
        }
        this.propositionEvaluator = new EMIAtomicPropositionEvaluator(this.client, checkSideEffect);
        this.observers = new ArrayList<EMIObserver>();
        this.configurationOnInterpreter = null;
        this.ftsOnInterpreter = null;
    }

    public void close() {
        if (this.client != null) {
            try {
                this.client.close();
                this.client = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void addEMIObserver(EMIObserver observer) {
        this.observers.add(observer);
    }

    public boolean initializeRuntime() {
        return true;
    }

    public synchronized Set<PlugRuntimeConfiguration> initialConfigurations() {
        EMIConfiguration initialConfiguration = null;
        try {
            initialConfiguration = this.client.reset();
        }
        catch (EMIException e) {
            e.printStackTrace();
            throw new EMIRuntimeException(e.getMessage());
        }
        for (EMIObserver observer : this.observers) {
            observer.configurationChanged(initialConfiguration);
        }
        this.configurationOnInterpreter = initialConfiguration;
        this.ftsOnInterpreter = null;
        return Collections.singleton(new PlugRuntimeConfiguration(initialConfiguration));
    }

    public synchronized Collection<EMIFireableTransitionComposite> fireableTransitionsFrom(PlugRuntimeConfiguration configuration) {
        ArrayList fts = null;
        boolean configurationHasChanged = false;
        if (!this.configurationOnInterpreter.equals((Object)configuration.getEMIConfiguration())) {
            configurationHasChanged = true;
            this.configurationOnInterpreter = configuration.getEMIConfiguration();
        } else if (this.ftsOnInterpreter != null) {
            return this.ftsOnInterpreter;
        }
        try {
            fts = this.client.getFireableTransitions(configuration.getEMIConfiguration());
        }
        catch (EMIException e) {
            e.printStackTrace();
            throw new EMIRuntimeException(e.getMessage());
        }
        this.ftsOnInterpreter = fts;
        for (EMIObserver observer : this.observers) {
            if (!configurationHasChanged) continue;
            observer.configurationChanged(configuration.getEMIConfiguration());
        }
        return fts;
    }

    public synchronized IFiredTransition<PlugRuntimeConfiguration, EMIFireableTransitionComposite> fireOneTransition(PlugRuntimeConfiguration source, EMIFireableTransitionComposite transition) {
        EMIConfiguration target = null;
        try {
            target = this.client.fireTransition(transition, source.getEMIConfiguration());
        }
        catch (EMIException e) {
            e.printStackTrace();
            throw new EMIRuntimeException(e.getMessage());
        }
        boolean configurationHasChanged = false;
        if (!this.configurationOnInterpreter.equals((Object)source.getEMIConfiguration())) {
            configurationHasChanged = true;
        }
        this.configurationOnInterpreter = target;
        this.ftsOnInterpreter = null;
        for (EMIObserver observer : this.observers) {
            if (configurationHasChanged) {
                observer.configurationChanged(source.getEMIConfiguration());
            }
            observer.configurationChanged(target);
        }
        return new FiredTransition((Object)source, (Object)new PlugRuntimeConfiguration(target), (Object)transition);
    }

    public synchronized String getTranslation(EMIConfiguration configuration) {
        String s;
        try {
            s = this.client.getTranslation(configuration);
        }
        catch (EMIException e) {
            String s2 = "*** translation error ***";
            throw new EMIRuntimeException(e.getMessage());
        }
        return s;
    }

    public synchronized String getTranslation(EMIFireableTransitionComposite transition) {
        String s;
        try {
            s = this.client.getTranslation(transition);
        }
        catch (EMIException e) {
            String s2 = "*** translation error ***";
            throw new EMIRuntimeException(e.getMessage());
        }
        return s;
    }

    public EMISynchronousClient getClient() {
        return this.client;
    }

    public IAtomicPropositionsEvaluator<PlugRuntimeConfiguration, EMIFireableTransitionComposite> getAtomicPropositionEvaluator() {
        return this.propositionEvaluator;
    }
}

