/*
 * Decompiled with CFR 0.152.
 */
package plug.language.emi;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.OptionHandler;

public class EMIRuntimeOptions
implements Comparator<OptionHandler> {
    public static final int DEFAULT_EMI_ANALYSIS_PORT = 12346;
    public static final int DEFAULT_INTERPRETER_PORT = 12345;
    public static final String DEFAULT_IP_ADDRESS = "127.0.0.1";
    @Option(name="-h", aliases={"--help"}, help=true, usage="Print help")
    public boolean help;
    @Option(name="-v", aliases={"--version"}, help=true, usage="Print version")
    public boolean version;
    @Option(name="-a", aliases={"--address"}, metaVar="IP", usage="Address used for connection (address of emi-analysis in remote mode or of the interpreter in standalone mode)")
    public String address = "127.0.0.1";
    @Option(name="-p", aliases={"--port"}, metaVar="PORT", usage="Port (port of emi-analysis in remote mode or of the interpreter in standalone mode)")
    public int port;
    @Option(name="-u", aliases={"--emi-uml-model"}, metaVar="MODEL_DIR_PATH", usage="Path to the interpreted EMI UML model (necessary for atom evaluations or for translation)")
    public String emiModel;
    @Option(name="-e", aliases={"--emi-home"}, metaVar="DIR_PATH", usage="EMI home directory (useful for atom evaluations) (default: use $EMI_HOME)")
    public String emiHome = System.getenv("EMI_HOME");
    @Option(name="-t", aliases={"--interpreter-target"}, metaVar="TARGET", usage="Interpreter target (useful for atom evaluations)")
    public String target = "host";
    @Option(name="-c", aliases={"--atoms-compiler"}, metaVar="COMPILER", usage="Atoms C compiler (useful for atom evaluations) (default: gcc on host)")
    public String compiler;
    @Option(name="-m", aliases={"--make-tool"}, metaVar="MAKE_TOOL", usage="The software make to use (useful for atom evaluations)")
    public String makeTool = "make";
    @Option(name="-d", aliases={"--dwarf-tool"}, metaVar="DWARF_TOOL", usage="Tool to read dwarf information (\"pahole\", \"objdump\", \"dwarfdump\") (useful for translation)")
    public String dwarfTool = "pahole";
    @Option(name="-s", aliases={"--standalone-mode"}, usage="Mode used to connect to the model interpreter (Use -s for \"standalone\" mode)")
    public boolean standaloneMode;
    @Option(name="-x", aliases={"--export"}, usage="Export state-space graph into a text file (used with -E)")
    public boolean exportGraph;
    @Option(name="-f", aliases={"--check-side-effect"}, usage="Check if atomic propositions are side effect free")
    public boolean checkAtomSideEffect;
    @Option(name="-D", aliases={"--deadlock"}, usage="Launch deadlocks detection")
    public boolean deadlock;
    @Option(name="-E", aliases={"--exploration"}, usage="Launch state-space exploration")
    public boolean exploration;
    @Option(name="-P", aliases={"--property"}, metaVar="PROPERTY", usage="Launch verification of a property given as a string")
    public String propertyToVerify;
    @Option(name="-V", aliases={"--verification-file"}, metaVar="VERIFICATION_FILE", usage="Launch verification of properties given into a file")
    public String fileToVerify;
    private final List<String> order = Arrays.asList("-h", "-v", "-a", "-p", "-u", "-e", "-t", "-c", "-m", "-d", "-s", "-x", "-f", "-D", "-E", "-P", "-V");

    @Override
    public int compare(OptionHandler o1, OptionHandler o2) {
        return Integer.compare(this.order.indexOf(o1.getNameAndMeta(null).split(" ")[0]), this.order.indexOf(o2.getNameAndMeta(null).split(" ")[0]));
    }
}

