/*
 * Decompiled with CFR 0.152.
 */
package plug.core.fx.verification;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.stage.FileChooser;
import plug.core.ILanguagePlugin;
import plug.core.RuntimeDescription;
import plug.core.execution.ControllerProviderFunction;
import plug.core.execution.ExecutionException;
import plug.core.execution.ExecutionOLD;
import plug.core.fx.IAppContext;
import plug.core.fx.langage.ModelView;
import plug.core.fx.verification.ErrorsView;
import plug.core.fx.verification.ExecutionListView;
import plug.core.registry.LanguageModuleRegistry;
import plug.core.ui.common.GPSL2Execution;
import plug.core.verification.VerificationModel;

@Deprecated
public class VerificationView
extends SplitPane {
    protected final IAppContext appContext;
    protected final SimpleObjectProperty<VerificationModel> model;
    protected final ModelView modelView;
    protected final StringProperty verificationContent;
    protected final SplitPane bottomPane;
    protected final ModelView propertiesView;
    protected final SplitPane bottomLeftPane;
    protected final ExecutionListView executionListView;
    protected final ErrorsView errorsView;
    protected final ObservableList<ExecutionOLD> modelExecutions = FXCollections.observableArrayList();
    protected final ObservableList<ExecutionOLD> executions = FXCollections.observableArrayList();
    protected final ObservableList<Throwable> modelErrors = FXCollections.observableArrayList();
    protected final ObservableList<Throwable> errors = FXCollections.observableArrayList();

    public VerificationView(IAppContext appContext, StringProperty content, ObservableObjectValue<Path> basePath) throws IOException {
        this.appContext = appContext;
        this.verificationContent = content;
        this.model = new SimpleObjectProperty();
        if (this.verificationContent.get() != null) {
            this.model.set(this.createMapper().readValue((String)this.verificationContent.get(), VerificationModel.class));
        } else {
            this.model.set((Object)new VerificationModel());
        }
        this.modelView = new ModelView(appContext, basePath, ((VerificationModel)this.model.get()).getModel(), true);
        this.modelView.labelProperty().set((Object)"Model");
        for (ILanguagePlugin languageModule : LanguageModuleRegistry.getInstance().getModules()) {
            if (languageModule.getName().equals("Buchi")) continue;
            List extensions = Stream.of(languageModule.getExtensions()).map(e -> "*" + e).collect(Collectors.toList());
            this.modelView.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(languageModule.getName(), extensions));
        }
        this.propertiesView = new ModelView(appContext, basePath, ((VerificationModel)this.model.get()).getProperties(), true);
        this.propertiesView.labelProperty().set((Object)"Properties");
        this.propertiesView.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("GPSL", new String[]{"*.gpsl"}));
        this.executionListView = new ExecutionListView(appContext, this.executions);
        this.executionListView.setOnExecutionError(execution -> execution.getErrors().forEach(error -> this.addError((Throwable)error, true)));
        this.errorsView = new ErrorsView(appContext, this.errors);
        this.bottomLeftPane = new SplitPane(new Node[]{this.executionListView});
        this.bottomLeftPane.setOrientation(Orientation.VERTICAL);
        this.bottomLeftPane.setDividerPosition(0, 0.7);
        this.errors.addListener(c -> {
            ObservableList items = this.bottomLeftPane.getItems();
            if (this.errors.isEmpty()) {
                items.remove((Object)this.errorsView);
            } else if (!items.contains((Object)this.errorsView)) {
                items.add((Object)this.errorsView);
            }
        });
        this.bottomPane = new SplitPane(new Node[]{this.bottomLeftPane, this.propertiesView});
        this.bottomPane.setDividerPosition(0, 0.4);
        this.modelView.relativePathProperty().addListener((observable, oldValue, newValue) -> ((VerificationModel)this.model.get()).setModel(newValue));
        this.propertiesView.relativePathProperty().addListener((observable, oldValue, newValue) -> ((VerificationModel)this.model.get()).setProperties(newValue));
        this.modelView.modelContentProperty().addListener(this::modelContentUpdated);
        this.propertiesView.modelContentProperty().addListener(this::propertiesContentUpdate);
        this.setOrientation(Orientation.VERTICAL);
        this.getItems().add((Object)this.modelView);
        this.getItems().add((Object)this.bottomPane);
    }

    public ObjectMapper createMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        return mapper;
    }

    protected void updateExecutions(boolean model) {
        ILanguagePlugin module;
        for (ExecutionOLD execution : this.executions) {
            if (!model && this.modelExecutions.contains((Object)execution)) continue;
            execution.cancel();
        }
        this.executions.clear();
        Path modelPath = this.modelView.getModelPath();
        if (modelPath != null && (module = LanguageModuleRegistry.getInstance().getModuleByExtension(modelPath)) != null) {
            if (model) {
                this.modelExecutions.clear();
                for (Map.Entry executionModule : module.executions().entrySet()) {
                    RuntimeDescription description = new RuntimeDescription(modelPath);
                    this.modelExecutions.add((Object)new ExecutionOLD((String)executionModule.getKey(), description, (ControllerProviderFunction)executionModule.getValue()));
                }
            }
            this.executions.addAll(this.modelExecutions);
            Path propertyPath = this.propertiesView.getModelPath();
            if (propertyPath != null) {
                try {
                    RuntimeDescription modelDescription = new RuntimeDescription(modelPath);
                    this.executions.addAll(new GPSL2Execution().executions(propertyPath, modelDescription));
                }
                catch (Throwable e) {
                    this.addError(e, false);
                }
            }
        }
    }

    public void addError(Throwable e, boolean model) {
        Throwable root = e;
        while (root.getCause() != null) {
            if (root instanceof ExecutionException) {
                model = ((ExecutionException)root).isModel();
            }
            root = root.getCause();
        }
        for (Throwable error : this.errors) {
            if (error.getClass() != root.getClass() || !Objects.equals(error.getMessage(), root.getMessage())) continue;
            return;
        }
        if (model) {
            this.modelErrors.add((Object)root);
        }
        this.errors.add((Object)root);
    }

    protected void clearErrors(boolean model) {
        this.errors.clear();
        if (model) {
            this.modelErrors.clear();
        } else {
            this.errors.addAll(this.modelErrors);
        }
    }

    private void modelContentUpdated(ObservableValue<? extends String> observable, String oldValue, String newValue) {
        Platform.runLater(() -> {
            this.clearErrors(true);
            this.updateExecutions(true);
        });
    }

    private void propertiesContentUpdate(ObservableValue<? extends String> observable, String oldValue, String newValue) {
        Platform.runLater(() -> {
            this.clearErrors(false);
            this.updateExecutions(false);
        });
    }
}

