/*
 * Decompiled with CFR 0.152.
 */
package plug.core.fx;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextBoundsType;
import plug.core.IConfiguration;
import plug.core.IFiredTransition;
import plug.core.ITransitionRelation;
import plug.core.execution.IExecutionViewContext;
import plug.core.fx.event.ConfigurationActionEvent;

@Deprecated
public class FiredTransitionListView
extends ListView<IFiredTransition<IConfiguration, Object>> {
    protected final SimpleBooleanProperty hideSourceConfigurations = new SimpleBooleanProperty(false);
    protected final SimpleBooleanProperty hideTargetConfigurations = new SimpleBooleanProperty(false);
    protected final SimpleBooleanProperty showActionDescription = new SimpleBooleanProperty(false);
    protected final IExecutionViewContext context;
    protected IConfiguration configuration = null;
    protected EventHandler<ConfigurationActionEvent> configurationActionHandler = null;
    protected Function<IConfiguration, Color> configurationColorSupplier;
    protected final Map<IFiredTransition<IConfiguration, Object>, Object> fireables = new HashMap<IFiredTransition<IConfiguration, Object>, Object>();

    public FiredTransitionListView(IExecutionViewContext context) {
        this.context = context;
        this.setCellFactory(list -> new FireableTransitionListCell());
    }

    public SimpleBooleanProperty hideSourceConfigurationsProperty() {
        return this.hideSourceConfigurations;
    }

    public boolean isHideSourceConfigurations() {
        return this.hideSourceConfigurations.get();
    }

    public void setHideSourceConfigurations(boolean hideConfigurations) {
        this.hideSourceConfigurations.set(hideConfigurations);
        this.refresh();
    }

    public SimpleBooleanProperty hideTargetConfigurationsProperty() {
        return this.hideTargetConfigurations;
    }

    public boolean isHideTargetConfigurations() {
        return this.hideTargetConfigurations.get();
    }

    public void setHideTargetConfigurations(boolean hideConfigurations) {
        this.hideTargetConfigurations.set(hideConfigurations);
        this.refresh();
    }

    public Function<IConfiguration, Color> getConfigurationColorSupplier() {
        return this.configurationColorSupplier;
    }

    public void setConfigurationColorSupplier(Function<IConfiguration, Color> configurationColorSupplier) {
        this.configurationColorSupplier = configurationColorSupplier;
    }

    public SimpleBooleanProperty showActionDescriptionProperty() {
        return this.showActionDescription;
    }

    public boolean getShowActionDescription() {
        return this.showActionDescription.get();
    }

    public void setConfigurationActionHandler(EventHandler<ConfigurationActionEvent> configurationActionHandler) {
        this.configurationActionHandler = configurationActionHandler;
    }

    public IConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(IConfiguration configuration) {
        this.getItems().clear();
        this.fireables.clear();
        this.configuration = configuration;
        if (configuration != null) {
            ITransitionRelation transitionRelation = this.context.getRuntime();
            Collection fireableTransitionsFrom = transitionRelation.fireableTransitionsFrom((Object)configuration);
            for (Object fireableTransition : fireableTransitionsFrom) {
                IFiredTransition firedTransition = transitionRelation.fireOneTransition((Object)configuration, fireableTransition);
                if (firedTransition == null) continue;
                this.fireables.put((IFiredTransition<IConfiguration, Object>)firedTransition, fireableTransition);
                this.getItems().add((Object)firedTransition);
            }
        }
    }

    public EventHandler<ConfigurationActionEvent> onConfigurationAction() {
        return this.configurationActionHandler;
    }

    public void setOnConfigurationAction(EventHandler<ConfigurationActionEvent> configurationActionHandler) {
        this.configurationActionHandler = configurationActionHandler;
    }

    protected boolean isSelectedConfiguration(IConfiguration configuration) {
        return this.configuration != null && this.configuration.equals((Object)configuration);
    }

    private double getArrowWidth() {
        double width = this.getWidth();
        width -= 60.0;
        width -= this.hideSourceConfigurations.get() ? 0.0 : 60.0;
        return width -= this.hideTargetConfigurations.get() ? 0.0 : 60.0;
    }

    protected class FireableTransitionListCell
    extends ListCell<IFiredTransition<IConfiguration, Object>> {
        private final int arrowSize = 12;
        private final GridPane main;
        private final Label arrowText;

        public FireableTransitionListCell() {
            this.setText(null);
            double width = FiredTransitionListView.this.getArrowWidth();
            this.arrowText = new Label();
            this.arrowText.setAlignment(Pos.BOTTOM_CENTER);
            this.arrowText.setTextOverrun(OverrunStyle.ELLIPSIS);
            this.arrowText.setFont(Font.font((double)10.0));
            this.arrowText.setMaxWidth(width);
            this.main = new GridPane();
            this.main.setHgap(10.0);
            FiredTransitionListView.this.hideSourceConfigurations.addListener((observable, oldValue, newValue) -> this.updateGridConstraints());
            FiredTransitionListView.this.hideTargetConfigurations.addListener((observable, oldValue, newValue) -> this.updateGridConstraints());
            this.updateGridConstraints();
            this.main.add((Node)this.arrowText, 1, 0);
            FiredTransitionListView.this.widthProperty().addListener((observable, oldValue, newValue) -> {
                double newWidth = FiredTransitionListView.this.getArrowWidth();
                this.arrowText.setMaxWidth(newWidth - 40.0);
                this.updateGridConstraints();
            });
        }

        public void updateGridConstraints() {
            this.main.getColumnConstraints().clear();
            ColumnConstraints sourceConstraints = new ColumnConstraints(FiredTransitionListView.this.hideSourceConfigurations.get() ? 0.0 : 60.0);
            sourceConstraints.setHalignment(HPos.CENTER);
            this.main.getColumnConstraints().add((Object)sourceConstraints);
            ColumnConstraints actionContraints = new ColumnConstraints(FiredTransitionListView.this.getArrowWidth());
            actionContraints.setFillWidth(true);
            this.main.getColumnConstraints().add((Object)actionContraints);
            ColumnConstraints targetConstraints = new ColumnConstraints(FiredTransitionListView.this.hideTargetConfigurations.get() ? 0.0 : 60.0);
            targetConstraints.setHalignment(HPos.CENTER);
            this.main.getColumnConstraints().add((Object)targetConstraints);
        }

        protected void updateItem(IFiredTransition<IConfiguration, Object> item, boolean empty) {
            super.updateItem(item, empty);
            if (empty || item == null) {
                this.setGraphic(null);
            } else {
                this.setGraphic((Node)this.main);
                String actionText = FiredTransitionListView.this.showActionDescription.get() || FiredTransitionListView.this.fireables.isEmpty() ? FiredTransitionListView.this.context.getActionDescription(item.getAction()) : FiredTransitionListView.this.context.getFireableTransitionDescription(FiredTransitionListView.this.fireables.get(item));
                this.arrowText.maxWidth(100.0);
                this.arrowText.setText(actionText);
                this.arrowText.setTooltip(new Tooltip(actionText));
                this.main.getChildren().remove(1, this.main.getChildren().size());
                if (!FiredTransitionListView.this.hideSourceConfigurations.get()) {
                    IConfiguration source = (IConfiguration)item.getSource();
                    Node configurationNode = FiredTransitionListView.this.isSelectedConfiguration(source) ? this.createThisConfiguration() : this.createConfigurationNode(source);
                    configurationNode.setOnMouseClicked(event -> {
                        if (FiredTransitionListView.this.configurationActionHandler != null) {
                            FiredTransitionListView.this.configurationActionHandler.handle((Event)new ConfigurationActionEvent((Object)FiredTransitionListView.this, item, source));
                        }
                    });
                    this.main.add(configurationNode, 0, 0);
                }
                if (!FiredTransitionListView.this.hideTargetConfigurations.get()) {
                    int column = 2;
                    for (IConfiguration target : item.getTargets()) {
                        Node configurationNode = FiredTransitionListView.this.isSelectedConfiguration(target) ? this.createThisConfiguration() : this.createConfigurationNode(target);
                        configurationNode.setOnMouseClicked(event -> {
                            if (FiredTransitionListView.this.configurationActionHandler != null) {
                                FiredTransitionListView.this.configurationActionHandler.handle((Event)new ConfigurationActionEvent((Object)FiredTransitionListView.this, item, target));
                            }
                        });
                        this.main.add(configurationNode, column, 0);
                        ++column;
                    }
                }
            }
        }

        private Node createConfigurationNode(IConfiguration configuration) {
            Rectangle rectangle = new Rectangle(80.0, 20.0);
            rectangle.setArcWidth(5.0);
            rectangle.setArcHeight(5.0);
            rectangle.setStroke((Paint)Color.BLACK);
            rectangle.setFill((Paint)(FiredTransitionListView.this.configurationColorSupplier != null ? (Paint)FiredTransitionListView.this.configurationColorSupplier.apply(configuration) : Color.WHITE));
            String targetText = FiredTransitionListView.this.context.getConfigurationDescription((Object)configuration);
            Text text = new Text(targetText);
            text.setBoundsType(TextBoundsType.VISUAL);
            return new StackPane(new Node[]{rectangle, text});
        }

        private Node createThisConfiguration() {
            return new Circle(5.0);
        }
    }
}

