/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.protocol;

import emi.analysis.model.EMIAtom;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public final class EMIProtocolAtoms {
    public static final int SIZEOF_ATOMS_NUMBERS = 4;
    public static final int SIZEOF_ATOM_LENGTH = 4;
    public static final int SIZEOF_ATOM_BANK = 4;
    public static final int SIZEOF_ATOM_VALUATION = 4;

    private EMIProtocolAtoms() {
    }

    public static byte[] serialize(EMIAtom[] atoms, int size) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(size);
        byteBuffer.putInt(atoms.length);
        for (int i = 0; i < atoms.length; ++i) {
            EMIProtocolAtoms.serialize(byteBuffer, atoms[i]);
        }
        return byteBuffer.array();
    }

    private static void serialize(ByteBuffer byteBuffer, EMIAtom atom) {
        byteBuffer.put(atom.getId());
        byteBuffer.put(atom.getPriority());
        byteBuffer.putInt(atom.length());
        byteBuffer.put(atom.getStringCode().getBytes());
    }

    public static ArrayList<EMIAtom> deserialize(byte[] data) {
        ArrayList<EMIAtom> atoms = new ArrayList<EMIAtom>();
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        int nbAtoms = byteBuffer.getInt();
        for (int i = 0; i < nbAtoms; ++i) {
            EMIAtom atom = EMIProtocolAtoms.deserializeAtom(byteBuffer);
            atoms.add(atom);
        }
        return atoms;
    }

    private static EMIAtom deserializeAtom(ByteBuffer byteBuffer) {
        byte[] id = new byte[16];
        byteBuffer.get(id, 0, 16);
        byte priority = byteBuffer.get();
        int length = byteBuffer.getInt();
        byte[] stringCode = new byte[length];
        byteBuffer.get(stringCode, 0, length);
        return new EMIAtom(id, new String(stringCode), priority);
    }

    public static byte[] serializeLoad(int bank, EMIAtom atom) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(20);
        byteBuffer.putInt(bank);
        byteBuffer.put(atom.getId());
        return byteBuffer.array();
    }

    public static byte[] serializeLoad(int bank, byte[] binaryCode) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + binaryCode.length);
        byteBuffer.putInt(bank);
        byteBuffer.put(binaryCode);
        return byteBuffer.array();
    }

    public static byte[] serializeAtomsToEvaluate(ArrayList<? extends AtomBankable> atomsToEvaluate) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(atomsToEvaluate.size() * 4);
        for (AtomBankable atomBankable : atomsToEvaluate) {
            byteBuffer.putInt(atomBankable.getBank());
        }
        return byteBuffer.array();
    }

    public static int[] deserializeEvaluationResults(byte[] data) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        int nb = data.length / 4;
        int[] atomEvaluations = new int[nb];
        for (int i = 0; i < nb; ++i) {
            atomEvaluations[i] = byteBuffer.getInt();
        }
        return atomEvaluations;
    }

    public static interface AtomBankable {
        public int getBank();
    }
}

