/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.com;

import emi.analysis.com.IConnection;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

public class TCPConnection
implements IConnection {
    private Socket socket;
    private InputStream inputStream;
    private OutputStream outputStream;

    public TCPConnection(Socket socket) throws IOException {
        this.socket = socket;
        this.inputStream = socket.getInputStream();
        this.outputStream = socket.getOutputStream();
    }

    @Override
    public void write(byte[] data) throws IOException {
        try {
            this.outputStream.write(data);
        }
        catch (IOException e) {
            throw new IOException("TCP connection write exception: " + e.getMessage());
        }
    }

    @Override
    public byte[] read(int size) throws IOException {
        byte[] data = new byte[size];
        try {
            int sizeRead;
            for (int sizeReadSum = 0; sizeReadSum < size; sizeReadSum += sizeRead) {
                sizeRead = this.inputStream.read(data, sizeReadSum, size - sizeReadSum);
                if (sizeRead != -1) continue;
                throw new EOFException("TCP connection closed");
            }
            return data;
        }
        catch (EOFException e) {
            throw new EOFException("TCP connection closed");
        }
        catch (IOException e) {
            if (!(e instanceof SocketException) && !"Connection reset".equals(e.getMessage())) {
                throw new IOException("TCP connection read exception: " + e.getMessage());
            }
            throw new EOFException("TCP connection closed");
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException("TCP connection read exception (bug): " + e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            throw new IOException("TCP connection close exception: " + e.getMessage());
        }
    }
}

