/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.memoryobjects;

import emi.serializer.model.ClassifierInstance;
import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlNavigation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.LiteralSpecification;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class Store {
    private static final String BOOLEAN_NAME = "Boolean";
    private static final String INTEGER_NAME = "Integer";
    private final List<Class> classes;
    private final List<ClassifierInstance> objectsMAIN;
    private final List<ClassifierInstance> objectsOBS;

    public Store(ResourceManager rm) {
        this.classes = UmlNavigation.getClasses(rm);
        this.objectsMAIN = UmlNavigation.collectClassifierInstanceWithCompositeClass(rm, "Main");
        this.objectsOBS = UmlNavigation.collectClassifierInstanceWithCompositeClass(rm, "Obs");
    }

    private String typedefToC(Class e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("typedef struct ");
        String _name = e.getName();
        _builder.append(_name);
        _builder.append("_store ");
        String _name_1 = e.getName();
        _builder.append(_name_1);
        _builder.append("_store;");
        _builder.newLineIfNotEmpty();
        StringConcatenation _xifexpression = null;
        boolean _isActive = e.isActive();
        if (_isActive) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("typedef struct ");
            String _name_2 = e.getName();
            _builder_1.append(_name_2);
            _builder_1.append("_ep_params ");
            String _name_3 = e.getName();
            _builder_1.append(_name_3);
            _builder_1.append("_ep_params;");
            _xifexpression = _builder_1;
        }
        _builder.append(_xifexpression);
        _builder.newLineIfNotEmpty();
        _builder.append("typedef struct ");
        String _name_4 = e.getName();
        _builder.append(_name_4);
        _builder.append("_od  ");
        String _name_5 = e.getName();
        _builder.append(_name_5);
        _builder.append("_od;");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String typeToC(Class e) {
        boolean _notEquals;
        String _xblockexpression = null;
        List<Property> attributes = UmlNavigation.getAttributesNotPeers((Classifier)e);
        boolean hasParameters = UmlNavigation.hasEventsParameters(e);
        StringConcatenation _builder = new StringConcatenation();
        StringConcatenation _xifexpression = null;
        if (e.isActive() && hasParameters) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("/**");
            _builder_1.newLine();
            _builder_1.append(" ");
            _builder_1.append("* The event pool parameters type for the ");
            String _name = e.getName();
            _builder_1.append(_name, " ");
            _builder_1.append(" class.");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append(" ");
            _builder_1.append("*/");
            _builder_1.newLine();
            _builder_1.append("struct ");
            String _name_1 = e.getName();
            _builder_1.append(_name_1);
            _builder_1.append("_ep_params {");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            String _name_2 = e.getName();
            _builder_1.append(_name_2, "\t");
            _builder_1.append("_events eventOccurred[EVENT_POOL_SIZE];");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("};");
            _builder_1.newLine();
            _xifexpression = _builder_1;
        }
        _builder.append(_xifexpression);
        _builder.newLineIfNotEmpty();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The object data (e.g., attributes) type for the ");
        String _name_3 = e.getName();
        _builder.append(_name_3, " ");
        _builder.append(" class.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("struct ");
        String _name_4 = e.getName();
        _builder.append(_name_4);
        _builder.append("_od {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Functions.Function1 _function = it -> this.subfieldTypeToC((Property)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(attributes, (Functions.Function1)_function), (CharSequence)"\n");
        _builder.append(_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The store type for the ");
        String _name_5 = e.getName();
        _builder.append(_name_5, " ");
        _builder.append(" class. It contains:");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* \t\t - value of its current state");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* \t\t - content of its event pool");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* \t\t - values of its attributes");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("struct ");
        String _name_6 = e.getName();
        _builder.append(_name_6);
        _builder.append("_store {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        StringConcatenation _xifexpression_1 = null;
        boolean _isActive = e.isActive();
        if (_isActive) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("NbStates_t cs;");
            _builder_2.newLine();
            _builder_2.append("EventPoolStore ep;");
            _builder_2.newLine();
            StringConcatenation _xifexpression_2 = null;
            if (hasParameters) {
                StringConcatenation _builder_3 = new StringConcatenation();
                String _name_7 = e.getName();
                _builder_3.append(_name_7);
                _builder_3.append("_ep_params ep_params;");
                _builder_3.newLineIfNotEmpty();
                _xifexpression_2 = _builder_3;
            }
            _builder_2.append(_xifexpression_2);
            _builder_2.newLineIfNotEmpty();
            _xifexpression_1 = _builder_2;
        }
        _builder.append(_xifexpression_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        StringConcatenation _xifexpression_3 = null;
        int _length = ((Object[])Conversions.unwrapArray(attributes, Object.class)).length;
        boolean bl = _notEquals = _length != 0;
        if (_notEquals) {
            StringConcatenation _builder_4 = new StringConcatenation();
            String _name_8 = e.getName();
            _builder_4.append(_name_8);
            _builder_4.append("_od od;");
            _builder_4.newLineIfNotEmpty();
            _xifexpression_3 = _builder_4;
        }
        _builder.append(_xifexpression_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String subfieldTypeToC(Property e) {
        boolean _equals;
        String _xifexpression = null;
        int _lower = e.getLower();
        boolean bl = _equals = _lower == 1;
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            String _typeAsString = this.getTypeAsString(e);
            _builder.append(_typeAsString);
            _builder.append(" ");
            String _name = e.getName();
            _builder.append(_name);
            _builder.append(";");
            _xifexpression = _builder.toString();
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _typeAsString_1 = this.getTypeAsString(e);
            _builder_1.append(_typeAsString_1);
            _builder_1.append(" ");
            String _name_1 = e.getName();
            _builder_1.append(_name_1);
            _builder_1.append("[");
            int _lower_1 = e.getLower();
            _builder_1.append((Object)_lower_1);
            _builder_1.append("];");
            _xifexpression = _builder_1.toString();
        }
        return _xifexpression;
    }

    private String getTypeAsString(Property e) {
        String _xifexpression = null;
        boolean _equals = e.getType().getName().equals(BOOLEAN_NAME);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("int8_t");
            _xifexpression = _builder.toString();
        } else {
            String _xifexpression_1 = null;
            boolean _equals_1 = e.getType().getName().equals(INTEGER_NAME);
            if (_equals_1) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("int32_t");
                _xifexpression_1 = _builder_1.toString();
            } else {
                String _xifexpression_2 = null;
                Type _type = e.getType();
                if (_type instanceof Enumeration) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    String _name = e.getType().getName();
                    _builder_2.append(_name);
                    _builder_2.append("_ut");
                    _xifexpression_2 = _builder_2.toString();
                } else {
                    _xifexpression_2 = "";
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private String fieldTypeToC(ClassifierInstance e) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = e.getClassifier().getName();
        _builder.append(_name);
        _builder.append("_store ");
        String _instQualifiedName = e.getInstQualifiedName();
        _builder.append(_instQualifiedName);
        _builder.append(";");
        return _builder.toString();
    }

    private String fieldToC(ClassifierInstance e) {
        boolean _tripleNotEquals;
        String _xblockexpression = null;
        List<Property> attributes = UmlNavigation.getAttributesNotPeers(e.getClassifier());
        String _xifexpression = null;
        InstanceSpecification _instance = e.getInstance();
        boolean bl = _tripleNotEquals = _instance != null;
        if (_tripleNotEquals) {
            String _xblockexpression_1 = null;
            Map<Property, List<ValueSpecification>> mapping = this.computeDefaultValue(e.getInstance(), null);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Default value of the ");
            String _name = e.getInstance().getName();
            _builder.append(_name, " ");
            _builder.append(" object.");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            String _name_1 = e.getClassifier().getName();
            _builder.append(_name_1);
            _builder.append("_od ");
            String _name_2 = e.getInstance().getName();
            _builder.append(_name_2);
            _builder.append("_od_specification = {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            Functions.Function1 _function = it -> this.objectDatafieldToC((Property)it, mapping);
            String _join = IterableExtensions.join((Iterable)ListExtensions.map(attributes, (Functions.Function1)_function), (CharSequence)",\n");
            _builder.append(_join, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("};");
            _builder.newLine();
            _xifexpression = _xblockexpression_1 = _builder.toString();
        } else {
            _xifexpression = "";
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private Map<Property, List<ValueSpecification>> computeDefaultValue(InstanceSpecification e, Property p) {
        HashMap<Property, List<ValueSpecification>> _xblockexpression = null;
        HashMap<Property, List<ValueSpecification>> mapping = new HashMap<Property, List<ValueSpecification>>();
        EList _slots = e.getSlots();
        for (Slot slot : _slots) {
            ArrayList<ValueSpecification> listValues = new ArrayList<ValueSpecification>();
            StructuralFeature _definingFeature = slot.getDefiningFeature();
            Property definingFeature = (Property)_definingFeature;
            EList _values = slot.getValues();
            for (ValueSpecification slotValue : _values) {
                if (slotValue instanceof InstanceValue) {
                    InstanceSpecification instance = ((InstanceValue)slotValue).getInstance();
                    if (instance.getSlots() != null && ((Object[])Conversions.unwrapArray((Object)instance.getSlots(), Object.class)).length != 0) {
                        Map<Property, List<ValueSpecification>> instanceMapping = this.computeDefaultValue(instance, definingFeature);
                        mapping.putAll(instanceMapping);
                        continue;
                    }
                    listValues.add(slotValue);
                    continue;
                }
                listValues.add(slotValue);
            }
            int _length = ((Object[])Conversions.unwrapArray(listValues, Object.class)).length;
            boolean _notEquals = _length != 0;
            if (!_notEquals) continue;
            mapping.put(definingFeature, listValues);
        }
        _xblockexpression = mapping;
        return _xblockexpression;
    }

    private String objectDatafieldToC(Property e, Map<Property, List<ValueSpecification>> mapping) {
        String _xblockexpression = null;
        List<ValueSpecification> listValues = mapping.get(e);
        String _xifexpression = null;
        if (listValues != null) {
            String _xblockexpression_1 = null;
            ValueSpecification attributeValue = listValues.get(0);
            String _xifexpression_1 = null;
            if (attributeValue instanceof LiteralSpecification) {
                String _xblockexpression_2 = null;
                Object value = ((LiteralSpecification)attributeValue).eGet(((LiteralSpecification)attributeValue).eClass().getEStructuralFeature("value"));
                _xifexpression_1 = _xblockexpression_2 = this.defaultValueToC(e, value);
            } else {
                String _xifexpression_2 = null;
                if (attributeValue instanceof InstanceValue) {
                    String _xblockexpression_3 = null;
                    ValueSpecification _get = listValues.get(0);
                    InstanceValue instanceValue = (InstanceValue)_get;
                    InstanceSpecification instanceSpecification = instanceValue.getInstance();
                    ValueSpecification valueSpecification = instanceSpecification.getSpecification();
                    String _xifexpression_3 = null;
                    if (valueSpecification != null) {
                        String _xblockexpression_4 = null;
                        Object value = valueSpecification.eGet(valueSpecification.eClass().getEStructuralFeature("value"));
                        _xifexpression_3 = _xblockexpression_4 = this.defaultValueToC(e, value);
                    } else {
                        String _xifexpression_4 = null;
                        if (instanceSpecification instanceof EnumerationLiteral) {
                            _xifexpression_4 = this.defaultValueToC(e, ((EnumerationLiteral)instanceSpecification).getEnumeration().getOwnedLiterals().indexOf((Object)instanceSpecification));
                        }
                        _xifexpression_3 = _xifexpression_4;
                    }
                    _xifexpression_2 = _xblockexpression_3 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        } else {
            _xifexpression = this.defaultValueToC(e, 0);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private String defaultValueToC(Property e, Object value) {
        boolean _equals;
        String _xifexpression = null;
        int _lower = e.getLower();
        boolean bl = _equals = _lower == 1;
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(".");
            String _name = e.getName();
            _builder.append(_name);
            _builder.append(" = ");
            _builder.append(value);
            _xifexpression = _builder.toString();
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(".");
            String _name_1 = e.getName();
            _builder_1.append(_name_1);
            _builder_1.append(" = {");
            int _lower_1 = e.getLower();
            Functions.Function1 _function = it -> {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append(value);
                return _builder_2.toString();
            };
            String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)new ExclusiveRange(0, _lower_1, true), (Functions.Function1)_function), (CharSequence)", ");
            _builder_1.append(_join);
            _builder_1.append("}");
            _xifexpression = _builder_1.toString();
        }
        return _xifexpression;
    }

    public String serializeHeadersTypedef() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Typedef of store types.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.typedefToC((Class)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.classes, (Functions.Function1)_function));
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Typedef of the Store type.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("typedef struct Store Store;");
        _builder.newLine();
        return _builder.toString();
    }

    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Declaration of store types.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.typeToC((Class)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.classes, (Functions.Function1)_function));
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The Store type used to gather dynamic data of each active object.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("struct Store {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#ifdef WITH_SCHEDULING_STATE");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("uint32_t scheduling_state;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#endif /* WITH_SCHEDULING_STATE */");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function_1 = it -> this.fieldTypeToC((ClassifierInstance)it);
        String _join_1 = IterableExtensions.join((Iterable)ListExtensions.map(this.objectsMAIN, (Functions.Function1)_function_1), (CharSequence)"\n");
        _builder.append(_join_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#ifdef WITH_OBSERVERS");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function_2 = it -> this.fieldTypeToC((ClassifierInstance)it);
        String _join_2 = IterableExtensions.join((Iterable)ListExtensions.map(this.objectsOBS, (Functions.Function1)_function_2), (CharSequence)"\n");
        _builder.append(_join_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.append("extern Store store;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#ifdef ANALYSIS_WITH_DIFF");
        _builder.newLine();
        _builder.append("extern Store refStore;");
        _builder.newLine();
        _builder.append("#endif /* ANALYSIS_WITH_DIFF */");
        _builder.newLine();
        return _builder.toString();
    }

    public String serialize() {
        String _xblockexpression = null;
        ArrayList instanceSpecificationMAIN = new ArrayList();
        Functions.Function1 _function = it -> {
            boolean result;
            boolean _xblockexpression_1 = false;
            boolean _contains = instanceSpecificationMAIN.contains(it.getInstance());
            boolean bl = result = !_contains;
            if (result) {
                instanceSpecificationMAIN.add(it.getInstance());
            }
            _xblockexpression_1 = result;
            return _xblockexpression_1;
        };
        Iterable instancesMAIN = IterableExtensions.filter(this.objectsMAIN, (Functions.Function1)_function);
        ArrayList instanceSpecificationOBS = new ArrayList();
        Functions.Function1 _function_1 = it -> {
            boolean result;
            boolean _xblockexpression_1 = false;
            boolean _contains = instanceSpecificationOBS.contains(it.getInstance());
            boolean bl = result = !_contains;
            if (result) {
                instanceSpecificationOBS.add(it.getInstance());
            }
            _xblockexpression_1 = result;
            return _xblockexpression_1;
        };
        Iterable instancesOBS = IterableExtensions.filter(this.objectsOBS, (Functions.Function1)_function_1);
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function_2 = it -> this.fieldToC((ClassifierInstance)it);
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)instancesMAIN, (Functions.Function1)_function_2));
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifdef WITH_OBSERVERS");
        _builder.newLine();
        Functions.Function1 _function_3 = it -> this.fieldToC((ClassifierInstance)it);
        String _join_1 = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)instancesOBS, (Functions.Function1)_function_3));
        _builder.append(_join_1);
        _builder.newLineIfNotEmpty();
        _builder.append("#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The store variable used to save the dynamic part of the model.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("Store store;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#ifdef ANALYSIS_WITH_DIFF");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The reference store variable used in DIFF mode.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This store is data synchronized with a remote reference store ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* of the analysis tool, in order to re-construct the store using");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* a diff mechanism.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("Store refStore;");
        _builder.newLine();
        _builder.append("#endif /* ANALYSIS_WITH_DIFF */");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }
}

