/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.memoryobjects;

import emi.serializer.memoryobjects.Objects;
import emi.serializer.memoryobjects.Operations;
import emi.serializer.memoryobjects.PropertiesRO;
import emi.serializer.memoryobjects.Transitions;
import emi.serializer.model.ClassifierInstance;
import emi.serializer.model.PartClassifierInstance;
import emi.serializer.model.ResourceManager;
import emi.serializer.scheduling.SchedulingPolicyFP;
import emi.serializer.utils.UmlNavigation;
import emi.serializer.utils.UmlSerializerExtensions;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ActiveObjects
extends Objects {
    private final List<Class> activeClasses;
    private final List<ClassifierInstance> activeObjectsMAIN;
    private final List<ClassifierInstance> activeObjectsOBS;
    private final PropertiesRO peers;
    private final List<Property> partsInENV;

    public ActiveObjects(ResourceManager rm) {
        PropertiesRO _propertiesRO;
        this.activeClasses = UmlNavigation.getActiveClasses(rm);
        this.activeObjectsMAIN = UmlNavigation.getActiveObjectsListOfComposite(rm, "Main");
        this.activeObjectsOBS = UmlNavigation.getActiveObjectsListOfComposite(rm, "Obs");
        this.peers = _propertiesRO = new PropertiesRO(rm);
        Class compositeEnv = UmlNavigation.getCompositeClass(rm, "Env");
        if (compositeEnv != null) {
            this.partsInENV = UmlNavigation.getAllParts(compositeEnv);
        } else {
            ArrayList<Property> _arrayList = new ArrayList<Property>();
            this.partsInENV = _arrayList;
        }
    }

    public static String getActiveObjectName(ClassifierInstance activeObject) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("ao_");
        String _instQualifiedName = activeObject.getInstQualifiedName();
        _builder.append(_instQualifiedName);
        return _builder.toString();
    }

    private String specificActiveTypeToC(Classifier ActiveClass) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("SPECIFIC_STRUCT_ActiveObject(");
        String _name = ActiveClass.getName();
        _builder.append(_name);
        _builder.append(")");
        return _builder.toString();
    }

    private String activeObjectToC(ClassifierInstance activeObject, int nbPeers) {
        String _xblockexpression = null;
        Classifier classifier = activeObject.getClassifier();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Struct initializer for the ");
        String _name = activeObject.getName();
        _builder.append(_name, " ");
        _builder.append(" active object.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("static ");
        String _name_1 = classifier.getName();
        _builder.append(_name_1);
        _builder.append("_Object ");
        String _activeObjectName = ActiveObjects.getActiveObjectName(activeObject);
        _builder.append(_activeObjectName);
        _builder.append(" = {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _activeObjectCoreToC = this.activeObjectCoreToC(activeObject, nbPeers);
        _builder.append(_activeObjectCoreToC, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String activeObjectCoreToC(ClassifierInstance activeObject, int nbPeers) {
        boolean _notEquals_1;
        boolean _not;
        boolean _notEquals;
        String _xblockexpression = null;
        InstanceSpecification instance = activeObject.getInstance();
        Classifier _classifier = activeObject.getClassifier();
        Class class_ = (Class)_classifier;
        boolean hasParameters = UmlNavigation.hasEventsParameters(class_);
        StateMachine stateMachine = UmlNavigation.getStateMachine(class_);
        String instQualifiedName = activeObject.getInstQualifiedName();
        boolean inENV = false;
        if (activeObject instanceof PartClassifierInstance) {
            inENV = this.partsInENV.contains(((PartClassifierInstance)activeObject).getPart());
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".name = \"");
        _builder.append(instQualifiedName);
        _builder.append("\",");
        _builder.newLineIfNotEmpty();
        _builder.append(".classInfo = &");
        String _actualName = UmlSerializerExtensions.actualName((EObject)activeObject.getClassifier());
        _builder.append(_actualName);
        _builder.append("_classInfo,");
        _builder.newLineIfNotEmpty();
        if (activeObject instanceof PartClassifierInstance) {
            _builder.append(".part = (UML_Property *) &");
            String _variableName = UmlSerializerExtensions.variableName((EObject)((PartClassifierInstance)activeObject).getPart());
            _builder.append(_variableName);
            _builder.append(",");
            _builder.newLineIfNotEmpty();
        }
        _builder.append(".properties_ro = (void *) &(properties_ro.");
        String _instQualifiedName = activeObject.getInstQualifiedName();
        _builder.append(_instQualifiedName);
        _builder.append("),");
        _builder.newLineIfNotEmpty();
        _builder.append(".nb_properties_ro = ");
        _builder.append((Object)nbPeers);
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        if (instance != null) {
            _builder.append(".instance = &");
            String _name = activeObject.getInstance().getName();
            _builder.append(_name);
            _builder.append("_od_specification,");
            _builder.newLineIfNotEmpty();
            _builder.append(".instanceSize = sizeof(");
            String _name_1 = class_.getName();
            _builder.append(_name_1);
            _builder.append("_od),");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append(".instance = NULL,");
            _builder.newLine();
            _builder.append(".instanceSize = 0,");
            _builder.newLine();
        }
        _builder.append(".store = &(store.");
        _builder.append(instQualifiedName);
        _builder.append("),");
        _builder.newLineIfNotEmpty();
        int _length = ((Object[])Conversions.unwrapArray(Operations.getOperations(class_), Object.class)).length;
        boolean bl = _notEquals = _length != 0;
        if (_notEquals) {
            _builder.append(".operations = &");
            String _name_2 = class_.getName();
            _builder.append(_name_2);
            _builder.append("_operations_vtable,");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append(".operations = NULL,");
            _builder.newLine();
        }
        _builder.append(".multiplicity_id = ");
        int _multiplicityId = activeObject.getMultiplicityId();
        _builder.append((Object)_multiplicityId);
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append(".stateMachine = &");
        String _variableName_1 = UmlSerializerExtensions.variableName((EObject)stateMachine);
        _builder.append(_variableName_1);
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        if (hasParameters) {
            _builder.append(".eventParamsSize = sizeof(");
            String _name_3 = class_.getName();
            _builder.append(_name_3);
            _builder.append("_events),");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append(".eventParamsSize = 0,");
            _builder.newLine();
        }
        _builder.append(".eventPool = &eventPool_");
        _builder.append(instQualifiedName);
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = UmlNavigation.getAllReceptions(class_).isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            _builder.append(".reorganize_buffer = reorganize_buffer_");
            _builder.append(instQualifiedName);
            _builder.append(",");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append(".reorganize_buffer = NULL,");
            _builder.newLine();
        }
        _builder.append(".fireables = (NbOutgoings_t *) fireables_");
        _builder.append(instQualifiedName);
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append(".nbFireables = 0,");
        _builder.newLine();
        _builder.append(".fireablesMax = ");
        int _maxFireablesTransition = Transitions.getMaxFireablesTransition(stateMachine);
        _builder.append((Object)_maxFireablesTransition);
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append(".fireablesLength = ");
        int _maxTransitionLength = Transitions.getMaxTransitionLength(stateMachine);
        _builder.append((Object)_maxTransitionLength);
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append(".store_cs = &(store.");
        _builder.append(instQualifiedName);
        _builder.append(".cs),");
        _builder.newLineIfNotEmpty();
        if (hasParameters) {
            _builder.append(".store_ep_params = &(store.");
            _builder.append(instQualifiedName);
            _builder.append(".ep_params),");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append(".store_ep_params = NULL,");
            _builder.newLine();
        }
        int _length_1 = ((Object[])Conversions.unwrapArray(UmlNavigation.getAttributesNotPeers((Classifier)class_), Object.class)).length;
        boolean bl3 = _notEquals_1 = _length_1 != 0;
        if (_notEquals_1) {
            _builder.append(".properties_rw = &(store.");
            _builder.append(instQualifiedName);
            _builder.append(".od),");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append(".properties_rw = NULL,");
            _builder.newLine();
        }
        _builder.append(".in_environment = ");
        _builder.append((Object)inENV);
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("#ifdef SCHEDULING_POLICY_FP");
        _builder.newLine();
        _builder.append(".priority = ");
        String _fPMacroName = SchedulingPolicyFP.getFPMacroName(activeObject);
        _builder.append(_fPMacroName);
        _builder.newLineIfNotEmpty();
        _builder.append("#endif /* SCHEDULING_POLICY_FP */");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String fieldTypeToC(ClassifierInstance activeObject) {
        String _xblockexpression = null;
        Classifier classifier = activeObject.getClassifier();
        StringConcatenation _builder = new StringConcatenation();
        String _name = classifier.getName();
        _builder.append(_name);
        _builder.append("_Object * ");
        String _instQualifiedName = activeObject.getInstQualifiedName();
        _builder.append(_instQualifiedName);
        _builder.append(";");
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String fieldToC(ClassifierInstance e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".");
        String _instQualifiedName = e.getInstQualifiedName();
        _builder.append(_instQualifiedName);
        _builder.append(" = &");
        String _activeObjectName = ActiveObjects.getActiveObjectName(e);
        _builder.append(_activeObjectName);
        return _builder.toString();
    }

    public String serializeHeadersTypedef() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Typedef of active objects types.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.specificTypedefToC((Classifier)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.activeClasses, (Functions.Function1)_function), (CharSequence)"\n");
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _builder.append("typedef struct ActiveObjects ActiveObjects;");
        _builder.newLine();
        return _builder.toString();
    }

    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Specific types for active objects.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.specificActiveTypeToC((Classifier)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.activeClasses, (Functions.Function1)_function), (CharSequence)"\n");
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* The ActiveObjects type used to gather all active objects");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("struct ActiveObjects {");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function_1 = it -> this.fieldTypeToC((ClassifierInstance)it);
        String _join_1 = IterableExtensions.join((Iterable)ListExtensions.map(this.activeObjectsMAIN, (Functions.Function1)_function_1), (CharSequence)"\n");
        _builder.append(_join_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#ifdef WITH_OBSERVERS");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function_2 = it -> this.fieldTypeToC((ClassifierInstance)it);
        String _join_2 = IterableExtensions.join((Iterable)ListExtensions.map(this.activeObjectsOBS, (Functions.Function1)_function_2), (CharSequence)"\n");
        _builder.append(_join_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.append("extern ActiveObjects activeObjects;");
        _builder.newLine();
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> {
            String _xblockexpression = null;
            Classifier _classifier = it.getClassifier();
            int nbPeers = this.peers.getNbReadOnlyAttributes((Class)_classifier);
            _xblockexpression = this.activeObjectToC((ClassifierInstance)it, nbPeers);
            return _xblockexpression;
        };
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.activeObjectsMAIN, (Functions.Function1)_function));
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifdef WITH_OBSERVERS");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> {
            String _xblockexpression = null;
            Classifier _classifier = it.getClassifier();
            int nbPeers = this.peers.getNbReadOnlyAttributes((Class)_classifier);
            _xblockexpression = this.activeObjectToC((ClassifierInstance)it, nbPeers);
            return _xblockexpression;
        };
        String _join_1 = IterableExtensions.join((Iterable)ListExtensions.map(this.activeObjectsOBS, (Functions.Function1)_function_1));
        _builder.append(_join_1);
        _builder.newLineIfNotEmpty();
        _builder.append("#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Struct initializer for active objects.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("ActiveObjects activeObjects = {");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function_2 = it -> this.fieldToC((ClassifierInstance)it);
        String _join_2 = IterableExtensions.join((Iterable)ListExtensions.map(this.activeObjectsMAIN, (Functions.Function1)_function_2), (CharSequence)",\n");
        _builder.append(_join_2, "\t");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#ifdef WITH_OBSERVERS");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1 _function_3 = it -> this.fieldToC((ClassifierInstance)it);
        String _join_3 = IterableExtensions.join((Iterable)ListExtensions.map(this.activeObjectsOBS, (Functions.Function1)_function_3), (CharSequence)",\n");
        _builder.append(_join_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        return _builder.toString();
    }
}

