/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.identifiers;

import emi.serializer.identifiers.PortsID;
import emi.serializer.identifiers.SignalEventsID;
import emi.serializer.identifiers.StatesID;
import emi.serializer.model.ClassifierInstance;
import emi.serializer.model.GlobalClassifierInstance;
import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlNavigation;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class IdentifiersSerializer {
    private final StatesID statesId;
    private final SignalEventsID signalEventsId;
    private final PortsID portsId;
    private final List<ClassifierInstance> globalClassifierInstances;

    public IdentifiersSerializer(ResourceManager rm) {
        PortsID _portsID;
        SignalEventsID _signalEventsID;
        StatesID _statesID;
        this.statesId = _statesID = new StatesID(rm);
        this.signalEventsId = _signalEventsID = new SignalEventsID(rm);
        this.portsId = _portsID = new PortsID(rm);
        Functions.Function1 _function = it -> it instanceof GlobalClassifierInstance;
        this.globalClassifierInstances = IterableExtensions.toList((Iterable)IterableExtensions.filter(UmlNavigation.collectClassifierInstance(rm), (Functions.Function1)_function));
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#ifndef MODELS_IDENTIFIERS_H");
        _builder.newLine();
        _builder.append("#define MODELS_IDENTIFIERS_H");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @file identifiers.h");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Define identifiers for states and signal events of the UML model.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This file is automatically generated by the uml-serializer-c tool.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Do not modify manually.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author Matthias Brun (matthias.brun@eseo.fr)");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author Valentin Besnard (valentin.besnard@eseo.fr)");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"types_calibration.h\"");
        _builder.newLine();
        _builder.append("#include \"interpreter/active_object.h\"");
        _builder.newLine();
        _builder.append("#include \"interpreter/passive_object.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// Serialize root access to composite structure classes");
        _builder.newLine();
        Functions.Function1 _function = it -> {
            boolean _equals = "Obs".equals(it.getClassifier().getName());
            return !_equals;
        };
        Functions.Function1 _function_1 = it -> ((GlobalClassifierInstance)it).serializeRootAccess();
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(this.globalClassifierInstances, (Functions.Function1)_function), (Functions.Function1)_function_1), (CharSequence)"\n");
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifdef WITH_OBSERVERS");
        _builder.newLine();
        Functions.Function1 _function_2 = it -> "Obs".equals(it.getClassifier().getName());
        Functions.Function1 _function_3 = it -> ((GlobalClassifierInstance)it).serializeRootAccess();
        String _join_1 = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(this.globalClassifierInstances, (Functions.Function1)_function_2), (Functions.Function1)_function_3), (CharSequence)"\n");
        _builder.append(_join_1);
        _builder.newLineIfNotEmpty();
        _builder.append("#endif /* WITH_OBSERVERS */");
        _builder.newLine();
        _builder.newLine();
        String _serialize = this.statesId.serialize();
        _builder.append(_serialize);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serialize_1 = this.signalEventsId.serialize();
        _builder.append(_serialize_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _serialize_2 = this.portsId.serialize();
        _builder.append(_serialize_2);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#endif /* MODELS_IDENTIFIERS_H */");
        _builder.newLine();
        return _builder.toString();
    }
}

