/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.utils;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import emi.serializer.model.ClassifierInstance;
import emi.serializer.model.GlobalClassifierInstance;
import emi.serializer.model.PartClassifierInstance;
import emi.serializer.model.PartMultiplicity;
import emi.serializer.model.ResourceManager;
import emi.serializer.utils.IteratorExtensions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class UmlNavigation {
    public static final UMLPackage UML = UMLPackage.eINSTANCE;
    public static final String MAIN = "Main";
    public static final String OBS = "Obs";
    public static final String ENV = "Env";

    public static List<Signal> getSignals(ResourceManager rm) {
        Function<Resource, List> _function = it -> org.eclipse.xtext.xbase.lib.IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)it.getAllContents(), Signal.class));
        return rm.getList(_function);
    }

    public static List<Signal> getSignals(Class e) {
        Functions.Function1 _function = it -> it.getSignal();
        return ListExtensions.map(UmlNavigation.getAllReceptions(e), (Functions.Function1)_function);
    }

    public static boolean hasEventsParameters(Class e) {
        Functions.Function1 _function = it -> ((Object[])Conversions.unwrapArray((Object)it.getOwnedAttributes(), Object.class)).length;
        Functions.Function1 _function_1 = it -> it != 0;
        int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)ListExtensions.map(UmlNavigation.getSignals(e), (Functions.Function1)_function), (Functions.Function1)_function_1));
        return _size != 0;
    }

    public static List<SignalEvent> getSignalEvents(ResourceManager rm) {
        Function<Resource, List> _function = it -> org.eclipse.xtext.xbase.lib.IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)it.getAllContents(), SignalEvent.class));
        return rm.getList(_function);
    }

    public static List<Port> getPorts(ResourceManager rm) {
        Function<Resource, List> _function = it -> org.eclipse.xtext.xbase.lib.IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)it.getAllContents(), Port.class));
        return rm.getList(_function);
    }

    public static List<Transition> getAllTransitions(StateMachine sm) {
        return IterableExtensions.toList((Iterable)Iterables.filter((Iterable)sm.allOwnedElements(), Transition.class));
    }

    public static List<Vertex> getAllVertices(StateMachine sm) {
        return IterableExtensions.toList((Iterable)Iterables.filter((Iterable)sm.allOwnedElements(), Vertex.class));
    }

    public static StateMachine getStateMachine(Transition e) {
        EObject container = e.eContainer();
        while (!(container instanceof StateMachine)) {
            container = container.eContainer();
        }
        return (StateMachine)container;
    }

    public static List<Reception> getAllReceptions(Class e) {
        ArrayList<Reception> _xblockexpression = null;
        ArrayList<Reception> receptions = new ArrayList<Reception>();
        receptions.addAll((Collection<Reception>)e.getOwnedReceptions());
        Functions.Function1 _function = it -> it.getOwnedReceptions();
        Iterables.addAll(receptions, (Iterable)Iterables.concat((Iterable)ListExtensions.map((List)e.getAllImplementedInterfaces(), (Functions.Function1)_function)));
        Functions.Function1 _function_1 = it -> it.getOwnedReceptions();
        Iterables.addAll(receptions, (Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)e.allParents(), Class.class), (Functions.Function1)_function_1)));
        _xblockexpression = receptions;
        return _xblockexpression;
    }

    public static List<Class> getClasses(ResourceManager rm) {
        Function<Resource, List> _function = it -> org.eclipse.xtext.xbase.lib.IteratorExtensions.toList(IteratorExtensions.filterExact((Iterator<? super EObject>)it.getAllContents(), Class.class));
        return rm.getList(_function);
    }

    public static List<Class> getActiveClasses(ResourceManager rm) {
        Functions.Function1 _function = it -> it.isActive();
        return IterableExtensions.toList((Iterable)IterableExtensions.filter(UmlNavigation.getClasses(rm), (Functions.Function1)_function));
    }

    public static List<Class> getPassiveClasses(ResourceManager rm) {
        Functions.Function1 _function = it -> {
            boolean _isActive = it.isActive();
            return !_isActive;
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter(UmlNavigation.getClasses(rm), (Functions.Function1)_function));
    }

    public static InstanceSpecification getCompositeInstance(ResourceManager rm, Classifier classifier) {
        InstanceSpecification instance;
        InstanceSpecification _xblockexpression = null;
        Function<Resource, List> _function = it -> org.eclipse.xtext.xbase.lib.IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)it.getAllContents(), InstanceSpecification.class));
        List instances = rm.getList(_function);
        Functions.Function1 _function_1 = it -> ((Classifier)IterableExtensions.head((Iterable)it.getClassifiers())).equals(classifier);
        _xblockexpression = instance = (InstanceSpecification)IterableExtensions.head((Iterable)IterableExtensions.filter(instances, (Functions.Function1)_function_1));
        return _xblockexpression;
    }

    public static Class getCompositeClass(ResourceManager rm, String name) {
        Class _xblockexpression = null;
        Function<Resource, List> _function = it -> {
            Functions.Function1 _function_1 = it_1 -> it_1.getName().equals(name);
            return org.eclipse.xtext.xbase.lib.IteratorExtensions.toList((Iterator)org.eclipse.xtext.xbase.lib.IteratorExtensions.filter(IteratorExtensions.filterExact((Iterator<? super EObject>)it.getAllContents(), Class.class), (Functions.Function1)_function_1));
        };
        List composites = rm.getList(_function);
        _xblockexpression = (Class)IterableExtensions.head(composites);
        return _xblockexpression;
    }

    public static List<Property> getParts(ResourceManager rm) {
        ArrayList<Property> _xblockexpression = null;
        ArrayList<Property> parts = new ArrayList<Property>();
        Class main = UmlNavigation.getCompositeClass(rm, MAIN);
        if (main == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("ERROR: composite class \"");
            _builder.append(MAIN);
            _builder.append("\" not found");
            InputOutput.println((Object)_builder.toString());
        } else {
            parts.addAll(UmlNavigation.getAllParts(main));
        }
        Class obs = UmlNavigation.getCompositeClass(rm, OBS);
        if (obs != null) {
            parts.addAll(UmlNavigation.getAllParts(obs));
        }
        _xblockexpression = parts;
        return _xblockexpression;
    }

    public static List<Property> getAllParts(Class e) {
        ArrayList<Property> _xblockexpression = null;
        ArrayList<Property> parts = new ArrayList<Property>();
        parts.addAll((Collection<Property>)e.getParts());
        Functions.Function1 _function = it -> it.getType();
        Consumer<Type> _function_1 = it -> parts.addAll(UmlNavigation.getAllParts((Class)it));
        ListExtensions.map((List)e.getParts(), (Functions.Function1)_function).forEach(_function_1);
        _xblockexpression = parts;
        return _xblockexpression;
    }

    public static InstanceSpecification selectInstanceSpecification(Property part, InstanceSpecification compositeInstance) {
        InstanceSpecification _xblockexpression = null;
        InstanceSpecification instance = null;
        if (compositeInstance != null) {
            Functions.Function1 _function;
            EList slots = compositeInstance.getSlots();
            Slot slot = (Slot)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)slots, (Functions.Function1)(_function = it -> it.getDefiningFeature().getName().equals(part.getName()))));
            if (slot != null) {
                ValueSpecification _head = (ValueSpecification)IterableExtensions.head((Iterable)slot.getValues());
                InstanceValue value = (InstanceValue)_head;
                instance = value.getInstance();
            } else {
                boolean _tripleNotEquals;
                ValueSpecification _defaultValue = part.getDefaultValue();
                boolean bl = _tripleNotEquals = _defaultValue != null;
                if (_tripleNotEquals) {
                    ValueSpecification _defaultValue_1 = part.getDefaultValue();
                    instance = ((InstanceValue)_defaultValue_1).getInstance();
                }
            }
        }
        _xblockexpression = instance;
        return _xblockexpression;
    }

    public static List<ClassifierInstance> collectClassifierInstanceOfCompositeClass(ResourceManager rm, Class c) {
        ArrayList<ClassifierInstance> _xblockexpression = null;
        ArrayList<ClassifierInstance> objects = new ArrayList<ClassifierInstance>();
        if (c != null) {
            InstanceSpecification is = UmlNavigation.getCompositeInstance(rm, (Classifier)c);
            Consumer<Property> _function = it -> {
                ArrayList<PartMultiplicity> _arrayList = new ArrayList<PartMultiplicity>();
                objects.addAll(UmlNavigation.collectAllClassifierInstanceOfProperty(rm, it, is, _arrayList));
            };
            c.getParts().forEach(_function);
        }
        _xblockexpression = objects;
        return _xblockexpression;
    }

    private static ClassifierInstance collectClassifierInstanceOfProperty(ResourceManager rm, Property p, InstanceSpecification compositeInstance, List<PartMultiplicity> containers) {
        PartClassifierInstance _xblockexpression = null;
        InstanceSpecification instance = UmlNavigation.selectInstanceSpecification(p, compositeInstance);
        PartClassifierInstance _xifexpression = null;
        if (instance == null) {
            Type _type = p.getType();
            _xifexpression = new PartClassifierInstance(p, (Classifier)_type, null, compositeInstance, containers);
        } else {
            PartClassifierInstance _xblockexpression_1 = null;
            Classifier classifier = (Classifier)IterableExtensions.head((Iterable)instance.getClassifiers());
            _xifexpression = _xblockexpression_1 = new PartClassifierInstance(p, classifier, instance, compositeInstance, containers);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private static List<ClassifierInstance> collectAllClassifierInstanceOfProperty(ResourceManager rm, Property p, InstanceSpecification compositeInstance, List<PartMultiplicity> containers) {
        ArrayList<ClassifierInstance> _xblockexpression = null;
        ArrayList<ClassifierInstance> objects = new ArrayList<ClassifierInstance>();
        int _lower = p.getLower();
        Consumer<Integer> _function = it -> {
            ArrayList<PartMultiplicity> pContainers = new ArrayList<PartMultiplicity>();
            pContainers.addAll(containers);
            PartMultiplicity _partMultiplicity = new PartMultiplicity(p, (int)it);
            pContainers.add(_partMultiplicity);
            objects.add(UmlNavigation.collectClassifierInstanceOfProperty(rm, p, compositeInstance, pContainers));
            Type _type = p.getType();
            Consumer<Property> _function_1 = it_1 -> objects.addAll(UmlNavigation.collectAllClassifierInstanceOfProperty(rm, it_1, compositeInstance, pContainers));
            ((Class)_type).getParts().forEach(_function_1);
        };
        new ExclusiveRange(0, _lower, true).forEach(_function);
        _xblockexpression = objects;
        return _xblockexpression;
    }

    public static List<ClassifierInstance> collectClassifierInstanceWithCompositeClass(ResourceManager rm, String name) {
        ArrayList<ClassifierInstance> _xblockexpression = null;
        ArrayList<ClassifierInstance> objects = new ArrayList<ClassifierInstance>();
        Class composite = UmlNavigation.getCompositeClass(rm, name);
        if (composite != null) {
            InstanceSpecification _compositeInstance = UmlNavigation.getCompositeInstance(rm, (Classifier)composite);
            GlobalClassifierInstance _globalClassifierInstance = new GlobalClassifierInstance((Classifier)composite, _compositeInstance);
            objects.add(_globalClassifierInstance);
            objects.addAll(UmlNavigation.collectClassifierInstanceOfCompositeClass(rm, composite));
        }
        _xblockexpression = objects;
        return _xblockexpression;
    }

    public static List<ClassifierInstance> collectClassifierInstance(ResourceManager rm) {
        ArrayList<ClassifierInstance> _xblockexpression = null;
        ArrayList<ClassifierInstance> objects = new ArrayList<ClassifierInstance>();
        objects.addAll(UmlNavigation.collectClassifierInstanceWithCompositeClass(rm, MAIN));
        objects.addAll(UmlNavigation.collectClassifierInstanceWithCompositeClass(rm, OBS));
        _xblockexpression = objects;
        return _xblockexpression;
    }

    public static List<ClassifierInstance> getActiveObjectsList(ResourceManager rm) {
        List _xblockexpression = null;
        List<ClassifierInstance> list = UmlNavigation.collectClassifierInstance(rm);
        Functions.Function1 _function = it -> {
            Classifier _classifier = it.getClassifier();
            boolean _isActive = ((Class)_classifier).isActive();
            return _isActive;
        };
        _xblockexpression = IterableExtensions.toList((Iterable)IterableExtensions.filter(list, (Functions.Function1)_function));
        return _xblockexpression;
    }

    public static List<ClassifierInstance> getActiveObjectsListOfComposite(ResourceManager rm, String name) {
        List _xblockexpression = null;
        List<ClassifierInstance> list = UmlNavigation.collectClassifierInstanceWithCompositeClass(rm, name);
        Functions.Function1 _function = it -> {
            Classifier _classifier = it.getClassifier();
            boolean _isActive = ((Class)_classifier).isActive();
            return _isActive;
        };
        _xblockexpression = IterableExtensions.toList((Iterable)IterableExtensions.filter(list, (Functions.Function1)_function));
        return _xblockexpression;
    }

    public static List<ClassifierInstance> getPassiveObjectsList(ResourceManager rm) {
        List _xblockexpression = null;
        List<ClassifierInstance> list = UmlNavigation.collectClassifierInstance(rm);
        Functions.Function1 _function = it -> {
            Classifier _classifier = it.getClassifier();
            boolean _isActive = ((Class)_classifier).isActive();
            return !_isActive;
        };
        _xblockexpression = IterableExtensions.toList((Iterable)IterableExtensions.filter(list, (Functions.Function1)_function));
        return _xblockexpression;
    }

    public static List<ClassifierInstance> getPassiveObjectsListOfComposite(ResourceManager rm, String name) {
        List _xblockexpression = null;
        List<ClassifierInstance> list = UmlNavigation.collectClassifierInstanceWithCompositeClass(rm, name);
        Functions.Function1 _function = it -> {
            Classifier _classifier = it.getClassifier();
            boolean _isActive = ((Class)_classifier).isActive();
            return !_isActive;
        };
        _xblockexpression = IterableExtensions.toList((Iterable)IterableExtensions.filter(list, (Functions.Function1)_function));
        return _xblockexpression;
    }

    public static List<Property> getImplementedAndInheritedAttributes(Class e) {
        ArrayList<Property> _xblockexpression = null;
        ArrayList<Property> attributes = new ArrayList<Property>();
        Consumer<Class> _function = it -> attributes.addAll((Collection<Property>)it.getOwnedAttributes());
        UmlNavigation.getInheritanceTree((Classifier)e).forEach(_function);
        _xblockexpression = attributes;
        return _xblockexpression;
    }

    public static List<Property> getPrimitiveAttributes(Class e) {
        Functions.Function1 _function = it -> {
            Type _type = it.getType();
            return _type instanceof PrimitiveType;
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter(UmlNavigation.getImplementedAndInheritedAttributes(e), (Functions.Function1)_function));
    }

    public static List<Property> getAttributesNotPeers(Classifier e) {
        List _xblockexpression = null;
        List<Property> attributes = UmlNavigation.getImplementedAndInheritedAttributes((Class)e);
        Functions.Function1 _function = it -> {
            Type _type = it.getType();
            return !(_type instanceof Class);
        };
        _xblockexpression = IterableExtensions.toList((Iterable)IterableExtensions.filter(attributes, (Functions.Function1)_function));
        return _xblockexpression;
    }

    public static List<Class> getInheritanceTree(Classifier e) {
        List _xblockexpression = null;
        ArrayList<Class> inheritanceTree = new ArrayList<Class>();
        Class currentClass = (Class)e;
        while (currentClass != null) {
            inheritanceTree.add(currentClass);
            currentClass = (Class)IterableExtensions.head((Iterable)currentClass.getSuperClasses());
        }
        _xblockexpression = ListExtensions.reverse(inheritanceTree);
        return _xblockexpression;
    }

    public static StateMachine getStateMachine(Class e) {
        boolean _tripleNotEquals;
        StateMachine _xblockexpression = null;
        Behavior behavior = null;
        Behavior _classifierBehavior = e.getClassifierBehavior();
        boolean bl = _tripleNotEquals = _classifierBehavior != null;
        if (_tripleNotEquals) {
            behavior = e.getClassifierBehavior();
        } else {
            Class currentClass = e;
            while (((Object[])Conversions.unwrapArray((Object)currentClass.getSuperClasses(), Object.class)).length != 0 && behavior == null) {
                Behavior _classifierBehavior_1 = (currentClass = (Class)IterableExtensions.head((Iterable)currentClass.getSuperClasses())).getClassifierBehavior();
                boolean _tripleNotEquals_1 = _classifierBehavior_1 != null;
                if (!_tripleNotEquals_1) continue;
                behavior = currentClass.getClassifierBehavior();
            }
        }
        _xblockexpression = (StateMachine)behavior;
        return _xblockexpression;
    }

    public static List<Enumeration> getEnumerations(ResourceManager rm) {
        Function<Resource, List> _function = it -> org.eclipse.xtext.xbase.lib.IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)it.getAllContents(), Enumeration.class));
        return rm.getList(_function);
    }

    public static List<Operation> getOperations(ResourceManager rm) {
        Function<Resource, List> _function = it -> org.eclipse.xtext.xbase.lib.IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)it.getAllContents(), Operation.class));
        return rm.getList(_function);
    }
}

