/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.metamodel;

import com.google.common.collect.Iterables;
import emi.serializer.metamodel.IStrategy;
import emi.serializer.metamodel.Metaclass;
import emi.serializer.metamodel.MetamodelTable;
import emi.serializer.serialization.propertyserializer.DefaultPropertySerializer;
import emi.serializer.serialization.propertyserializer.PropertySerializer;
import emi.serializer.serialization.uml.UmlModelSerializer;
import emi.serializer.utils.UmlSerializerExtensions;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class MetamodelSerializer {
    private final MetamodelTable table;
    private final UmlModelSerializer modelSerializer;
    private final IStrategy strategy;

    public MetamodelSerializer(MetamodelTable table, IStrategy strategy) {
        UmlModelSerializer _umlModelSerializer;
        this.table = table;
        this.modelSerializer = _umlModelSerializer = new UmlModelSerializer();
        this.strategy = strategy;
    }

    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#ifndef METAMODEL_UML_METAMODEL_H");
        _builder.newLine();
        _builder.append("#define METAMODEL_UML_METAMODEL_H");
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @file metamodel.h");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Define UML concepts of the metamodel.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This file is automatically generated by the uml-serializer-c tool.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Do not modify manually.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author Matthias Brun (matthias.brun@eseo.fr)");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author Valentin Besnard (valentin.besnard@eseo.fr)");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"utilities/types.h\"");
        _builder.newLine();
        _builder.append("#include \"types_calibration.h\"");
        _builder.newLine();
        _builder.append("#include \"metamodel/c_uml.h\"");
        _builder.newLine();
        _builder.newLine();
        String _serializeHeaders = this.strategy.serializeHeaders();
        _builder.append(_serializeHeaders);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _typedefToC = this.typedefToC();
        _builder.append(_typedefToC);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _abstractTypeToC = this.abstractTypeToC();
        _builder.append(_abstractTypeToC);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _typeToC = this.typeToC();
        _builder.append(_typeToC);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#endif /* METAMODEL_UML_METAMODEL_H */");
        _builder.newLine();
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @file metamodel.c");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Define UML concepts of the metamodel.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This file is automatically generated by the uml-serializer-c tool.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Do not modify manually.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author Matthias Brun (matthias.brun@eseo.fr)");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @author Valentin Besnard (valentin.besnard@eseo.fr)");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append(" ");
        _builder.newLine();
        _builder.append("#include <stddef.h>");
        _builder.newLine();
        _builder.append("#include \"metamodel.h\"");
        _builder.newLine();
        _builder.newLine();
        String _serialize = this.strategy.serialize();
        _builder.append(_serialize);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String typedefToC() {
        String _xblockexpression = null;
        Functions.Function1 _function = it -> {
            EClassifier _key = (EClassifier)it.getKey();
            return _key instanceof EClass;
        };
        Iterable classes = IterableExtensions.filter(this.table.getMetaclasses().entrySet(), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> {
            EClassifier _key = (EClassifier)it.getKey();
            return _key instanceof EEnum;
        };
        Iterable enums = IterableExtensions.filter(this.table.getMetaclasses().entrySet(), (Functions.Function1)_function_1);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* All typedef of UML types.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        String _typedefToC = this.modelSerializer.typedefToC();
        _builder.append(_typedefToC);
        _builder.newLineIfNotEmpty();
        Functions.Function1 _function_2 = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("typedef enum ");
            String _typeName = UmlSerializerExtensions.typeName((EObject)it.getKey());
            _builder_1.append(_typeName);
            _builder_1.append(" ");
            String _typeName_1 = UmlSerializerExtensions.typeName((EObject)it.getKey());
            _builder_1.append(_typeName_1);
            _builder_1.append(";");
            return _builder_1.toString();
        };
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)enums, (Functions.Function1)_function_2), (CharSequence)"\n");
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        Functions.Function1 _function_3 = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("typedef struct ");
            String _typeName = UmlSerializerExtensions.typeName((EObject)it.getKey());
            _builder_1.append(_typeName);
            _builder_1.append(" ");
            String _typeName_1 = UmlSerializerExtensions.typeName((EObject)it.getKey());
            _builder_1.append(_typeName_1);
            _builder_1.append(";");
            return _builder_1.toString();
        };
        String _join_1 = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)classes, (Functions.Function1)_function_3), (CharSequence)"\n");
        _builder.append(_join_1);
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String abstractTypeToC() {
        String _xblockexpression = null;
        Functions.Function1 _function = it -> {
            EClassifier _key = (EClassifier)it.getKey();
            return _key instanceof EClass;
        };
        Iterable classes = IterableExtensions.filter(this.table.getMetaclasses().entrySet(), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> {
            boolean _notEquals;
            String _xblockexpression_1 = null;
            EClassifier _key = (EClassifier)it.getKey();
            EClass eClass = (EClass)_key;
            ArrayList allAttributes = new ArrayList();
            Functions.Function1 _function_2 = it_1 -> {
                StringConcatenation _builder = new StringConcatenation();
                CharSequence _type = it_1.type(eClass, null);
                _builder.append((Object)_type);
                return _builder.toString();
            };
            allAttributes.addAll(ListExtensions.map(((Metaclass)it.getValue()).getProperties(), (Functions.Function1)_function_2));
            Functions.Function1 _function_3 = it_1 -> {
                String _xblockexpression_2 = null;
                EStructuralFeature feature = eClass.getEStructuralFeature((String)it_1.getKey());
                EClassifier featureType = null;
                PropertySerializer serializer = (PropertySerializer)it_1.getValue();
                featureType = serializer instanceof DefaultPropertySerializer ? ((DefaultPropertySerializer)serializer).getType(feature) : feature.getEType();
                Metaclass attributeMetaclass = this.table.getMetaclasses().get(featureType);
                StringConcatenation _builder = new StringConcatenation();
                CharSequence _type = ((PropertySerializer)it_1.getValue()).type(eClass, attributeMetaclass);
                _builder.append((Object)_type);
                _xblockexpression_2 = _builder.toString();
                return _xblockexpression_2;
            };
            Iterables.addAll(allAttributes, (Iterable)IterableExtensions.map(((Metaclass)it.getValue()).getAttributes().entrySet(), (Functions.Function1)_function_3));
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Attributes defined for the class ");
            String _typeName = UmlSerializerExtensions.typeName((EObject)eClass);
            _builder.append(_typeName, " ");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("* This definition contains only own attributes of the class and not inherited attributes.");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("#define ABSTRACT_");
            String _typeName_1 = UmlSerializerExtensions.typeName((EObject)eClass);
            _builder.append(_typeName_1);
            _builder.append(" ");
            StringConcatenation _xifexpression = null;
            ArrayList _converted_allAttributes = allAttributes;
            int _length = ((Object[])Conversions.unwrapArray(_converted_allAttributes, Object.class)).length;
            boolean bl = _notEquals = _length != 0;
            if (_notEquals) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("\\");
                _xifexpression = _builder_1;
            }
            _builder.append(_xifexpression);
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _join = IterableExtensions.join(allAttributes, (CharSequence)" \\\n");
            _builder.append(_join, "\t");
            _builder.newLineIfNotEmpty();
            _xblockexpression_1 = _builder.toString();
            return _xblockexpression_1;
        };
        _xblockexpression = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)classes, (Functions.Function1)_function_1), (CharSequence)"");
        return _xblockexpression;
    }

    private String typeToC() {
        String _xblockexpression = null;
        Functions.Function1 _function = it -> {
            EClassifier _key = (EClassifier)it.getKey();
            return _key instanceof EClass;
        };
        Iterable classes = IterableExtensions.filter(this.table.getMetaclasses().entrySet(), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> {
            EClassifier _key = (EClassifier)it.getKey();
            return _key instanceof EEnum;
        };
        Iterable enums = IterableExtensions.filter(this.table.getMetaclasses().entrySet(), (Functions.Function1)_function_1);
        String modelString = this.modelSerializer.typeToC();
        Functions.Function1 _function_2 = it -> {
            String _xblockexpression_1 = null;
            EClassifier _key = (EClassifier)it.getKey();
            EEnum enum_ = (EEnum)_key;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Definition of the enum ");
            String _typeName = UmlSerializerExtensions.typeName((EObject)enum_);
            _builder.append(_typeName, " ");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("enum ");
            String _typeName_1 = UmlSerializerExtensions.typeName((EObject)enum_);
            _builder.append(_typeName_1);
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            Functions.Function1 _function_3 = it_1 -> {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("UML_");
                String _upperCase = it_1.getName().toUpperCase();
                _builder_1.append(_upperCase);
                return _builder_1.toString();
            };
            String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)enum_.getELiterals(), (Functions.Function1)_function_3), (CharSequence)",\n");
            _builder.append(_join, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("};");
            _builder.newLine();
            _xblockexpression_1 = _builder.toString();
            return _xblockexpression_1;
        };
        String enumString = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)enums, (Functions.Function1)_function_2), (CharSequence)"");
        Functions.Function1 _function_3 = it -> {
            String _xblockexpression_1 = null;
            EClassifier _key = (EClassifier)it.getKey();
            EClass eClass = (EClass)_key;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Definition of the type ");
            String _typeName = UmlSerializerExtensions.typeName((EObject)eClass);
            _builder.append(_typeName, " ");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("* This structure contains own attributes of the class and inherited attributes.");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("struct ");
            String _typeName_1 = UmlSerializerExtensions.typeName((EObject)eClass);
            _builder.append(_typeName_1);
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _addFieldsTypes = this.strategy.addFieldsTypes((Metaclass)it.getValue());
            _builder.append(_addFieldsTypes, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            Functions.Function1 _function_4 = it_1 -> {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("ABSTRACT_");
                String _typeName_2 = UmlSerializerExtensions.typeName((EObject)it_1);
                _builder_1.append(_typeName_2);
                return _builder_1.toString();
            };
            String _join = IterableExtensions.join((Iterable)IterableExtensions.map(((Metaclass)it.getValue()).getSuperclasses(), (Functions.Function1)_function_4), (CharSequence)"\n");
            _builder.append(_join, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("ABSTRACT_");
            String _typeName_2 = UmlSerializerExtensions.typeName((EObject)eClass);
            _builder.append(_typeName_2, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("};");
            _builder.newLine();
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Definition of a variable of type ");
            String _typeName_3 = UmlSerializerExtensions.typeName((EObject)eClass);
            _builder.append(_typeName_3, " ");
            _builder.append(" with default value.");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("#define C_");
            String _upperCase = UmlSerializerExtensions.typeName((EObject)eClass).toUpperCase();
            _builder.append(_upperCase, " ");
            _builder.append("_NULL  {");
            String _addFieldsInitializers = this.strategy.addFieldsInitializers(eClass);
            _builder.append(_addFieldsInitializers, " ");
            _builder.append(" ");
            Functions.Function1 _function_5 = it_1 -> {
                StringConcatenation _builder_1 = new StringConcatenation();
                CharSequence _defaultValue = it_1.defaultValue(eClass);
                _builder_1.append((Object)_defaultValue);
                return _builder_1.toString();
            };
            String _join_1 = IterableExtensions.join((Iterable)ListExtensions.map(this.table.getAllAttributesSerializer((Metaclass)it.getValue()), (Functions.Function1)_function_5), (CharSequence)",");
            _builder.append(_join_1, " ");
            _builder.append(" }");
            _builder.newLineIfNotEmpty();
            _xblockexpression_1 = _builder.toString();
            return _xblockexpression_1;
        };
        String classesString = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)classes, (Functions.Function1)_function_3), (CharSequence)"");
        _xblockexpression = modelString + enumString + classesString;
        return _xblockexpression;
    }
}

