/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.memoryobjects;

import emi.serializer.memoryobjects.PropertiesRO;
import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlNavigation;
import emi.serializer.utils.UmlSerializerExtensions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class ClassInfo {
    private final List<Class> classes;
    private final PropertiesRO propertiesRO;

    public ClassInfo(ResourceManager rm) {
        PropertiesRO _propertiesRO;
        this.classes = UmlNavigation.getClasses(rm);
        this.propertiesRO = _propertiesRO = new PropertiesRO(rm);
    }

    private List<Pair<Property, Boolean>> getProperties(Class c) {
        ArrayList<Pair<Property, Boolean>> _xblockexpression = null;
        ArrayList<Pair<Property, Boolean>> props = new ArrayList<Pair<Property, Boolean>>();
        Consumer<Property> _function = it -> {
            Pair _pair = new Pair(it, (Object)false);
            props.add(_pair);
        };
        this.propertiesRO.getReadOnlyAttributes(c).forEach(_function);
        Consumer<Property> _function_1 = it -> {
            Pair _pair = new Pair(it, (Object)true);
            props.add(_pair);
        };
        ClassInfo.getReadWriteAttributes(c).forEach(_function_1);
        _xblockexpression = props;
        return _xblockexpression;
    }

    public static List<Property> getReadWriteAttributes(Class c) {
        Functions.Function1 _function = it -> {
            Type _type = it.getType();
            return !(_type instanceof Class);
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)c.getOwnedAttributes(), (Functions.Function1)_function));
    }

    private CharSequence serializeMutabilityTypedefToC(Class c) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("typedef struct ");
        String _name = c.getName();
        _builder.append(_name);
        _builder.append("_mutability ");
        String _name_1 = c.getName();
        _builder.append(_name_1);
        _builder.append("_mutability;");
        return _builder;
    }

    private CharSequence serializeMutabilityStructToC(Class c) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("struct ");
        String _name = c.getName();
        _builder.append(_name);
        _builder.append("_mutability {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Functions.Function1 _function = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("ABSTRACT_MUTABILITY_");
            String _name_1 = it.getName();
            _builder_1.append(_name_1);
            return _builder_1.toString();
        };
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(UmlNavigation.getInheritanceTree((Classifier)c), (Functions.Function1)_function), (CharSequence)"\n");
        _builder.append(_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        return _builder;
    }

    private CharSequence serializeMutabilityMacro(Class c) {
        StringConcatenation _xblockexpression = null;
        ArrayList<Property> props = new ArrayList<Property>();
        props.addAll(this.propertiesRO.getReadOnlyAttributes(c));
        props.addAll(ClassInfo.getReadWriteAttributes(c));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#define ABSTRACT_MUTABILITY_");
        String _name = c.getName();
        _builder.append(_name);
        _builder.append("  ");
        Functions.Function1 _function = it -> this.serializeMutabilityFieldToC((Property)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(props, (Functions.Function1)_function), (CharSequence)"\t\\\n\t");
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence serializeMutabilityFieldToC(Property e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("bool ");
        String _name = e.getName();
        _builder.append(_name);
        _builder.append("_isMutable\t\t:1;");
        return _builder;
    }

    private CharSequence serializeTypedefPropertiesTypesToC(Class c) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("typedef struct ");
        String _name = c.getName();
        _builder.append(_name);
        _builder.append("_PropertiesTypes ");
        String _name_1 = c.getName();
        _builder.append(_name_1);
        _builder.append("_PropertiesTypes;");
        return _builder;
    }

    private CharSequence serializePropertiesTypesStructToC(Class c) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("struct ");
        String _name = c.getName();
        _builder.append(_name);
        _builder.append("_PropertiesTypes {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Functions.Function1 _function = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("ABSTRACT_PROPERTIES_TYPE_");
            String _name_1 = it.getName();
            _builder_1.append(_name_1);
            return _builder_1.toString();
        };
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(UmlNavigation.getInheritanceTree((Classifier)c), (Functions.Function1)_function), (CharSequence)"\n");
        _builder.append(_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        return _builder;
    }

    private CharSequence serializePropertiesTypesMacro(Class c) {
        StringConcatenation _xblockexpression = null;
        List<Pair<Property, Boolean>> props = this.getProperties(c);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#define ABSTRACT_PROPERTIES_TYPE_");
        String _name = c.getName();
        _builder.append(_name);
        _builder.append("  ");
        Functions.Function1 _function = it -> this.serializePropertiesTypesFieldToC((Property)it.getKey(), (Boolean)it.getValue(), c);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(props, (Functions.Function1)_function), (CharSequence)"\t\\\n\t");
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence serializePropertiesTypesFieldToC(Property e, boolean isMutable, Class c) {
        StringConcatenation _xifexpression = null;
        if (isMutable) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = c.getName();
            _builder.append(_name);
            _builder.append("_od * ");
            String _name_1 = e.getName();
            _builder.append(_name_1);
            _builder.append("_type;");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _name_2 = c.getName();
            _builder_1.append(_name_2);
            _builder_1.append("_properties_ro * ");
            String _name_3 = e.getName();
            _builder_1.append(_name_3);
            _builder_1.append("_type;");
            _xifexpression = _builder_1;
        }
        return _xifexpression;
    }

    private CharSequence serializeTypedefToC(Class c) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("typedef struct ");
        String _name = c.getName();
        _builder.append(_name);
        _builder.append("_classInfo ");
        String _name_1 = c.getName();
        _builder.append(_name_1);
        _builder.append("_classInfo;");
        return _builder;
    }

    private CharSequence serializeStructToC(Class c) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("struct ");
        String _name = c.getName();
        _builder.append(_name);
        _builder.append("_classInfo {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("union {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("UML_Class * type;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("const ");
        String _name_1 = c.getName();
        _builder.append(_name_1, "\t\t");
        _builder.append("_PropertiesTypes * properties_types; // Should not be dereferenced");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t");
        String _name_2 = c.getName();
        _builder.append(_name_2, "\t");
        _builder.append("_mutability mutability;");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        return _builder;
    }

    private CharSequence serializeStructInitializerToC(Classifier e) {
        StringConcatenation _xblockexpression = null;
        ArrayList props = new ArrayList();
        Consumer<Class> _function = it -> {
            Consumer<Property> _function_1 = it_1 -> {
                Pair _pair = new Pair(it_1, (Object)false);
                props.add(_pair);
            };
            this.propertiesRO.getReadOnlyAttributes((Class)it).forEach(_function_1);
            Consumer<Property> _function_2 = it_1 -> {
                Pair _pair = new Pair(it_1, (Object)true);
                props.add(_pair);
            };
            ClassInfo.getReadWriteAttributes(it).forEach(_function_2);
        };
        UmlNavigation.getInheritanceTree(e).forEach(_function);
        StringConcatenation _builder = new StringConcatenation();
        String _name = e.getName();
        _builder.append(_name);
        _builder.append("_classInfo ");
        String _actualName = UmlSerializerExtensions.actualName((EObject)e);
        _builder.append(_actualName);
        _builder.append("_classInfo = {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(".type = &");
        String _variableName = UmlSerializerExtensions.variableName((EObject)e);
        _builder.append(_variableName, "\t");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(".mutability = {");
        _builder.newLine();
        _builder.append("\t\t");
        Functions.Function1 _function_1 = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            CharSequence _serializeMutabilityFieldInitializerToC = this.serializeMutabilityFieldInitializerToC((Property)it.getKey(), (Boolean)it.getValue());
            _builder_1.append((Object)_serializeMutabilityFieldInitializerToC);
            return _builder_1.toString();
        };
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(props, (Functions.Function1)_function_1), (CharSequence)",\n");
        _builder.append(_join, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence serializeMutabilityFieldInitializerToC(Property e, boolean isMutable) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".");
        String _name = e.getName();
        _builder.append(_name);
        _builder.append("_isMutable = ");
        _builder.append((Object)isMutable);
        return _builder;
    }

    public String serializeHeadersTypedef() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Typedef for mutability of properties.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.serializeMutabilityTypedefToC((Class)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.classes, (Functions.Function1)_function), (CharSequence)"\n");
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Typedef for properties types.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> this.serializeTypedefPropertiesTypesToC((Class)it);
        String _join_1 = IterableExtensions.join((Iterable)ListExtensions.map(this.classes, (Functions.Function1)_function_1), (CharSequence)"\n");
        _builder.append(_join_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Typedef for class information.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function_2 = it -> this.serializeTypedefToC((Class)it);
        String _join_2 = IterableExtensions.join((Iterable)ListExtensions.map(this.classes, (Functions.Function1)_function_2), (CharSequence)"\n");
        _builder.append(_join_2);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Macros for the mutability field of mutability structure.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.serializeMutabilityMacro((Class)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.classes, (Functions.Function1)_function), (CharSequence)"\n");
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Mutability structures.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> this.serializeMutabilityStructToC((Class)it);
        String _join_1 = IterableExtensions.join((Iterable)ListExtensions.map(this.classes, (Functions.Function1)_function_1), (CharSequence)"\n");
        _builder.append(_join_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Macros for the properties_types field of properties type structure.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function_2 = it -> this.serializePropertiesTypesMacro((Class)it);
        String _join_2 = IterableExtensions.join((Iterable)ListExtensions.map(this.classes, (Functions.Function1)_function_2), (CharSequence)"\n");
        _builder.append(_join_2);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Properties type structures.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function_3 = it -> this.serializePropertiesTypesStructToC((Class)it);
        String _join_3 = IterableExtensions.join((Iterable)ListExtensions.map(this.classes, (Functions.Function1)_function_3), (CharSequence)"\n");
        _builder.append(_join_3);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Class information structures.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function_4 = it -> this.serializeStructToC((Class)it);
        String _join_4 = IterableExtensions.join((Iterable)ListExtensions.map(this.classes, (Functions.Function1)_function_4), (CharSequence)"\n");
        _builder.append(_join_4);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Class information initializers.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.serializeStructInitializerToC((Classifier)it);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(this.classes, (Functions.Function1)_function), (CharSequence)"\n");
        _builder.append(_join);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }
}

