/*
 * Decompiled with CFR 0.152.
 */
package emi.analysis.server;

import emi.analysis.annotation.SuppressFBWarnings;
import emi.analysis.model.EMIModel;
import emi.analysis.server.EMIServer;
import emi.analysis.server.atom.AtomManager;
import emi.analysis.server.interpreter.ProxyInterpreter;
import emi.analysis.server.log.Log;
import emi.analysis.server.translator.Translator;
import emi.analysis.server.translator.TranslatorFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.ParserProperties;
import org.kohsuke.args4j.spi.OptionHandler;

public final class Main {
    private static EMIServerOptions options;
    private static final int HELP_WIDTH = 150;
    private static ProxyInterpreter interpreter;
    private static AtomManager atomManager;
    private static Translator translator;
    private static EMIServer server;

    private Main() {
    }

    private static final boolean manageOptions(String ... args) throws CmdLineException, IOException {
        CmdLineParser parser = new CmdLineParser((Object)options, ParserProperties.defaults().withOptionSorter((Comparator)options));
        try {
            parser.parseArgument(args);
            if (options.help) {
                Main.printHelp(parser);
            }
            if (options.version) {
                Main.printVersion();
            }
            if (options.help || options.version) {
                return false;
            }
            Main.checkEMIHomeOption(parser);
            Main.checkEMIModelOption(parser);
        }
        catch (CmdLineException e) {
            Main.printHelp(parser);
            throw e;
        }
        return true;
    }

    private static final void checkEMIHomeOption(CmdLineParser parser) throws CmdLineException, IOException {
        if (options.atomEvaluation && options.emiHome == null) {
            throw new CmdLineException(parser, "EMI home directory must be set (for atom evaluation)", (Throwable)new Error());
        }
        if (options.emiHome != null) {
            options.emiHome = EMIModel.checkEMIHome(options.emiHome);
        }
    }

    private static final void checkEMIModelOption(CmdLineParser parser) throws CmdLineException, IOException {
        if ((options.atomEvaluation || options.translation) && options.emiModel == null) {
            throw new CmdLineException(parser, "The EMI model must be set (for atom evaluation or for translation)", (Throwable)new Error());
        }
        if (options.emiModel != null) {
            options.emiModel = EMIModel.checkEMIModel(options.emiModel);
        }
    }

    private static final void printHelp(CmdLineParser parser) {
        System.out.println("Usage:");
        parser.getProperties().withUsageWidth(150);
        parser.printUsage((OutputStream)System.out);
    }

    private static final void printVersion() {
        System.out.println("Version under development !");
    }

    public static void main(String ... args) {
        boolean exitServer = false;
        options = new EMIServerOptions();
        try {
            boolean bl = exitServer = !Main.manageOptions(args);
            if (!exitServer) {
                Main.logStart();
                Main.configureInterpreter();
                Main.configureAtomManager();
                Main.configureTranslator();
                Main.configureServer();
                while (!exitServer) {
                    exitServer = server.run();
                }
            }
        }
        catch (IOException | CmdLineException e) {
            Log.e(e.getMessage());
        }
        finally {
            if (server != null) {
                Log.i("EMI Server stop");
                server.close();
            }
            if (interpreter != null) {
                Log.i("Interpreter stop");
                interpreter.close();
            }
        }
    }

    private static void logStart() {
        Log.i("EMI Server start");
        if (options.atomEvaluation || options.translation) {
            Log.i("EMI Model: " + options.emiModel);
        }
        if (options.atomEvaluation) {
            Log.i("EMI Home: " + options.emiHome);
            Log.i("Target: " + options.target);
        }
    }

    private static void configureInterpreter() throws IOException {
        Log.i("Interpreter @" + options.interpreterAdress + ":" + options.interpreterPort);
        interpreter = new ProxyInterpreter(options.interpreterAdress, options.interpreterPort);
    }

    private static void configureAtomManager() throws IOException {
        if (options.atomEvaluation) {
            atomManager = new AtomManager(interpreter.getConnection(), options.emiHome, options.emiModel, options.target, options.compiler, options.makeTool, options.logAtomEvaluation);
            Log.i("Interpreter atoms bank: " + atomManager.getAtomsBankMax() + " place" + (atomManager.getAtomsBankMax() > 1 ? "s" : "") + " (size: " + atomManager.getAtomsSizeMax() + " bytes)");
        }
    }

    private static void configureTranslator() throws IOException {
        if (options.translation) {
            Log.i("Translation based on: " + options.dwarfTool + " format");
            translator = TranslatorFactory.buildTranslator(options.emiModel, options.target, options.dwarfTool, options.logTranslation);
        }
    }

    private static void configureServer() throws IOException {
        server = new EMIServer(options.serverPort, interpreter, atomManager, translator, options.logServices);
        server.open();
        Log.i("EMI Server @any:" + options.serverPort);
    }

    @SuppressFBWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="does not need serialization")
    public static class EMIServerOptions
    implements Comparator<OptionHandler> {
        private static final int DEFAULT_SERVER_PORT = 12346;
        private static final int DEFAULT_INTERPRETER_PORT = 12345;
        private static final String DEFAULT_INTERPRETER_IP = "127.0.0.1";
        @Option(name="-h", aliases={"--help"}, help=true, usage="Print help")
        private boolean help;
        @Option(name="-v", aliases={"--version"}, help=true, usage="Print version")
        private boolean version;
        @Option(name="-ls", aliases={"--log-services"}, usage="Log server services requests (useful for services debug)")
        private boolean logServices;
        @Option(name="-P", aliases={"--server-port"}, metaVar="PORT", usage="EMI server port")
        private int serverPort = 12346;
        @Option(name="-a", aliases={"--interpreter-address"}, metaVar="IP", usage="Interpreter IP address")
        private String interpreterAdress = "127.0.0.1";
        @Option(name="-p", aliases={"--interpreter-port"}, metaVar="PORT", usage="Interpreter port")
        private int interpreterPort = 12345;
        @Option(name="-u", aliases={"--emi-uml-model"}, metaVar="MODEL_DIR_PATH", usage="Path to the interpreted EMI UML model (necessary for atom evaluations or for translation)")
        private String emiModel;
        @Option(name="-A", aliases={"--atom-evaluation"}, depends={"-u"}, usage="Enable atom evaluations")
        private boolean atomEvaluation;
        @Option(name="-e", aliases={"--emi-home"}, metaVar="DIR_PATH", usage="EMI home directory (useful for atom evaluations) (default: use $EMI_HOME)")
        private String emiHome = System.getenv("EMI_HOME");
        @Option(name="-t", aliases={"--interpreter-target"}, metaVar="TARGET", depends={"-A"}, usage="Interpreter target (useful for atom evaluations)")
        private String target = "host";
        @Option(name="-c", aliases={"--atoms-compiler"}, metaVar="COMPILER", depends={"-A"}, usage="Atoms C compiler (useful for atom evaluations) (default: gcc on host)")
        private String compiler;
        @Option(name="-m", aliases={"--make-tool"}, metaVar="MAKE_TOOL", depends={"-A"}, usage="The software make to use (useful for atom evaluations)")
        private String makeTool = "make";
        @Option(name="-la", aliases={"--log-atom-evaluation"}, depends={"-A"}, usage="Log the atom evaluation activity (useful for atom evaluations debug)")
        private boolean logAtomEvaluation;
        @Option(name="-T", aliases={"--translation"}, usage="Enable translation of configurations and/or transitions into analysis tool format")
        private boolean translation;
        @Option(name="-d", aliases={"--dwarf-tool"}, metaVar="DWARF_TOOL", depends={"-T"}, usage="Tool to read dwarf information (\"pahole\", \"objdump\", \"dwarfdump\") (useful for translation)")
        private String dwarfTool = "pahole";
        @Option(name="-lt", aliases={"--log-translation"}, depends={"-T"}, usage="Log the translation activity (useful for translation debug)")
        private boolean logTranslation;
        @Argument
        private List<String> argument;
        private final List<String> order = Arrays.asList("-h", "-v", "-ls", "-P", "-a", "-p", "-u", "-A", "-e", "-t", "-c", "-m", "-la", "-T", "-d", "-lt");

        @Override
        public int compare(OptionHandler o1, OptionHandler o2) {
            return Integer.compare(this.order.indexOf(o1.getNameAndMeta(null).split(" ")[0]), this.order.indexOf(o2.getNameAndMeta(null).split(" ")[0]));
        }
    }
}

