/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.symbols;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import emi.serializer.model.ModelLoader;
import emi.serializer.model.ResourceManager;
import emi.serializer.symbols.SymbolClass;
import emi.serializer.symbols.SymbolTable;
import emi.serializer.utils.UmlNavigation;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class SymbolMatcher {
    private final ModelLoader modelLoader;
    private final ResourceManager resourceManager;
    private final SymbolTable symbolTable;
    private final Map<Class<?>, Map<String, ?>> searchCache = new HashMap();
    private List<SignalEvent> signalEventsCache = null;
    private final Map<String, Enumeration> enumCache = new HashMap<String, Enumeration>();

    public SymbolMatcher(String emiModel) {
        SymbolTable _symbolTable;
        ResourceManager _resourceManager;
        ModelLoader _modelLoader;
        File directory = new File(emiModel + "/uml/");
        String[] _list = directory.list();
        Functions.Function1 _function = it -> it.endsWith(".uml");
        Iterable _filter = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_list)), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> {
            StringConcatenation _builder = new StringConcatenation();
            String _absolutePath = directory.getAbsolutePath();
            _builder.append((Object)_absolutePath, "");
            _builder.append((Object)"/");
            _builder.append(it, "");
            return new String(_builder.toString());
        };
        Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        List umlFiles = IterableExtensions.toList((Iterable)_map);
        this.modelLoader = _modelLoader = new ModelLoader();
        Functions.Function1 _function_2 = it -> this.modelLoader.load((String)it);
        List resources = ListExtensions.map((List)umlFiles, (Functions.Function1)_function_2);
        this.resourceManager = _resourceManager = new ResourceManager(resources);
        this.symbolTable = _symbolTable = new SymbolTable(this.resourceManager);
    }

    public String searchActiveObject(int aoId) {
        List<String> _flatActiveObjectsName = this.symbolTable.getFlatActiveObjectsName();
        return _flatActiveObjectsName.get(aoId);
    }

    public <T extends NamedElement> T search(Class<T> type, String name) {
        NamedElement _xblockexpression = null;
        Map _elvis = null;
        Map _get = this.searchCache.get(type);
        if (_get != null) {
            _elvis = _get;
        } else {
            Map _xblockexpression_1 = null;
            Function<Resource, List> _function = it -> {
                TreeIterator _allContents = it.getAllContents();
                UnmodifiableIterator _filter = Iterators.filter((Iterator)_allContents, (Class)type);
                return IteratorExtensions.toList((Iterator)_filter);
            };
            List<List> _map = this.resourceManager.map(_function);
            Iterable _flatten = Iterables.concat(_map);
            Functions.Function1 _function_1 = it -> it.getName();
            Map c = IterableExtensions.toMap((Iterable)_flatten, (Functions.Function1)_function_1);
            this.searchCache.put(type, c);
            _elvis = _xblockexpression_1 = c;
        }
        Map typeSpecificCache = _elvis;
        Object _get_1 = typeSpecificCache.get(name);
        _xblockexpression = (NamedElement)_get_1;
        return (T)_xblockexpression;
    }

    public Vertex searchState(String ao, int stateId) {
        Vertex _xblockexpression = null;
        Map<String, String> _flatMapping = this.symbolTable.getFlatMapping();
        String class_ = _flatMapping.get(ao);
        Map<String, SymbolClass> _symbolClasses = this.symbolTable.getSymbolClasses();
        SymbolClass symbolClass = _symbolClasses.get(class_);
        List<Vertex> _vertices = symbolClass.getVertices();
        _xblockexpression = _vertices.get(stateId);
        return _xblockexpression;
    }

    public String searchStateName(String ao, int stateId) {
        Vertex _searchState = this.searchState(ao, stateId);
        return _searchState.getName();
    }

    public Transition searchTransition(String ao, int stateId, int transitionId) {
        Transition _xblockexpression = null;
        Map<String, String> _flatMapping = this.symbolTable.getFlatMapping();
        String class_ = _flatMapping.get(ao);
        Map<String, SymbolClass> _symbolClasses = this.symbolTable.getSymbolClasses();
        SymbolClass symbolClass = _symbolClasses.get(class_);
        List<Vertex> _vertices = symbolClass.getVertices();
        Vertex _get = _vertices.get(stateId);
        EList _outgoings = _get.getOutgoings();
        _xblockexpression = (Transition)_outgoings.get(transitionId);
        return _xblockexpression;
    }

    public TransitionInfo searchTransitionInfo(String ao, int stateId, int transitionId) {
        TransitionInfo _xblockexpression = null;
        Transition tr = this.searchTransition(ao, stateId, transitionId);
        Map<String, String> _flatMapping = this.symbolTable.getFlatMapping();
        String class_ = _flatMapping.get(ao);
        Map<String, SymbolClass> _symbolClasses = this.symbolTable.getSymbolClasses();
        SymbolClass symbolClass = _symbolClasses.get(class_);
        List<Vertex> _vertices = symbolClass.getVertices();
        Vertex _target = tr.getTarget();
        int targetId = _vertices.indexOf(_target);
        String _name = tr.getName();
        Vertex _source = tr.getSource();
        String _name_1 = _source.getName();
        Vertex _target_1 = tr.getTarget();
        String _name_2 = _target_1.getName();
        _xblockexpression = new TransitionInfo(_name, _name_1, _name_2, targetId);
        return _xblockexpression;
    }

    public SignalEvent searchSignalEvent(int signalEventId) {
        SignalEvent _xblockexpression = null;
        if (this.signalEventsCache == null) {
            List<SignalEvent> _signalEvents = UmlNavigation.getSignalEvents(this.resourceManager);
            this.signalEventsCache = _signalEvents;
        }
        _xblockexpression = this.signalEventsCache.get(signalEventId);
        return _xblockexpression;
    }

    public String searchSignalEventName(int signalEventId) {
        SignalEvent _searchSignalEvent = this.searchSignalEvent(signalEventId);
        return _searchSignalEvent.getName();
    }

    public Port searchPort(int portId) {
        List<Port> _ports = UmlNavigation.getPorts(this.resourceManager);
        return _ports.get(portId);
    }

    public String searchPortName(int portId) {
        Port _searchPort = this.searchPort(portId);
        return _searchPort.getName();
    }

    public String searchEnumerationLiteralName(String enumName, int value) throws IndexOutOfBoundsException {
        boolean _greaterEqualsThan;
        String _xblockexpression = null;
        Enumeration _searchEnumeration = this.searchEnumeration(enumName);
        EList literals = _searchEnumeration.getOwnedLiterals();
        int _size = literals.size();
        boolean bl = _greaterEqualsThan = value >= _size;
        if (_greaterEqualsThan) {
            throw new IndexOutOfBoundsException();
        }
        EnumerationLiteral _get = (EnumerationLiteral)literals.get(value);
        _xblockexpression = _get.getName();
        return _xblockexpression;
    }

    public Enumeration searchEnumeration(String enumName) {
        Enumeration _xblockexpression = null;
        Enumeration enum_ = this.enumCache.get(enumName);
        if (enum_ == null) {
            Enumeration _head;
            List<Enumeration> _enumerations = UmlNavigation.getEnumerations(this.resourceManager);
            Functions.Function1 _function = it -> {
                String _name = it.getName();
                return enumName.startsWith(_name);
            };
            Iterable _filter = IterableExtensions.filter(_enumerations, (Functions.Function1)_function);
            enum_ = _head = (Enumeration)IterableExtensions.head((Iterable)_filter);
            this.enumCache.put(enumName, enum_);
        }
        _xblockexpression = enum_;
        return _xblockexpression;
    }

    @Data
    public static class TransitionInfo {
        private final String name;
        private final String sourceName;
        private final String targetName;
        private final int targetId;

        public TransitionInfo(String name, String sourceName, String targetName, int targetId) {
            this.name = name;
            this.sourceName = sourceName;
            this.targetName = targetName;
            this.targetId = targetId;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.sourceName == null ? 0 : this.sourceName.hashCode());
            result = 31 * result + (this.targetName == null ? 0 : this.targetName.hashCode());
            result = 31 * result + this.targetId;
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TransitionInfo other = (TransitionInfo)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.sourceName == null ? other.sourceName != null : !this.sourceName.equals(other.sourceName)) {
                return false;
            }
            if (this.targetName == null ? other.targetName != null : !this.targetName.equals(other.targetName)) {
                return false;
            }
            return other.targetId == this.targetId;
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("name", (Object)this.name);
            b.add("sourceName", (Object)this.sourceName);
            b.add("targetName", (Object)this.targetName);
            b.add("targetId", (Object)this.targetId);
            return b.toString();
        }

        @Pure
        public String getName() {
            return this.name;
        }

        @Pure
        public String getSourceName() {
            return this.sourceName;
        }

        @Pure
        public String getTargetName() {
            return this.targetName;
        }

        @Pure
        public int getTargetId() {
            return this.targetId;
        }
    }
}

