/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.metamodel;

import com.google.common.collect.Iterables;
import emi.serializer.metamodel.IStrategy;
import emi.serializer.metamodel.Metaclass;
import emi.serializer.metamodel.MetamodelTable;
import emi.serializer.serialization.propertyserializer.DefaultPropertySerializer;
import emi.serializer.serialization.propertyserializer.PropertySerializer;
import emi.serializer.serialization.uml.UmlModelSerializer;
import emi.serializer.utils.UmlSerializerExtensions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class MetamodelSerializer {
    private final MetamodelTable table;
    private final UmlModelSerializer modelSerializer;
    private final IStrategy strategy;

    public MetamodelSerializer(MetamodelTable table, IStrategy strategy) {
        UmlModelSerializer _umlModelSerializer;
        this.table = table;
        this.modelSerializer = _umlModelSerializer = new UmlModelSerializer();
        this.strategy = strategy;
    }

    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"#ifndef METAMODEL_UML_METAMODEL_H");
        _builder.newLine();
        _builder.append((Object)"#define METAMODEL_UML_METAMODEL_H");
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @file metamodel.h");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Define UML concepts of the metamodel.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* This file is automatically generated by the uml-serializer-c tool.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Do not modify manually.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author Matthias Brun (matthias.brun@eseo.fr)");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author Valentin Besnard (valentin.besnard@eseo.fr)");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"utilities/types.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"types_calibration.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"metamodel/c_uml.h\"");
        _builder.newLine();
        _builder.newLine();
        String _serializeHeaders = this.strategy.serializeHeaders();
        _builder.append((Object)_serializeHeaders, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _typedefToC = this.typedefToC();
        _builder.append((Object)_typedefToC, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _abstractTypeToC = this.abstractTypeToC();
        _builder.append((Object)_abstractTypeToC, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _typeToC = this.typeToC();
        _builder.append((Object)_typeToC, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#endif /* METAMODEL_UML_METAMODEL_H */");
        _builder.newLine();
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @file metamodel.c");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Define UML concepts of the metamodel.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* This file is automatically generated by the uml-serializer-c tool.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Do not modify manually.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author Matthias Brun (matthias.brun@eseo.fr)");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author Valentin Besnard (valentin.besnard@eseo.fr)");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.newLine();
        _builder.append((Object)"#include <stddef.h>");
        _builder.newLine();
        _builder.append((Object)"#include \"metamodel.h\"");
        _builder.newLine();
        _builder.newLine();
        String _serialize = this.strategy.serialize();
        _builder.append((Object)_serialize, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String typedefToC() {
        String _xblockexpression = null;
        Map<EClassifier, Metaclass> _metaclasses = this.table.getMetaclasses();
        Set<Map.Entry<EClassifier, Metaclass>> _entrySet = _metaclasses.entrySet();
        Functions.Function1 _function = it -> {
            EClassifier _key = (EClassifier)it.getKey();
            return _key instanceof EClass;
        };
        Iterable classes = IterableExtensions.filter(_entrySet, (Functions.Function1)_function);
        Map<EClassifier, Metaclass> _metaclasses_1 = this.table.getMetaclasses();
        Set<Map.Entry<EClassifier, Metaclass>> _entrySet_1 = _metaclasses_1.entrySet();
        Functions.Function1 _function_1 = it -> {
            EClassifier _key = (EClassifier)it.getKey();
            return _key instanceof EEnum;
        };
        Iterable enums = IterableExtensions.filter(_entrySet_1, (Functions.Function1)_function_1);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* All typedef of UML types.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        String _typedefToC = this.modelSerializer.typedefToC();
        _builder.append((Object)_typedefToC, "");
        _builder.newLineIfNotEmpty();
        Functions.Function1 _function_2 = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"typedef enum ");
            EClassifier _key = (EClassifier)it.getKey();
            String _typeName = UmlSerializerExtensions.typeName((EObject)_key);
            _builder_1.append((Object)_typeName, "");
            _builder_1.append((Object)" ");
            EClassifier _key_1 = (EClassifier)it.getKey();
            String _typeName_1 = UmlSerializerExtensions.typeName((EObject)_key_1);
            _builder_1.append((Object)_typeName_1, "");
            _builder_1.append((Object)";");
            return _builder_1.toString();
        };
        Iterable _map = IterableExtensions.map((Iterable)enums, (Functions.Function1)_function_2);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"\n");
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        Functions.Function1 _function_3 = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"typedef struct ");
            EClassifier _key = (EClassifier)it.getKey();
            String _typeName = UmlSerializerExtensions.typeName((EObject)_key);
            _builder_1.append((Object)_typeName, "");
            _builder_1.append((Object)" ");
            EClassifier _key_1 = (EClassifier)it.getKey();
            String _typeName_1 = UmlSerializerExtensions.typeName((EObject)_key_1);
            _builder_1.append((Object)_typeName_1, "");
            _builder_1.append((Object)";");
            return _builder_1.toString();
        };
        Iterable _map_1 = IterableExtensions.map((Iterable)classes, (Functions.Function1)_function_3);
        String _join_1 = IterableExtensions.join((Iterable)_map_1, (CharSequence)"\n");
        _builder.append((Object)_join_1, "");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String abstractTypeToC() {
        String _xblockexpression = null;
        Map<EClassifier, Metaclass> _metaclasses = this.table.getMetaclasses();
        Set<Map.Entry<EClassifier, Metaclass>> _entrySet = _metaclasses.entrySet();
        Functions.Function1 _function = it -> {
            EClassifier _key = (EClassifier)it.getKey();
            return _key instanceof EClass;
        };
        Iterable classes = IterableExtensions.filter(_entrySet, (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> {
            boolean _notEquals;
            String _xblockexpression_1 = null;
            EClassifier _key = (EClassifier)it.getKey();
            EClass eClass = (EClass)_key;
            ArrayList allAttributes = new ArrayList();
            Metaclass _value = (Metaclass)it.getValue();
            List<PropertySerializer> _properties = _value.getProperties();
            Functions.Function1 _function_2 = it_1 -> {
                StringConcatenation _builder = new StringConcatenation();
                CharSequence _type = it_1.type(eClass, null);
                _builder.append((Object)_type, "");
                return _builder.toString();
            };
            List _map = ListExtensions.map(_properties, (Functions.Function1)_function_2);
            allAttributes.addAll(_map);
            Metaclass _value_1 = (Metaclass)it.getValue();
            Map<String, PropertySerializer> _attributes = _value_1.getAttributes();
            Set<Map.Entry<String, PropertySerializer>> _entrySet_1 = _attributes.entrySet();
            Functions.Function1 _function_3 = it_1 -> {
                EClassifier _eType;
                EClassifier _type;
                String _xblockexpression_2 = null;
                String _key_1 = (String)it_1.getKey();
                EStructuralFeature feature = eClass.getEStructuralFeature(_key_1);
                EClassifier featureType = null;
                PropertySerializer serializer = (PropertySerializer)it_1.getValue();
                featureType = serializer instanceof DefaultPropertySerializer ? (_type = ((DefaultPropertySerializer)serializer).getType(feature)) : (_eType = feature.getEType());
                Map<EClassifier, Metaclass> _metaclasses_1 = this.table.getMetaclasses();
                Metaclass attributeMetaclass = _metaclasses_1.get(featureType);
                StringConcatenation _builder = new StringConcatenation();
                PropertySerializer _value_2 = (PropertySerializer)it_1.getValue();
                CharSequence _type_1 = _value_2.type(eClass, attributeMetaclass);
                _builder.append((Object)_type_1, "");
                _xblockexpression_2 = _builder.toString();
                return _xblockexpression_2;
            };
            Iterable _map_1 = IterableExtensions.map(_entrySet_1, (Functions.Function1)_function_3);
            Iterables.addAll(allAttributes, (Iterable)_map_1);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* Attributes defined for the class ");
            String _typeName = UmlSerializerExtensions.typeName((EObject)eClass);
            _builder.append((Object)_typeName, " ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"* This definition contains only own attributes of the class and not inherited attributes.");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"#define ABSTRACT_");
            String _typeName_1 = UmlSerializerExtensions.typeName((EObject)eClass);
            _builder.append((Object)_typeName_1, "");
            _builder.append((Object)" ");
            StringConcatenation _xifexpression = null;
            ArrayList _converted_allAttributes = allAttributes;
            int _length = ((Object[])Conversions.unwrapArray(_converted_allAttributes, Object.class)).length;
            boolean bl = _notEquals = _length != 0;
            if (_notEquals) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)"\\");
                _xifexpression = _builder_1;
            }
            _builder.append(_xifexpression, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            String _join = IterableExtensions.join(allAttributes, (CharSequence)" \\\n");
            _builder.append((Object)_join, "\t");
            _builder.newLineIfNotEmpty();
            _xblockexpression_1 = _builder.toString();
            return _xblockexpression_1;
        };
        Iterable _map = IterableExtensions.map((Iterable)classes, (Functions.Function1)_function_1);
        _xblockexpression = IterableExtensions.join((Iterable)_map, (CharSequence)"");
        return _xblockexpression;
    }

    private String typeToC() {
        String _xblockexpression = null;
        Map<EClassifier, Metaclass> _metaclasses = this.table.getMetaclasses();
        Set<Map.Entry<EClassifier, Metaclass>> _entrySet = _metaclasses.entrySet();
        Functions.Function1 _function = it -> {
            EClassifier _key = (EClassifier)it.getKey();
            return _key instanceof EClass;
        };
        Iterable classes = IterableExtensions.filter(_entrySet, (Functions.Function1)_function);
        Map<EClassifier, Metaclass> _metaclasses_1 = this.table.getMetaclasses();
        Set<Map.Entry<EClassifier, Metaclass>> _entrySet_1 = _metaclasses_1.entrySet();
        Functions.Function1 _function_1 = it -> {
            EClassifier _key = (EClassifier)it.getKey();
            return _key instanceof EEnum;
        };
        Iterable enums = IterableExtensions.filter(_entrySet_1, (Functions.Function1)_function_1);
        String modelString = this.modelSerializer.typeToC();
        Functions.Function1 _function_2 = it -> {
            String _xblockexpression_1 = null;
            EClassifier _key = (EClassifier)it.getKey();
            EEnum enum_ = (EEnum)_key;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* Definition of the enum ");
            String _typeName = UmlSerializerExtensions.typeName((EObject)enum_);
            _builder.append((Object)_typeName, " ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"enum ");
            String _typeName_1 = UmlSerializerExtensions.typeName((EObject)enum_);
            _builder.append((Object)_typeName_1, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            EList _eLiterals = enum_.getELiterals();
            Functions.Function1 _function_3 = it_1 -> {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)"UML_");
                String _name = it_1.getName();
                String _upperCase = _name.toUpperCase();
                _builder_1.append((Object)_upperCase, "");
                return _builder_1.toString();
            };
            List _map = ListExtensions.map((List)_eLiterals, (Functions.Function1)_function_3);
            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)",\n");
            _builder.append((Object)_join, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"};");
            _builder.newLine();
            _xblockexpression_1 = _builder.toString();
            return _xblockexpression_1;
        };
        Iterable _map = IterableExtensions.map((Iterable)enums, (Functions.Function1)_function_2);
        String enumString = IterableExtensions.join((Iterable)_map, (CharSequence)"");
        Functions.Function1 _function_3 = it -> {
            String _xblockexpression_1 = null;
            EClassifier _key = (EClassifier)it.getKey();
            EClass eClass = (EClass)_key;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* Definition of the type ");
            String _typeName = UmlSerializerExtensions.typeName((EObject)eClass);
            _builder.append((Object)_typeName, " ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"* This structure contains own attributes of the class and inherited attributes.");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"struct ");
            String _typeName_1 = UmlSerializerExtensions.typeName((EObject)eClass);
            _builder.append((Object)_typeName_1, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            Metaclass _value = (Metaclass)it.getValue();
            String _addFieldsTypes = this.strategy.addFieldsTypes(_value);
            _builder.append((Object)_addFieldsTypes, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            Metaclass _value_1 = (Metaclass)it.getValue();
            Set<EClass> _superclasses = _value_1.getSuperclasses();
            Functions.Function1 _function_4 = it_1 -> {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)"ABSTRACT_");
                String _typeName_2 = UmlSerializerExtensions.typeName((EObject)it_1);
                _builder_1.append((Object)_typeName_2, "");
                return _builder_1.toString();
            };
            Iterable _map_1 = IterableExtensions.map(_superclasses, (Functions.Function1)_function_4);
            String _join = IterableExtensions.join((Iterable)_map_1, (CharSequence)"\n");
            _builder.append((Object)_join, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"ABSTRACT_");
            String _typeName_2 = UmlSerializerExtensions.typeName((EObject)eClass);
            _builder.append((Object)_typeName_2, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"};");
            _builder.newLine();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* Definition of a variable of type ");
            String _typeName_3 = UmlSerializerExtensions.typeName((EObject)eClass);
            _builder.append((Object)_typeName_3, " ");
            _builder.append((Object)" with default value.");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"#define C_");
            String _typeName_4 = UmlSerializerExtensions.typeName((EObject)eClass);
            String _upperCase = _typeName_4.toUpperCase();
            _builder.append((Object)_upperCase, " ");
            _builder.append((Object)"_NULL  {");
            String _addFieldsInitializers = this.strategy.addFieldsInitializers(eClass);
            _builder.append((Object)_addFieldsInitializers, " ");
            _builder.append((Object)" ");
            Metaclass _value_2 = (Metaclass)it.getValue();
            List<PropertySerializer> _allAttributesSerializer = this.table.getAllAttributesSerializer(_value_2);
            Functions.Function1 _function_5 = it_1 -> {
                StringConcatenation _builder_1 = new StringConcatenation();
                CharSequence _defaultValue = it_1.defaultValue(eClass);
                _builder_1.append((Object)_defaultValue, "");
                return _builder_1.toString();
            };
            List _map_2 = ListExtensions.map(_allAttributesSerializer, (Functions.Function1)_function_5);
            String _join_1 = IterableExtensions.join((Iterable)_map_2, (CharSequence)",");
            _builder.append((Object)_join_1, " ");
            _builder.append((Object)" }");
            _builder.newLineIfNotEmpty();
            _xblockexpression_1 = _builder.toString();
            return _xblockexpression_1;
        };
        Iterable _map_1 = IterableExtensions.map((Iterable)classes, (Functions.Function1)_function_3);
        String classesString = IterableExtensions.join((Iterable)_map_1, (CharSequence)"");
        _xblockexpression = modelString + enumString + classesString;
        return _xblockexpression;
    }
}

