/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.memoryobjects;

import com.google.common.base.Objects;
import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlNavigation;
import emi.serializer.utils.UmlSerializerExtensions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class OperationParameters {
    private final List<Operation> operations;

    public OperationParameters(ResourceManager rm) {
        ArrayList<Operation> _arrayList = new ArrayList<Operation>();
        this.operations = _arrayList;
        List<Operation> _operations = UmlNavigation.getOperations(rm);
        Consumer<Operation> _function = it -> {
            boolean _tripleEquals;
            Operation current = it;
            Functions.Function1 _function_1 = it_1 -> {
                String _name = it_1.getName();
                String _name_1 = current.getName();
                return Objects.equal((Object)_name, (Object)_name_1);
            };
            Operation _findFirst = (Operation)IterableExtensions.findFirst(this.operations, (Functions.Function1)_function_1);
            boolean bl = _tripleEquals = _findFirst == null;
            if (_tripleEquals) {
                this.operations.add(current);
            }
        };
        _operations.forEach(_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"OPERATIONS ");
        Functions.Function1 _function_1 = it -> it.getName();
        List _map = ListExtensions.map(this.operations, (Functions.Function1)_function_1);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)", ");
        _builder.append((Object)_join, "");
        InputOutput.println((Object)_builder.toString());
    }

    public static String getOperationParametersStructName(Operation e) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_operation_parameters");
        return _builder.toString();
    }

    public static Parameter getReturnParameter(Operation e) {
        EList _ownedParameters = e.getOwnedParameters();
        Functions.Function1 _function = it -> {
            ParameterDirectionKind _direction = it.getDirection();
            return Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
        };
        return (Parameter)IterableExtensions.findFirst((Iterable)_ownedParameters, (Functions.Function1)_function);
    }

    private String typedefToC(Operation e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"typedef struct ");
        String _operationParametersStructName = OperationParameters.getOperationParametersStructName(e);
        _builder.append((Object)_operationParametersStructName, "");
        _builder.append((Object)" ");
        String _operationParametersStructName_1 = OperationParameters.getOperationParametersStructName(e);
        _builder.append((Object)_operationParametersStructName_1, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String typeToC(Operation e) {
        String _xblockexpression = null;
        EList _ownedParameters = e.getOwnedParameters();
        Functions.Function1 _function = it -> {
            ParameterDirectionKind _direction = it.getDirection();
            return !Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
        };
        Iterable params = IterableExtensions.filter((Iterable)_ownedParameters, (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Type ");
        String _operationParametersStructName = OperationParameters.getOperationParametersStructName(e);
        _builder.append((Object)_operationParametersStructName, " ");
        _builder.append((Object)" corresponding to parameters of the operation ");
        String _name = e.getName();
        _builder.append((Object)_name, " ");
        _builder.append((Object)".");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"struct ");
        String _operationParametersStructName_1 = OperationParameters.getOperationParametersStructName(e);
        _builder.append((Object)_operationParametersStructName_1, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        Functions.Function1 _function_1 = it -> this.subfieldTypeToC((Parameter)it);
        Iterable _map = IterableExtensions.map((Iterable)params, (Functions.Function1)_function_1);
        String _join = IterableExtensions.join((Iterable)_map);
        _builder.append((Object)_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"};");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String loadMacro(Operation e) {
        boolean _equals;
        String _xblockexpression = null;
        EList _ownedParameters = e.getOwnedParameters();
        Functions.Function1 _function = it -> {
            ParameterDirectionKind _direction = it.getDirection();
            return !Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
        };
        Iterable params = IterableExtensions.filter((Iterable)_ownedParameters, (Functions.Function1)_function);
        String _xifexpression = null;
        int _length = ((Object[])Conversions.unwrapArray((Object)params, Object.class)).length;
        boolean bl = _equals = _length == 0;
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"...");
            _xifexpression = _builder.toString();
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            Functions.Function1 _function_1 = it -> {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append((Object)"p");
                String _name = it.getName();
                _builder_2.append((Object)_name, "");
                return _builder_2.toString();
            };
            Iterable _map = IterableExtensions.map((Iterable)params, (Functions.Function1)_function_1);
            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)", ");
            _builder_1.append((Object)_join, "");
            _builder_1.append((Object)", ...");
            _xifexpression = _builder_1.toString();
        }
        String macroParams = _xifexpression;
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append((Object)"#define LOAD_");
        String _name = e.getName();
        _builder_2.append((Object)_name, "");
        _builder_2.append((Object)"(__op_params, ");
        _builder_2.append((Object)macroParams, "");
        _builder_2.append((Object)") \t\t");
        Functions.Function1 _function_2 = it -> this.loadParameter((Parameter)it);
        Iterable _map_1 = IterableExtensions.map((Iterable)params, (Functions.Function1)_function_2);
        String _join_1 = IterableExtensions.join((Iterable)_map_1, (CharSequence)" \\\n\t");
        _builder_2.append((Object)_join_1, "");
        _builder_2.newLineIfNotEmpty();
        _xblockexpression = _builder_2.toString();
        return _xblockexpression;
    }

    private String loadParameter(Parameter p) {
        StringConcatenation _builder = new StringConcatenation();
        StringConcatenation _xifexpression = null;
        if (Objects.equal((Object)p.getDirection(), (Object)ParameterDirectionKind.IN_LITERAL) || Objects.equal((Object)p.getDirection(), (Object)ParameterDirectionKind.INOUT_LITERAL)) {
            boolean _equals;
            StringConcatenation _xifexpression_1 = null;
            int _lower = p.getLower();
            boolean bl = _equals = _lower == 1;
            if (_equals) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)"__op_params.");
                String _name = p.getName();
                _builder_1.append((Object)_name, "");
                _builder_1.append((Object)" = p");
                String _name_1 = p.getName();
                _builder_1.append((Object)_name_1, "");
                _builder_1.append((Object)";");
                _xifexpression_1 = _builder_1;
            } else {
                StringConcatenation _builder_2 = new StringConcatenation();
                int _lower_1 = p.getLower();
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _lower_1, true);
                Functions.Function1 _function = it -> {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append((Object)"__op_params.");
                    String _name_2 = p.getName();
                    _builder_3.append((Object)_name_2, "");
                    _builder_3.append((Object)"[");
                    _builder_3.append(it, "");
                    _builder_3.append((Object)"] = p");
                    String _name_3 = p.getName();
                    _builder_3.append((Object)_name_3, "");
                    _builder_3.append((Object)"[");
                    _builder_3.append(it, "");
                    _builder_3.append((Object)"];");
                    return _builder_3.toString();
                };
                Iterable _map = IterableExtensions.map((Iterable)_doubleDotLessThan, (Functions.Function1)_function);
                String _join = IterableExtensions.join((Iterable)_map, (CharSequence)" \\\n\t");
                _builder_2.append((Object)_join, "");
                _xifexpression_1 = _builder_2;
            }
            _xifexpression = _xifexpression_1;
        } else {
            boolean _equals_1;
            StringConcatenation _xifexpression_2 = null;
            int _lower_2 = p.getLower();
            boolean bl = _equals_1 = _lower_2 == 1;
            if (_equals_1) {
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append((Object)"__op_params.");
                String _name_2 = p.getName();
                _builder_3.append((Object)_name_2, "");
                _builder_3.append((Object)" = 0;");
                _xifexpression_2 = _builder_3;
            } else {
                StringConcatenation _builder_4 = new StringConcatenation();
                int _lower_3 = p.getLower();
                ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _lower_3, true);
                Functions.Function1 _function_1 = it -> {
                    StringConcatenation _builder_5 = new StringConcatenation();
                    _builder_5.append((Object)"__op_params.");
                    String _name_3 = p.getName();
                    _builder_5.append((Object)_name_3, "");
                    _builder_5.append((Object)"[");
                    _builder_5.append(it, "");
                    _builder_5.append((Object)"] = 0;");
                    return _builder_5.toString();
                };
                Iterable _map_1 = IterableExtensions.map((Iterable)_doubleDotLessThan_1, (Functions.Function1)_function_1);
                String _join_1 = IterableExtensions.join((Iterable)_map_1, (CharSequence)" \\\n\t");
                _builder_4.append((Object)_join_1, "");
                _xifexpression_2 = _builder_4;
            }
            _xifexpression = _xifexpression_2;
        }
        _builder.append((Object)_xifexpression, "");
        return _builder.toString();
    }

    private String unloadMacro(Operation e) {
        boolean _equals;
        String _xblockexpression = null;
        EList _ownedParameters = e.getOwnedParameters();
        Functions.Function1 _function = it -> {
            ParameterDirectionKind _direction = it.getDirection();
            return !Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
        };
        Iterable params = IterableExtensions.filter((Iterable)_ownedParameters, (Functions.Function1)_function);
        EList _ownedParameters_1 = e.getOwnedParameters();
        Functions.Function1 _function_1 = it -> Objects.equal((Object)it.getDirection(), (Object)ParameterDirectionKind.OUT_LITERAL) || Objects.equal((Object)it.getDirection(), (Object)ParameterDirectionKind.INOUT_LITERAL);
        Iterable outParams = IterableExtensions.filter((Iterable)_ownedParameters_1, (Functions.Function1)_function_1);
        String _xifexpression = null;
        int _length = ((Object[])Conversions.unwrapArray((Object)params, Object.class)).length;
        boolean bl = _equals = _length == 0;
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"...");
            _xifexpression = _builder.toString();
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            Functions.Function1 _function_2 = it -> {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append((Object)"p");
                String _name = it.getName();
                _builder_2.append((Object)_name, "");
                return _builder_2.toString();
            };
            Iterable _map = IterableExtensions.map((Iterable)params, (Functions.Function1)_function_2);
            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)", ");
            _builder_1.append((Object)_join, "");
            _builder_1.append((Object)", ...");
            _xifexpression = _builder_1.toString();
        }
        String macroParams = _xifexpression;
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append((Object)"#define UNLOAD_");
        String _name = e.getName();
        _builder_2.append((Object)_name, "");
        _builder_2.append((Object)"(__op_params, ");
        _builder_2.append((Object)macroParams, "");
        _builder_2.append((Object)") \t\t");
        Functions.Function1 _function_3 = it -> this.unloadParameter((Parameter)it);
        Iterable _map_1 = IterableExtensions.map((Iterable)outParams, (Functions.Function1)_function_3);
        String _join_1 = IterableExtensions.join((Iterable)_map_1, (CharSequence)" \\\n\t");
        _builder_2.append((Object)_join_1, "");
        _builder_2.newLineIfNotEmpty();
        _xblockexpression = _builder_2.toString();
        return _xblockexpression;
    }

    private String unloadParameter(Parameter p) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        StringConcatenation _xifexpression = null;
        int _lower = p.getLower();
        boolean bl = _equals = _lower == 1;
        if (_equals) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"p");
            String _name = p.getName();
            _builder_1.append((Object)_name, "");
            _builder_1.append((Object)" = __op_params.");
            String _name_1 = p.getName();
            _builder_1.append((Object)_name_1, "");
            _builder_1.append((Object)";");
            _xifexpression = _builder_1;
        } else {
            StringConcatenation _builder_2 = new StringConcatenation();
            int _lower_1 = p.getLower();
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _lower_1, true);
            Functions.Function1 _function = it -> {
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append((Object)"p");
                String _name_2 = p.getName();
                _builder_3.append((Object)_name_2, "");
                _builder_3.append((Object)"[");
                _builder_3.append(it, "");
                _builder_3.append((Object)"] = __op_params.");
                String _name_3 = p.getName();
                _builder_3.append((Object)_name_3, "");
                _builder_3.append((Object)"[");
                _builder_3.append(it, "");
                _builder_3.append((Object)"];");
                return _builder_3.toString();
            };
            Iterable _map = IterableExtensions.map((Iterable)_doubleDotLessThan, (Functions.Function1)_function);
            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)" \\\n\t");
            _builder_2.append((Object)_join, "");
            _xifexpression = _builder_2;
        }
        _builder.append((Object)_xifexpression, "");
        return _builder.toString();
    }

    private String subfieldTypeToC(Parameter e) {
        boolean _notEquals;
        String _xblockexpression = null;
        Type _type = e.getType();
        String typeName = UmlSerializerExtensions.typeNameToC(_type);
        StringConcatenation _builder = new StringConcatenation();
        StringConcatenation _xifexpression = null;
        int _lower = e.getLower();
        boolean bl = _notEquals = _lower != 1;
        if (_notEquals) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)typeName, "");
            _builder_1.append((Object)" ");
            String _name = e.getName();
            _builder_1.append((Object)_name, "");
            _builder_1.append((Object)"[");
            int _lower_1 = e.getLower();
            _builder_1.append((Object)_lower_1, "");
            _builder_1.append((Object)"];");
            _xifexpression = _builder_1;
        } else {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append((Object)typeName, "");
            _builder_2.append((Object)" ");
            String _name_1 = e.getName();
            _builder_2.append((Object)_name_1, "");
            _builder_2.append((Object)";");
            _xifexpression = _builder_2;
        }
        _builder.append((Object)_xifexpression, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String serializeHeadersTypedef() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Typedef for operation parameters.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.typedefToC((Operation)it);
        List _map = ListExtensions.map(this.operations, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map);
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Declarations of load macros for operations.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Functions.Function1 _function = it -> this.loadMacro((Operation)it);
        List _map = ListExtensions.map(this.operations, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map);
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Declarations of unload macros for operations.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> this.unloadMacro((Operation)it);
        List _map_1 = ListExtensions.map(this.operations, (Functions.Function1)_function_1);
        String _join_1 = IterableExtensions.join((Iterable)_map_1);
        _builder.append((Object)_join_1, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Declarations of types for operation parameters.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        Functions.Function1 _function_2 = it -> this.typeToC((Operation)it);
        List _map_2 = ListExtensions.map(this.operations, (Functions.Function1)_function_2);
        String _join_2 = IterableExtensions.join((Iterable)_map_2);
        _builder.append((Object)_join_2, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String serialize() {
        return "";
    }
}

