/*
 * Decompiled with CFR 0.152.
 */
package plug.language.emi.analysis;

import emi.analysis.client.EMISynchronousClient;
import emi.analysis.exception.EMIException;
import emi.analysis.exception.EMIRuntimeException;
import emi.analysis.model.EMIAtom;
import emi.analysis.model.EMIFireableTransitionComposite;
import plug.core.IAtomicPropositionsEvaluator;
import plug.language.emi.analysis.EMIIntermediateAtom;
import plug.language.emi.model.PlugRuntimeConfiguration;

public class EMIAtomicPropositionEvaluator
implements IAtomicPropositionsEvaluator<PlugRuntimeConfiguration, EMIFireableTransitionComposite> {
    private EMISynchronousClient client;
    private EMIAtom[] atoms;
    private EMIIntermediateAtom[] iatoms;
    private boolean processing;
    private boolean checkSideEffect;
    private boolean displaySideEffect;

    public EMIAtomicPropositionEvaluator(EMISynchronousClient client, boolean checkSideEffect) {
        this.client = client;
        this.atoms = new EMIAtom[0];
        this.iatoms = null;
        this.processing = false;
        this.checkSideEffect = checkSideEffect;
    }

    public int[] registerAtomicPropositions(String[] strings) {
        int nbAtoms = strings.length;
        int[] ids = new int[nbAtoms];
        this.atoms = new EMIAtom[nbAtoms];
        this.iatoms = new EMIIntermediateAtom[nbAtoms];
        this.processing = false;
        this.displaySideEffect = true;
        for (int i = 0; i < strings.length; ++i) {
            try {
                this.atoms[i] = new EMIAtom(strings[i]);
                this.iatoms[i] = new EMIIntermediateAtom(this.atoms[i]);
            }
            catch (EMIException e) {
                e.printStackTrace();
            }
            ids[i] = i;
            if (!this.iatoms[i].hasIntermediateAtoms()) continue;
            this.processing = true;
        }
        return ids;
    }

    public boolean[] getAtomicPropositionValuations(PlugRuntimeConfiguration source, EMIFireableTransitionComposite fireable, Object payload, PlugRuntimeConfiguration target) {
        EMIAtom[] atoms = (EMIAtom[])this.atoms.clone();
        if (this.processing) {
            try {
                this.client.setConfiguration(target.getEMIConfiguration());
            }
            catch (EMIException e) {
                e.printStackTrace();
                throw new EMIRuntimeException(e.getMessage());
            }
            EMIIntermediateAtom iatom = null;
            for (int i = 0; i < this.iatoms.length; ++i) {
                iatom = this.iatoms[i];
                this.getAtomicPropositionValuations(iatom.getIntermediateAtoms());
                iatom.setValues(this.getAtomicPropositionValuations(iatom.getIntermediateAtoms()));
                try {
                    atoms[i] = new EMIAtom(iatom.replaceIntermediateAtoms());
                    continue;
                }
                catch (EMIException e) {
                    e.printStackTrace();
                    throw new EMIRuntimeException(e.getMessage());
                }
            }
        }
        return this.getAtomicPropositionValuations(source);
    }

    public boolean[] getAtomicPropositionValuations(PlugRuntimeConfiguration source) {
        try {
            this.client.setConfiguration(source.getEMIConfiguration());
        }
        catch (EMIException e) {
            e.printStackTrace();
            throw new EMIRuntimeException(e.getMessage());
        }
        boolean[] valuations = EMIAtomicPropositionEvaluator.atomsValuationstoBoolean(this.getAtomicPropositionValuations(this.atoms));
        if (this.checkSideEffect) {
            this.checkAtomsSideEffect(source);
        }
        return valuations;
    }

    private int[] getAtomicPropositionValuations(EMIAtom[] atoms) {
        if (atoms == null) {
            return new int[0];
        }
        int[] results = null;
        try {
            results = this.client.evaluateAtoms(atoms);
        }
        catch (EMIException e) {
            e.printStackTrace();
            throw new EMIRuntimeException(e.getMessage());
        }
        return results;
    }

    private static boolean[] atomsValuationstoBoolean(int[] valuations) {
        boolean[] results = new boolean[valuations.length];
        for (int i = 0; i < valuations.length; ++i) {
            results[i] = valuations[i] != 0;
        }
        return results;
    }

    private void checkAtomsSideEffect(PlugRuntimeConfiguration source) {
        try {
            if (this.displaySideEffect && !source.getEMIConfiguration().equals((Object)this.client.getConfiguration())) {
                this.displaySideEffect = false;
                System.err.println("\u001b[31mERROR: At least one atomic proposition has side effect.\u001b[0m");
                throw new EMIRuntimeException("At least one atomic proposition has side effect.");
            }
        }
        catch (EMIException e) {
            e.printStackTrace();
            throw new EMIRuntimeException(e.getMessage());
        }
    }
}

