/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.serialization.uml;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import emi.serializer.model.ResourceManager;
import emi.serializer.utils.UmlSerializerExtensions;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class UmlModelSerializer {
    private final List<Model> models;

    public UmlModelSerializer(ResourceManager rm) {
        Function<Resource, List> _function = it -> {
            TreeIterator _allContents = it.getAllContents();
            UnmodifiableIterator _filter = Iterators.filter((Iterator)_allContents, Model.class);
            return IteratorExtensions.toList((Iterator)_filter);
        };
        List _list = rm.getList(_function);
        this.models = _list;
    }

    public UmlModelSerializer() {
        this.models = null;
    }

    private String toC(Model e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"static UML_SignalEvent * ");
        String _variableName = UmlSerializerExtensions.variableName((EObject)e);
        _builder.append((Object)_variableName, "");
        _builder.append((Object)"_event[] = {");
        TreeIterator _eAllContents = e.eAllContents();
        UnmodifiableIterator _filter = Iterators.filter((Iterator)_eAllContents, SignalEvent.class);
        List _list = IteratorExtensions.toList((Iterator)_filter);
        CharSequence _c = UmlSerializerExtensions.toC(_list);
        _builder.append((Object)_c, "");
        _builder.append((Object)"};");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"static UML_Class * ");
        String _variableName_1 = UmlSerializerExtensions.variableName((EObject)e);
        _builder.append((Object)_variableName_1, "");
        _builder.append((Object)"_class[] = {");
        TreeIterator _eAllContents_1 = e.eAllContents();
        UnmodifiableIterator _filter_1 = Iterators.filter((Iterator)_eAllContents_1, Class.class);
        Functions.Function1 _function = it -> {
            EClass _eClass = it.eClass();
            EClass _class_ = UMLPackage.eINSTANCE.getClass_();
            return Objects.equal((Object)_eClass, (Object)_class_);
        };
        Iterator _filter_2 = IteratorExtensions.filter((Iterator)_filter_1, (Functions.Function1)_function);
        List _list_1 = IteratorExtensions.toList((Iterator)_filter_2);
        CharSequence _c_1 = UmlSerializerExtensions.toC(_list_1);
        _builder.append((Object)_c_1, "");
        _builder.append((Object)"};");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"static UML_Association * ");
        String _variableName_2 = UmlSerializerExtensions.variableName((EObject)e);
        _builder.append((Object)_variableName_2, "");
        _builder.append((Object)"_association[] = {");
        TreeIterator _eAllContents_2 = e.eAllContents();
        UnmodifiableIterator _filter_3 = Iterators.filter((Iterator)_eAllContents_2, Association.class);
        List _list_2 = IteratorExtensions.toList((Iterator)_filter_3);
        CharSequence _c_2 = UmlSerializerExtensions.toC(_list_2);
        _builder.append((Object)_c_2, "");
        _builder.append((Object)"};");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"C_UML_Model ");
        String _variableName_3 = UmlSerializerExtensions.variableName((EObject)e);
        _builder.append((Object)_variableName_3, "");
        _builder.append((Object)" = {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)".name = ");
        String _name = e.getName();
        String _cString = UmlSerializerExtensions.toCString(_name);
        _builder.append((Object)_cString, "\t");
        _builder.append((Object)",");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)".uml_signal_event = ");
        String _variableName_4 = UmlSerializerExtensions.variableName((EObject)e);
        _builder.append((Object)_variableName_4, "\t");
        _builder.append((Object)"_event,");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)".uml_class = ");
        String _variableName_5 = UmlSerializerExtensions.variableName((EObject)e);
        _builder.append((Object)_variableName_5, "\t");
        _builder.append((Object)"_class,");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)".uml_association = ");
        String _variableName_6 = UmlSerializerExtensions.variableName((EObject)e);
        _builder.append((Object)_variableName_6, "\t");
        _builder.append((Object)"_association");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"};");
        _builder.newLine();
        return _builder.toString();
    }

    public String typedefToC() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"typedef struct C_UML_Model C_UML_Model;");
        _builder.newLine();
        return _builder.toString();
    }

    public String typeToC() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"struct C_UML_Model {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"char * name;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"UML_Signal ** uml_signal;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"UML_SignalEvent ** uml_signal_event;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"UML_Class ** uml_class; ");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"UML_Association ** uml_association;");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        return _builder.toString();
    }

    public String serializeHeaders() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"#define NB_MODEL_PARTS\t(");
        int _length = ((Object[])Conversions.unwrapArray(this.models, Object.class)).length;
        _builder.append((Object)_length, "");
        _builder.append((Object)")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"extern C_UML_Model * model_to_interpret[NB_MODEL_PARTS];");
        _builder.newLine();
        return _builder.toString();
    }

    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> this.toC((Model)it);
        List _map = ListExtensions.map(this.models, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"\n");
        _builder.append((Object)_join, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"C_UML_Model * model_to_interpret[NB_MODEL_PARTS] = {");
        _builder.newLine();
        _builder.append((Object)"\t");
        Functions.Function1 _function_1 = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"&");
            String _variableName = UmlSerializerExtensions.variableName((EObject)it);
            _builder_1.append((Object)_variableName, "");
            return _builder_1.toString();
        };
        List _map_1 = ListExtensions.map(this.models, (Functions.Function1)_function_1);
        String _join_1 = IterableExtensions.join((Iterable)_map_1, (CharSequence)",\n");
        _builder.append((Object)_join_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"};");
        _builder.newLine();
        return _builder.toString();
    }
}

