/*
 * Decompiled with CFR 0.152.
 */
package emi.serializer.serialization.propertyserializer;

import com.google.common.base.Objects;
import emi.serializer.metamodel.IStrategy;
import emi.serializer.metamodel.Metaclass;
import emi.serializer.metamodel.MetamodelTable;
import emi.serializer.serialization.propertyserializer.PropertySerializer;
import emi.serializer.utils.UmlSerializerExtensions;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class DefaultPropertySerializer
extends PropertySerializer {
    private final String propertyName;
    private final EClassifier simplifiedPropertyType;

    public EClassifier getType(EStructuralFeature property) {
        EClassifier _xifexpression = null;
        _xifexpression = this.simplifiedPropertyType != null ? this.simplifiedPropertyType : property.getEType();
        return _xifexpression;
    }

    private CharSequence getTypeName(EStructuralFeature property) {
        StringConcatenation _xblockexpression = null;
        EClassifier propertyType = this.getType(property);
        Object _xifexpression = null;
        if (propertyType instanceof EDataType) {
            String _name;
            String _switchResult = null;
            EClassifier _eType = property.getEType();
            switch (_name = _eType.getName()) {
                case "String": {
                    _switchResult = "char";
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            _xifexpression = _switchResult;
        } else {
            StringConcatenation _builder = new StringConcatenation();
            String _typeName = UmlSerializerExtensions.typeName((EObject)propertyType);
            _builder.append((Object)_typeName, "");
            _xifexpression = _builder;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    public CharSequence before(EObject e, MetamodelTable table, IStrategy strategy) {
        String _xblockexpression = null;
        EClass _eClass = e.eClass();
        EStructuralFeature property = _eClass.getEStructuralFeature(this.propertyName);
        EClassifier propertyType = this.getType(property);
        String _xifexpression = null;
        boolean _isMany = property.isMany();
        if (_isMany) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"static ");
            CharSequence _typeName = this.getTypeName(property);
            _builder.append((Object)_typeName, "");
            _builder.append((Object)" * ");
            String _variableName = UmlSerializerExtensions.variableName(e);
            _builder.append((Object)_variableName, "");
            _builder.append((Object)"_");
            String _name = property.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)"[] = {");
            Object _eGet = e.eGet(property);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"(");
            String _typeName_1 = UmlSerializerExtensions.typeName((EObject)propertyType);
            _builder_1.append((Object)_typeName_1, "");
            _builder_1.append((Object)"*)");
            CharSequence _c = UmlSerializerExtensions.toC((Iterable)_eGet, _builder_1.toString());
            _builder.append((Object)_c, "");
            _builder.append((Object)"};");
            _builder.newLineIfNotEmpty();
            _xifexpression = _builder;
        } else {
            _xifexpression = "";
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    public CharSequence inside(EObject e, MetamodelTable table, IStrategy strategy, boolean inline) {
        StringConcatenation _xblockexpression = null;
        EClass _eClass = e.eClass();
        EStructuralFeature property = _eClass.getEStructuralFeature(this.propertyName);
        EClassifier propertyType = this.getType(property);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)".");
        String _name = property.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" = ");
        CharSequence _xifexpression = null;
        boolean _isMany = property.isMany();
        if (_isMany) {
            StringConcatenation _xifexpression_1 = null;
            if (inline) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)"(");
                CharSequence _typeName = this.getTypeName(property);
                _builder_1.append((Object)_typeName, "");
                _builder_1.append((Object)" * []) {");
                Object _eGet = e.eGet(property);
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append((Object)"(");
                String _typeName_1 = UmlSerializerExtensions.typeName((EObject)propertyType);
                _builder_2.append((Object)_typeName_1, "");
                _builder_2.append((Object)"*)");
                CharSequence _c = UmlSerializerExtensions.toC((Iterable)_eGet, _builder_2.toString());
                _builder_1.append((Object)_c, "");
                _builder_1.append((Object)"}");
                _xifexpression_1 = _builder_1;
            } else {
                StringConcatenation _builder_3 = new StringConcatenation();
                String _variableName = UmlSerializerExtensions.variableName(e);
                _builder_3.append((Object)_variableName, "");
                _builder_3.append((Object)"_");
                String _name_1 = property.getName();
                _builder_3.append((Object)_name_1, "");
                _xifexpression_1 = _builder_3;
            }
            _xifexpression = _xifexpression_1;
        } else {
            CharSequence _xifexpression_2 = null;
            if (propertyType instanceof EClass) {
                String _xblockexpression_1 = null;
                Object _eGet_1 = e.eGet(property);
                EObject v = (EObject)_eGet_1;
                String _xifexpression_3 = null;
                if (v != null && !Objects.equal((Object)v.eClass(), (Object)propertyType)) {
                    StringConcatenation _builder_4 = new StringConcatenation();
                    _builder_4.append((Object)"(");
                    String _typeName_2 = UmlSerializerExtensions.typeName((EObject)propertyType);
                    _builder_4.append((Object)_typeName_2, "");
                    _builder_4.append((Object)"*)");
                    _xifexpression_3 = _builder_4.toString();
                } else {
                    _xifexpression_3 = "";
                }
                _xblockexpression_1 = UmlSerializerExtensions.variableRef(v, _xifexpression_3);
                _xifexpression_2 = _xblockexpression_1;
            } else {
                CharSequence _xifexpression_3 = null;
                Class _instanceClass = propertyType.getInstanceClass();
                boolean _equals = Objects.equal((Object)_instanceClass, String.class);
                if (_equals) {
                    Object _eGet_1 = e.eGet(property);
                    _xifexpression_3 = UmlSerializerExtensions.toCString((String)_eGet_1);
                } else {
                    Object _eGet_2 = e.eGet(property);
                    _xifexpression_3 = UmlSerializerExtensions.dataToC(_eGet_2);
                }
                _xifexpression_2 = _xifexpression_3;
            }
            _xifexpression = _xifexpression_2;
        }
        _builder.append((Object)_xifexpression, "");
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    @Override
    public CharSequence type(EClass e, Metaclass attributeMetaclass) {
        StringConcatenation _xblockexpression = null;
        EStructuralFeature property = e.getEStructuralFeature(this.propertyName);
        EClassifier propertyType = this.getType(property);
        String propertyTypeName = new String();
        boolean needSpace = true;
        if (propertyType instanceof EClass || propertyType instanceof EEnum) {
            String _typeName;
            propertyTypeName = _typeName = UmlSerializerExtensions.typeName((EObject)propertyType);
            if (propertyType instanceof EClass && !attributeMetaclass.isOnlyInline()) {
                String _concat;
                propertyTypeName = _concat = propertyTypeName.concat(" *");
                needSpace = false;
            }
        } else {
            Class _instanceClass = propertyType.getInstanceClass();
            boolean _equals = Objects.equal((Object)_instanceClass, String.class);
            if (_equals) {
                propertyTypeName = "char *";
                needSpace = false;
            } else {
                String _name;
                Class _instanceClass_2;
                boolean _equals_2;
                Class _instanceClass_1 = propertyType.getInstanceClass();
                boolean _equals_1 = Objects.equal((Object)_instanceClass_1, Boolean.TYPE);
                propertyTypeName = _equals_1 ? "bool" : ((_equals_2 = Objects.equal((Object)(_instanceClass_2 = propertyType.getInstanceClass()), Integer.TYPE)) ? "int" : (_name = propertyType.getName()));
            }
        }
        boolean _isMany = property.isMany();
        if (_isMany) {
            String _concat_2;
            if (needSpace) {
                String _concat_1;
                propertyTypeName = _concat_1 = propertyTypeName.concat(" ");
            }
            propertyTypeName = _concat_2 = propertyTypeName.concat("*");
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)propertyTypeName, "");
        _builder.append((Object)" ");
        _builder.append((Object)this.propertyName, "");
        _builder.append((Object)";");
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    @Override
    public CharSequence defaultValue(EClass e) {
        StringConcatenation _xblockexpression = null;
        EStructuralFeature property = e.getEStructuralFeature(this.propertyName);
        EClassifier propertyType = property.getEType();
        StringConcatenation _xifexpression = null;
        if ((propertyType instanceof EEnum || propertyType instanceof EClass || Objects.equal((Object)propertyType.getInstanceClass(), Boolean.TYPE) || Objects.equal((Object)propertyType.getInstanceClass(), Integer.TYPE)) && !property.isMany()) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)".");
            String _name = property.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)" = 0");
            _xifexpression = _builder;
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)".");
            String _name_1 = property.getName();
            _builder_1.append((Object)_name_1, "");
            _builder_1.append((Object)" = NULL");
            _xifexpression = _builder_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public DefaultPropertySerializer(String propertyName, EClassifier simplifiedPropertyType) {
        this.propertyName = propertyName;
        this.simplifiedPropertyType = simplifiedPropertyType;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.propertyName == null ? 0 : this.propertyName.hashCode());
        result = 31 * result + (this.simplifiedPropertyType == null ? 0 : this.simplifiedPropertyType.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultPropertySerializer other = (DefaultPropertySerializer)obj;
        if (this.propertyName == null ? other.propertyName != null : !this.propertyName.equals(other.propertyName)) {
            return false;
        }
        return !(this.simplifiedPropertyType == null ? other.simplifiedPropertyType != null : !this.simplifiedPropertyType.equals(other.simplifiedPropertyType));
    }

    @Pure
    public String toString() {
        String result = new ToStringBuilder((Object)this).addAllFields().toString();
        return result;
    }

    @Pure
    public String getPropertyName() {
        return this.propertyName;
    }

    @Pure
    public EClassifier getSimplifiedPropertyType() {
        return this.simplifiedPropertyType;
    }
}

